/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.PESessionLocker;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.WebPipeline;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;

public class MemoryStrategyBuilder
extends BasePersistenceStrategyBuilder
implements PersistenceStrategyBuilder {
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean) {
        super.initializePersistenceStrategy(ctx, smBean);
        String persistenceType = "memory";
        String ctxPath = ctx.getPath();
        if (ctxPath != null && !ctxPath.equals("")) {
            Object[] params = new Object[]{ctx.getPath(), persistenceType};
            this._logger.log(Level.FINE, "webcontainer.noPersistence", params);
        }
        StandardManager mgr = new StandardManager();
        if (this.sessionFilename == null) {
            mgr.setPathname(this.sessionFilename);
        } else {
            mgr.setPathname(this.prependContextPathTo(this.sessionFilename, ctx));
        }
        StandardContext sctx = (StandardContext)ctx;
        sctx.restrictedSetPipeline(new WebPipeline(sctx));
        mgr.setMaxActiveSessions(this.maxSessions);
        mgr.setSessionLocker(new PESessionLocker(ctx));
        ctx.setManager(mgr);
        if (!sctx.isSessionTimeoutOveridden()) {
            mgr.setMaxInactiveInterval(this.sessionMaxInactiveInterval);
        }
    }
}

