/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.FileCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileCacheFactory {
    public int secondsMaxAge = -1;
    public int maxCacheEntries = 1024;
    public long minEntrySize = 2048L;
    public long maxEntrySize = 537600L;
    public long maxLargeFileCacheSize = 0xA00000L;
    public long maxSmallFileCacheSize = 0x100000L;
    public static boolean isEnabled = true;
    public boolean isLargeFileCacheEnabled = true;
    public int port = 8080;
    private static ConcurrentHashMap<Integer, FileCacheFactory> cache = new ConcurrentHashMap();
    private ConcurrentLinkedQueue cacheManager;
    private boolean isMonitoringEnabled = false;
    protected FileCache fileCache;

    private FileCacheFactory() {
    }

    private static FileCacheFactory newInstance(int currentPort) {
        ConcurrentLinkedQueue cacheManager;
        FileCacheFactory fileCacheFactory = new FileCacheFactory();
        fileCacheFactory.port = currentPort;
        cache.put(currentPort, fileCacheFactory);
        fileCacheFactory.cacheManager = cacheManager = new ConcurrentLinkedQueue();
        return fileCacheFactory;
    }

    public static FileCacheFactory getFactory(int currentPort) {
        FileCacheFactory fileCacheFactory = cache.get(currentPort);
        if (fileCacheFactory == null) {
            fileCacheFactory = FileCacheFactory.newInstance(currentPort);
        }
        return fileCacheFactory;
    }

    public FileCache getFileCache() {
        if (this.fileCache == null) {
            this.fileCache = new FileCache();
            this.fileCache.setIsEnabled(isEnabled);
            this.fileCache.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
            this.fileCache.setSecondsMaxAge(this.secondsMaxAge);
            this.fileCache.setMaxCacheEntries(this.maxCacheEntries);
            this.fileCache.setMinEntrySize(this.minEntrySize);
            this.fileCache.setMaxEntrySize(this.maxEntrySize);
            this.fileCache.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
            this.fileCache.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
            this.fileCache.setCacheManager(this.cacheManager);
            FileCache.setIsMonitoringEnabled(this.isMonitoringEnabled);
        }
        return this.fileCache;
    }

    private void setCacheManager(ConcurrentLinkedQueue cacheManager) {
        this.cacheManager = cacheManager;
    }

    public ConcurrentHashMap getCache() {
        if (this.fileCache != null) {
            return this.fileCache.getCache();
        }
        return null;
    }

    public int getFlagEnabled() {
        return isEnabled ? 1 : 0;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public long getCountEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountEntries();
    }

    public long getMaxEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.maxCacheEntries;
    }

    public long getCountOpenEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountOpenEntries();
    }

    public long getMaxOpenEntries() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxOpenEntries();
    }

    public long getSizeHeapCache() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getSizeHeapCache();
    }

    public long getMaxHeapCacheSize() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxHeapCacheSize();
    }

    public long getSizeMmapCache() {
        if (this.fileCache == null) {
            return 0L;
        }
        FileCacheFactory fileCacheFactory = this;
        return fileCacheFactory.fileCache.getSizeMmapCache();
    }

    public long getMaxMmapCacheSize() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getMaxMmapCacheSize();
    }

    public long getCountHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountHits();
    }

    public long getCountMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountMisses();
    }

    public long getCountInfoHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountInfoHits();
    }

    public long getCountInfoMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountInfoMisses();
    }

    public long getCountContentHits() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountContentHits();
    }

    public long getCountContentMisses() {
        if (this.fileCache == null) {
            return 0L;
        }
        return this.fileCache.getCountContentMisses();
    }

    public void setIsMonitoringEnabled(boolean isMonitoringEnabled) {
        this.isMonitoringEnabled = isMonitoringEnabled;
        FileCache.setIsMonitoringEnabled(isMonitoringEnabled);
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setIsEnabled(boolean isE) {
        isEnabled = isE;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }
}

