/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.xml.ws.spi.runtime.MessageContext;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;
import java.util.logging.Level;

public class Ejb3SystemHandlerDelegate
implements SystemHandlerDelegate {
    private JAXWSEndpointImpl endpoint;
    private WsUtil wsUtil = new WsUtil();

    public Ejb3SystemHandlerDelegate(JAXWSEndpointImpl endpoint) {
        this.endpoint = endpoint;
    }

    public boolean processRequest(MessageContext messageContext) throws Exception {
        String messageID = (String)messageContext.get((Object)"MONITORING_MESSAGE_ID");
        System.out.println("process request : Message ID " + messageID);
        if (messageID != null || this.endpoint != null && this.endpoint.hasListeners()) {
            this.endpoint.processRequest(messageContext);
        }
        if (this.endpoint.getDescriptor().hasHandlerChain()) {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            Invocation inv = (Invocation)invManager.getCurrentInvocation();
            Container container = (Container)inv.container;
            Method m = messageContext.getMethod();
            if (m != null) {
                try {
                    inv.method = m;
                    inv.setWebServiceMethod(inv.method);
                    if (!container.authorize(inv)) {
                        inv.exception = new Exception("Client not authorized for invocation of " + inv.method);
                    }
                }
                catch (Exception e) {
                    String errorMsg = "Error unmarshalling method for ejb " + this.endpoint.getDescriptor().getEjbComponentImpl().getName();
                    inv.exception = new UnmarshalException(errorMsg);
                    inv.exception.initCause(e);
                }
            } else {
                inv.setWebServiceMethod(null);
            }
            if (inv.exception != null) {
                WsUtil.getDefaultLogger().log(Level.WARNING, "preRequestHandlerHook", inv.exception);
                this.wsUtil.throwSOAPFaultException(inv.exception.getMessage(), messageContext);
            }
        }
        return true;
    }

    public void preInvokeEndpointHook(MessageContext messageContext) {
        if (this.endpoint.getDescriptor().hasHandlerChain()) {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            Invocation inv = (Invocation)invManager.getCurrentInvocation();
            Container container = (Container)inv.container;
            Method m = messageContext.getMethod();
            if (m != null) {
                try {
                    Method webServiceMethodInPreHandler = inv.getWebServiceMethod();
                    if (webServiceMethodInPreHandler != null && !webServiceMethodInPreHandler.equals(m)) {
                        inv.exception = new UnmarshalException("Original method " + webServiceMethodInPreHandler + " does not match post-handler method " + m);
                    }
                }
                catch (Exception e) {
                    String errorMsg = "Exception while getting method for " + (inv != null ? ((Container)inv.container).getEjbDescriptor().getName() : "");
                    inv.exception = new UnmarshalException(errorMsg);
                    inv.exception.initCause(e);
                }
                if (inv.exception != null) {
                    WsUtil.getDefaultLogger().log(Level.WARNING, "postEjbHandlerError", inv.exception);
                    this.wsUtil.throwSOAPFaultException(inv.exception.getMessage(), messageContext);
                }
            }
        }
    }

    public void processResponse(MessageContext messageContext) throws Exception {
        String messageID = (String)messageContext.get((Object)"MONITORING_MESSAGE_ID");
        System.out.println("process response : Message ID " + messageID);
        if (messageID != null || this.endpoint != null && this.endpoint.hasListeners()) {
            this.endpoint.processResponse(messageContext);
        }
    }
}

