/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;

public class EjbContainerPreHandler
extends GenericHandler {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private WsUtil wsUtil = new WsUtil();

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleRequest(MessageContext context) {
        Invocation inv = null;
        Container container = null;
        try {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            inv = (Invocation)invManager.getCurrentInvocation();
            container = (Container)inv.container;
            inv.method = this.wsUtil.getInvMethod(inv.getWebServiceTie(), context);
            if (inv.method != null) {
                inv.setWebServiceMethod(inv.method);
                if (!container.authorize(inv)) {
                    inv.exception = new Exception("Client not authorized for invocation of " + inv.method);
                }
            } else {
                inv.setWebServiceMethod(null);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error unmarshalling method " + (container != null ? "for ejb " + container.getEjbDescriptor().getName() : "");
            inv.exception = new UnmarshalException(errorMsg);
            inv.exception.initCause(e);
        }
        if (inv.exception != null) {
            logger.log(Level.WARNING, "preEjbHandlerError", inv.exception);
            this.wsUtil.throwSOAPFaultException(inv.exception.getMessage(), context);
        }
        return true;
    }
}

