/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.spi.InvInterfaceCreationListener;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvInterfaceCreationListenerImpl
implements InvInterfaceCreationListener {
    ServiceReferenceDescriptor ref;

    public InvInterfaceCreationListenerImpl(ServiceReferenceDescriptor ref) {
        this.ref = ref;
    }

    @Override
    public <T> void portCreated(T port, Class<T> serviceEndpointInterface) {
        ServiceRefPortInfo portInfo = this.ref.getPortInfoBySEI(serviceEndpointInterface.getName());
        if (portInfo != null) {
            BindingProvider bProv = (BindingProvider)port;
            boolean mtomEnabled = false;
            if (portInfo.getMtomEnabled() != null && new Boolean(portInfo.getMtomEnabled()).booleanValue()) {
                mtomEnabled = true;
            }
            if (mtomEnabled) {
                Binding bType = bProv.getBinding();
                if (SOAPBinding.class.isAssignableFrom(bType.getClass())) {
                    ((SOAPBinding)bType).setMTOMEnabled(true);
                } else {
                    WsUtil.getDefaultLogger().log(Level.SEVERE, WsUtil.getDefaultStringManager().getLocalString("serviceref.invalidmtom", "MTOM is valid only for SOAP Bindings; Ignoring Enable-MTOM for port {0}", new Object[]{serviceEndpointInterface}));
                }
            }
            Set properties = portInfo.getStubProperties();
            for (NameValuePairDescriptor next : properties) {
                bProv.getRequestContext().put(next.getName(), next.getValue());
            }
        }
    }

    @Override
    public <T> void dispatchCreated(Dispatch<T> dispatch, Class<T> serviceEndpointInterface) {
    }
}

