/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.util.InjectionManagerImpl;
import com.sun.enterprise.webservice.JAXWSRuntimeEpiRegistry;
import com.sun.enterprise.webservice.JAXWSSystemHandlerDelegateFactory;
import com.sun.enterprise.webservice.WebServiceContextImpl;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.HttpResponseInfoImpl;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.enterprise.webservice.monitoring.ThreadLocalInfo;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceTesterServlet;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.server.Tie;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.MessageContext;
import org.apache.catalina.Loader;

public class JAXWSServlet
extends HttpServlet {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private ServletContext servletContext;
    private WebServiceEndpoint endpoint_;
    private WSRtObjectFactory rpcFactory_;
    private String urlPattern;
    private String contextRoot;
    private boolean jaxwsInitDone = false;
    private WebServiceEngineImpl wsEngine_;
    private JAXWSEndpointImpl endpointImpl_;
    ClassLoader classLoader;
    private Tie tie = new Tie();

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.servletContext = servletConfig.getServletContext();
            this.wsEngine_ = WebServiceEngineImpl.getInstance();
            this.doInit(servletConfig);
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        JAXWSRuntimeEpiRegistry.getInstance().removeRuntimeInfo(this.contextRoot);
        try {
            new WsUtil().doPreDestroy(this.endpoint_, this.classLoader);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "@PreDestroy lifecycle call failed for service" + this.endpoint_.getName(), t);
        }
        this.wsEngine_.removeHandler(this.endpoint_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Object endpt;
        Endpoint endpt2;
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint_.getProtocolBinding()) && (endpt2 = this.wsEngine_.getEndpoint(request.getRequestURL().toString())) != null && Boolean.parseBoolean(endpt2.getDescriptor().getDebugging())) {
            WebServiceTesterServlet.invoke(request, response, endpt2.getDescriptor());
            return;
        }
        String messageId = null;
        if (this.wsEngine_.getGlobalMessageListener() != null && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint_.getProtocolBinding()) && (messageId = this.wsEngine_.preProcessRequest((Endpoint)(endpt = this.wsEngine_.getEndpoint(request.getRequestURL().toString())))) != null) {
            ThreadLocalInfo config = new ThreadLocalInfo(messageId, request);
            this.wsEngine_.getThreadLocal().set(config);
        }
        if (!this.jaxwsInitDone) {
            endpt = this;
            synchronized (endpt) {
                if (!this.jaxwsInitDone) {
                    String path = request.getRequestURI().substring(request.getContextPath().length());
                    JAXWSRuntimeEpiRegistry.getInstance().getRuntimeEndpointInfo(this.contextRoot, this.urlPattern, path).init();
                    this.jaxwsInitDone = true;
                }
            }
        }
        try {
            MessageContext msgCtxt;
            WebServiceContext wsCtxt;
            WSConnection connection;
            RuntimeEndpointInfo targetEndpoint = this.getEndpointFor(request);
            if (targetEndpoint != null) {
                connection = this.rpcFactory_.createWSConnection(request, response);
                wsCtxt = targetEndpoint.getWebServiceContext();
                msgCtxt = this.rpcFactory_.createMessageContext();
                msgCtxt.put((Object)"javax.xml.ws.servlet.context", (Object)this.servletContext);
                msgCtxt.setScope("javax.xml.ws.servlet.context", MessageContext.Scope.APPLICATION);
                msgCtxt.put((Object)"javax.xml.ws.servlet.request", (Object)request);
                msgCtxt.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
                msgCtxt.put((Object)"javax.xml.ws.servlet.response", (Object)response);
                msgCtxt.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
                msgCtxt.put((Object)"MONITORING_MESSAGE_ID", (Object)messageId);
                msgCtxt.put((Object)"javax.xml.ws.http.request.method", (Object)request.getMethod());
                msgCtxt.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
                if (request.getQueryString() != null) {
                    msgCtxt.put((Object)"javax.xml.ws.http.request.querystring", (Object)request.getQueryString());
                    msgCtxt.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
                }
                if (request.getPathInfo() != null) {
                    msgCtxt.put((Object)"javax.xml.ws.http.request.pathinfo", (Object)request.getPathInfo());
                    msgCtxt.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
                }
            } else {
                throw new ServletException("Service not found");
            }
            msgCtxt.put((Object)"javax.xml.ws.http.request.headers", (Object)connection.getHeaders());
            msgCtxt.setScope("javax.xml.ws.http.request.headers", MessageContext.Scope.APPLICATION);
            wsCtxt.setMessageContext(msgCtxt);
            this.tie.handle(connection, targetEndpoint);
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
        if (messageId != null) {
            HttpResponseInfoImpl info = new HttpResponseInfoImpl(response);
            this.wsEngine_.postProcessResponse(messageId, info);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint_.getProtocolBinding())) {
            Endpoint endpt = this.wsEngine_.getEndpoint(request.getRequestURL().toString());
            if (endpt.getDescriptor().isSecure() || endpt.getDescriptor().getMessageSecurityBinding() != null) {
                String message = endpt.getDescriptor().getWebService().getName() + " is a secured webservice; Tester feature is not supported for secured services";
                new WsUtil().writeInvalidMethodType(response, message);
                return;
            }
            if (endpt != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                Loader loader = (Loader)endpt.getDescriptor().getBundleDescriptor().getExtraAttribute("WEBLOADER");
                if (loader != null) {
                    endpt.getDescriptor().getBundleDescriptor().setClassLoader(loader.getClassLoader());
                    endpt.getDescriptor().getBundleDescriptor().removeExtraAttribute("WEBLOADER");
                }
                WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
                return;
            }
        }
        if (!"WSDL".equalsIgnoreCase(request.getQueryString()) && "http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint_.getProtocolBinding())) {
            this.doPost(request, response);
            return;
        }
        WsUtil wsUtil = new WsUtil();
        try {
            wsUtil.handleGet(request, response, this.endpoint_);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + this.endpoint_.getEndpointName() + "' HTTP GET error", e);
        }
    }

    private void doInit(ServletConfig servletConfig) throws ServletException {
        String servletName = "unknown";
        try {
            InvocationManager invManager = Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            Object containerContext = inv.getContainerContext();
            WebBundleDescriptor webBundle = (WebBundleDescriptor)Switch.getSwitch().getDescriptorFor(containerContext);
            this.classLoader = Thread.currentThread().getContextClassLoader();
            servletName = servletConfig.getServletName();
            this.contextRoot = webBundle.getContextRoot();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
            if (webComponent != null) {
                WebServicesDescriptor webServices = webBundle.getWebServices();
                Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(webComponent);
                this.endpoint_ = endpoints.iterator().next();
                if (!"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint_.getProtocolBinding())) {
                    this.endpointImpl_ = (JAXWSEndpointImpl)this.wsEngine_.createHandler((SystemHandlerDelegate)null, this.endpoint_);
                }
            } else {
                throw new ServletException(servletName + " not found");
            }
            this.registerEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private void registerEndpoint() throws Exception {
        this.rpcFactory_ = WSRtObjectFactory.newInstance();
        RuntimeEndpointInfo endpointInfo = this.rpcFactory_.createRuntimeEndpointInfo();
        Object serviceEndpoint = Class.forName(this.endpoint_.getServletImplClass(), true, this.classLoader).newInstance();
        new InjectionManagerImpl().injectInstance(serviceEndpoint);
        endpointInfo.setImplementorClass(Class.forName(this.endpoint_.getServletImplClass(), true, this.classLoader));
        endpointInfo.setImplementor(serviceEndpoint);
        WebServiceContextImpl wsc = null;
        WebBundleDescriptor bundle = (WebBundleDescriptor)this.endpoint_.getBundleDescriptor();
        for (ResourceReferenceDescriptor r : bundle.getResourceReferenceDescriptors()) {
            if (!r.isWebServiceContext()) continue;
            try {
                InitialContext ic = new InitialContext();
                wsc = (WebServiceContext)ic.lookup("java:comp/env/" + r.getName());
            }
            catch (Throwable t) {}
        }
        if (wsc == null) {
            wsc = new WebServiceContextImpl();
        }
        endpointInfo.setWebServiceContext(wsc);
        String uri = this.endpoint_.getEndpointAddressUri();
        this.urlPattern = uri.startsWith("/") ? uri : "/" + uri;
        URL catalogURL = null;
        File catalogFile = new File(this.endpoint_.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (catalogFile.exists()) {
            catalogURL = catalogFile.toURL();
        }
        endpointInfo.setWsdlInfo(this.endpoint_.getWebService().getWsdlFileUrl(), this.rpcFactory_.createEntityResolver(catalogURL));
        endpointInfo.setServiceName(this.endpoint_.getServiceName());
        endpointInfo.setPortName(this.endpoint_.getWsdlPort());
        endpointInfo.setBinding(this.rpcFactory_.createBinding(this.endpoint_.getProtocolBinding()));
        WsUtil wsu = new WsUtil();
        wsu.setMtom((Binding)endpointInfo.getBinding(), this.endpoint_);
        wsu.configureJAXWSServiceHandlers(this.endpoint_, endpointInfo);
        SystemHandlerDelegate delegate = JAXWSSystemHandlerDelegateFactory.getServletDelegate(this.endpoint_);
        if (this.endpointImpl_ != null) {
            this.endpointImpl_.setParent(delegate);
            endpointInfo.getBinding().setSystemHandlerDelegate((SystemHandlerDelegate)this.endpointImpl_);
        } else {
            endpointInfo.getBinding().setSystemHandlerDelegate(delegate);
        }
        this.registerEndpointUrlPattern(endpointInfo);
        wsu.doPostConstruct(endpointInfo.getImplementorClass(), serviceEndpoint);
    }

    private void registerEndpointUrlPattern(RuntimeEndpointInfo info) {
        JAXWSRuntimeEpiRegistry.getInstance().addRuntimeEndpointInfo(this.contextRoot, this.urlPattern, info);
    }

    private RuntimeEndpointInfo getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return JAXWSRuntimeEpiRegistry.getInstance().getRuntimeEndpointInfo(this.contextRoot, this.urlPattern, path);
    }
}

