/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.apt;

import com.sun.enterprise.deployment.backend.ProcessWatcher;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceRef;

public class WebServiceRefAp
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment env;
    public static Logger logger = null;

    public WebServiceRefAp(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    public void process() {
        for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
            typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new ServiceRefVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
        }
    }

    private class ServiceRefVisitor
    extends SimpleDeclarationVisitor {
        private ServiceRefVisitor() {
        }

        public void visitClassDeclaration(ClassDeclaration d) {
            if (logger != null) {
                logger.fine("Processing " + d.getQualifiedName());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void visitFieldDeclaration(FieldDeclaration f) {
            WebServiceRef ref = (WebServiceRef)f.getAnnotation(WebServiceRef.class);
            if (ref == null) {
                return;
            }
            if (logger != null && logger.isLoggable(Level.FINE)) {
                logger.fine("Found " + f.getSimpleName() + " annotated with WebServiceRef");
                logger.fine("Name is " + ref.name());
                logger.fine("WSDL is " + ref.wsdlLocation());
                logger.fine("of type " + f.getType().toString());
            }
            if (ref.wsdlLocation() == null) return;
            if (ref.wsdlLocation().length() == 0) {
                return;
            }
            File server = new File(System.getProperty("com.sun.aas.installRoot"));
            File wsimport = new File(server = new File(server, "bin"), "wsimport");
            if (wsimport.exists()) {
                File classesDir = new File(System.getProperty("user.dir"));
                String outputDir = (String)WebServiceRefAp.this.env.getOptions().get("-d");
                if (outputDir != null) {
                    if (!new File(outputDir).isAbsolute()) {
                        classesDir = new File(classesDir, outputDir);
                    }
                    classesDir.mkdirs();
                }
                String wsc = wsimport.getAbsolutePath();
                String wscompileArgs = " -keep -d " + classesDir.getAbsolutePath() + " " + ref.wsdlLocation();
                if (logger != null) {
                    logger.log(Level.INFO, "Invoking wsimport with " + ref.wsdlLocation());
                } else {
                    System.out.println("Invoking " + wsimport.getAbsolutePath() + " with " + ref.wsdlLocation() + "in " + classesDir.getAbsolutePath());
                }
                String command = wsc + " " + wscompileArgs;
                if (logger != null && logger.isLoggable(Level.FINE)) {
                    logger.fine("Command " + command);
                }
                int exitValue = -1;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    ProcessWatcher pw = new ProcessWatcher(p);
                    exitValue = pw.watch();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (exitValue == 0) {
                    if (logger == null) return;
                    logger.log(Level.INFO, "wsimport successful");
                    return;
                }
                if (logger == null) return;
                logger.log(Level.SEVERE, "wsimport failed");
                return;
            }
            if (logger != null) {
                logger.log(Level.SEVERE, "Cannot find wsimport tool");
                return;
            }
            System.out.println("Cannot find wsimport");
        }
    }
}

