/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionHolder
implements Connection {
    protected Connection con;
    protected ManagedConnection mc;
    protected boolean wrappedAlready = false;
    protected boolean isClosed = false;
    protected boolean valid = true;
    protected boolean active = false;
    private LazyAssociatableConnectionManager lazyAssocCm_;
    private LazyEnlistableConnectionManager lazyEnlistCm_;
    private ConnectionRequestInfo cxReqInfo_;
    private ManagedConnectionFactory mcf_;
    private ConnectionType myType_ = ConnectionType.STANDARD;
    protected static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public ConnectionHolder(Connection con, ManagedConnection mc, ConnectionRequestInfo cxRequestInfo) {
        this.con = con;
        this.mc = mc;
        this.mcf_ = mc.mcf;
        this.cxReqInfo_ = cxRequestInfo;
    }

    Connection getConnection() {
        return this.con;
    }

    void wrapped(boolean wrapFlag) {
        this.wrappedAlready = wrapFlag;
    }

    boolean isWrapped() {
        return this.wrappedAlready;
    }

    ManagedConnection getManagedConnection() {
        return this.mc;
    }

    void associateConnection(Connection con, ManagedConnection mc) {
        this.mc = mc;
        this.con = con;
    }

    public void clearWarnings() throws SQLException {
        this.checkValidity();
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        this.isClosed = true;
        if (this.mc != null) {
            this.mc.connectionClosed(null, this);
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    void actualClose() throws SQLException {
        this.con.close();
    }

    public void commit() throws SQLException {
        this.checkValidity();
        this.con.commit();
    }

    public Statement createStatement() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkValidity();
        return this.con.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkValidity();
        return this.con.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.checkValidity();
        return this.con.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkValidity();
        return this.con.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkValidity();
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkValidity();
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkValidity();
        return this.con.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkValidity();
        return this.con.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.prepareStatement(sql, columnNames);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.checkValidity();
        this.con.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        this.con.setAutoCommit(autoCommit);
        this.mc.setLastAutoCommitValue(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
        this.con.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkValidity();
        this.con.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkValidity();
        this.con.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkValidity();
        this.con.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkValidity();
        this.con.setTypeMap(map);
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
        if (!this.valid) {
            throw new SQLException("Invalid Connection");
        }
        if (!this.active) {
            this.mc.checkIfActive(this);
        }
    }

    void setActive(boolean actv) {
        this.active = actv;
    }

    protected void jdbcPreInvoke() throws SQLException {
        if (this.myType_ == ConnectionType.LAZY_ASSOCIATABLE) {
            this.performLazyAssociation();
        } else if (this.myType_ == ConnectionType.LAZY_ENLISTABLE) {
            this.performLazyEnlistment();
        }
    }

    protected void performLazyEnlistment() throws SQLException {
        try {
            this.lazyEnlistCm_.lazyEnlist((javax.resource.spi.ManagedConnection)this.mc);
        }
        catch (ResourceException re) {
            String msg = sm.getString("jdbc.cannot_enlist", re.getMessage() + " Cannnot Enlist ManagedConnection");
            SQLException sqle = new SQLException(msg);
            sqle.initCause(re);
            throw sqle;
        }
    }

    protected void performLazyAssociation() throws SQLException {
        try {
            this.lazyAssocCm_.associateConnection((Object)this, this.mcf_, this.cxReqInfo_);
        }
        catch (ResourceException re) {
            String msg = sm.getString("jdbc.cannot_enlist", re.getMessage() + " Cannnot Enlist ManagedConnection");
            SQLException sqle = new SQLException(msg);
            sqle.initCause(re);
            throw sqle;
        }
    }

    public void setConnectionType(ConnectionType type) {
        this.myType_ = type;
    }

    public ConnectionType getConnectionType() {
        return this.myType_;
    }

    public void setLazyAssociatableConnectionManager(LazyAssociatableConnectionManager cm) {
        this.lazyAssocCm_ = cm;
    }

    public void setLazyEnlistableConnectionManager(LazyEnlistableConnectionManager cm) {
        this.lazyEnlistCm_ = cm;
    }

    public void setManagedConnection(ManagedConnection con) {
        this.mc = con;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionType {
        LAZY_ENLISTABLE,
        LAZY_ASSOCIATABLE,
        STANDARD;

    }
}

