/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;

public class DSManagedConnectionFactory
extends ManagedConnectionFactory {
    private transient DataSource dataSourceObj;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In createManagedConnection");
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        if (this.dataSourceObj == null) {
            if (this.dsObjBuilder == null) {
                this.dsObjBuilder = new DataSourceObjectBuilder(this.spec);
            }
            try {
                this.dataSourceObj = (DataSource)this.dsObjBuilder.constructDataSourceObject();
            }
            catch (ClassCastException cce) {
                _logger.log(Level.SEVERE, "jdbc.exc_cce", cce);
                throw new ResourceException(cce.getMessage());
            }
        }
        Connection dsConn = null;
        try {
            dsConn = this.isEqual(pc, this.getUser(), this.getPassword()) ? this.dataSourceObj.getConnection() : this.dataSourceObj.getConnection(pc.getUserName(), new String(pc.getPassword()));
        }
        catch (SQLException sqle) {
            _logger.log(Level.FINE, "jdbc.exc_create_conn", sqle.getMessage());
            StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);
            String msg = localStrings.getString("jdbc.cannot_allocate_connection", sqle.getMessage());
            ResourceAllocationException rae = new ResourceAllocationException(msg);
            rae.initCause((Throwable)sqle);
            throw rae;
        }
        ManagedConnection mc = this.constructManagedConnection(null, dsConn, pc, this);
        this.validateAndSetIsolation(mc);
        return mc;
    }

    public boolean equals(Object other) {
        if (this.logWriter != null) {
            this.logWriter.println("In equals");
        }
        if (other instanceof DSManagedConnectionFactory) {
            DSManagedConnectionFactory otherMCF = (DSManagedConnectionFactory)other;
            return this.spec.equals(otherMCF.spec);
        }
        return false;
    }
}

