/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogExtent;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogRecordEnding;
import com.sun.jts.CosTransactions.LogRecordHeader;

class LogCursor {
    static final int ASCENDING = 0;
    static final int DESCENDING = 1;
    LogCursor blockValid;
    LogControl logControl;
    LogHandle logHandle;
    LogLSN startLSN;
    LogLSN endLSN;
    LogLSN currentLSN;
    int direction;
    boolean symbolicsChecked;

    LogCursor(LogControl control, LogHandle handle, LogLSN startLSN, LogLSN endLSN) {
        this.logHandle = handle;
        this.logControl = control;
        this.startLSN = new LogLSN(startLSN);
        this.currentLSN = new LogLSN(startLSN);
        this.endLSN = new LogLSN(endLSN);
        this.direction = startLSN.lessThan(endLSN) ? 0 : 1;
        this.blockValid = this;
        this.symbolicsChecked = false;
    }

    public void finalize() {
        this.blockValid = null;
    }

    synchronized byte[] readCursor(int[] type, LogLSN LSNread) throws LogException {
        int bytesRead;
        if (this.blockValid != this) {
            throw new LogException(null, 20, 1);
        }
        if (this.logHandle == null || this.logHandle.blockValid != this.logHandle) {
            throw new LogException(null, 20, 2);
        }
        if (!this.logControl.logInitialised) {
            throw new LogException(null, 1, 3);
        }
        if (this.logHandle.logControlDescriptor.headLSN.isNULL()) {
            throw new LogException(null, 21, 5);
        }
        if (!this.symbolicsChecked) {
            if (this.currentLSN.equals(LogLSN.HEAD_LSN)) {
                this.currentLSN.copy(this.logHandle.logControlDescriptor.headLSN);
            } else if (this.currentLSN.equals(LogLSN.TAIL_LSN)) {
                this.currentLSN.copy(this.logHandle.logControlDescriptor.tailLSN);
            }
            this.symbolicsChecked = true;
        }
        if (this.currentLSN.greaterThan(this.logHandle.logControlDescriptor.headLSN) || this.currentLSN.lessThan(this.logHandle.logControlDescriptor.tailLSN)) {
            throw new LogException(null, 21, 6);
        }
        boolean recordRetrieved = false;
        LogExtent logEDP = null;
        LogRecordHeader logRH = null;
        LogRecordEnding logRE = null;
        while (!recordRetrieved) {
            logEDP = this.logHandle.positionFilePointer(this.currentLSN, 0, 1);
            byte[] headerBytes = new byte[32];
            bytesRead = 0;
            try {
                bytesRead = logEDP.fileHandle.fileRead(headerBytes);
            }
            catch (LogException le) {
                logEDP.lastAccess = 0;
                throw new LogException(null, 3, 8);
            }
            logRH = new LogRecordHeader(headerBytes, 0);
            logEDP.cursorPosition += bytesRead;
            if (!logRH.currentLSN.equals(this.currentLSN)) {
                throw new LogException(null, 4, 9);
            }
            if (logRH.recordType == 65536) {
                if (this.direction == 0) {
                    this.currentLSN.copy(logRH.nextLSN);
                    continue;
                }
                this.currentLSN.copy(logRH.previousLSN);
                continue;
            }
            recordRetrieved = true;
        }
        byte[][] readVect = new byte[][]{new byte[logRH.recordLength], new byte[8]};
        bytesRead = 0;
        try {
            bytesRead = logEDP.fileHandle.readVector(readVect);
        }
        catch (LogException le) {
            logEDP.lastAccess = 0;
            throw new LogException(null, le.errorCode, 11);
        }
        logEDP.cursorPosition += bytesRead;
        logRE = new LogRecordEnding(readVect[1], 0);
        if (!logRE.currentLSN.equals(this.currentLSN)) {
            throw new LogException(null, 4, 12);
        }
        if (this.direction == 0) {
            this.currentLSN.copy(logRH.nextLSN);
        } else {
            this.currentLSN.copy(logRH.previousLSN);
        }
        type[0] = logRH.recordType;
        LSNread.copy(logRH.currentLSN);
        return readVect[0];
    }
}

