/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSKeyBindingExtension;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Iterator;

public class EncryptionPolicy
extends WSSKeyBindingExtension {
    public EncryptionPolicy() {
        this.setPolicyIdentifier("EncryptionPolicy");
        this._featureBinding = new FeatureBinding();
    }

    public boolean equals(WSSPolicy policy) {
        boolean _assert = false;
        try {
            return this.equalsIgnoreTargets(policy);
        }
        catch (Exception exception) {
            return _assert;
        }
    }

    public boolean equalsIgnoreTargets(WSSPolicy policy) {
        boolean _assert = false;
        try {
            if (PolicyTypeUtil.encryptionPolicy(policy)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _assert;
    }

    public Object clone() {
        EncryptionPolicy ePolicy = new EncryptionPolicy();
        try {
            WSSPolicy fBinding = (WSSPolicy)this.getFeatureBinding();
            WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
            if (fBinding != null) {
                ePolicy.setFeatureBinding((MLSPolicy)fBinding.clone());
            }
            if (kBinding != null) {
                ePolicy.setKeyBinding((MLSPolicy)kBinding.clone());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ePolicy;
    }

    public String getType() {
        return "EncryptionPolicy";
    }

    public static class FeatureBinding
    extends WSSPolicy {
        String _dataEncryptionAlgorithm = "";
        ArrayList _targets = new ArrayList();

        public FeatureBinding() {
            this.setPolicyIdentifier("EncryptionPolicy.FeatureBinding");
        }

        public String getDataEncryptionAlgorithm() {
            return this._dataEncryptionAlgorithm;
        }

        public void setDataEncryptionAlgorithm(String algorithm) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not set DateEncryptionAlgorithm : Policy is ReadOnly");
            }
            this._dataEncryptionAlgorithm = algorithm;
        }

        public ArrayList getTargetBindings() {
            return this._targets;
        }

        public void addTargetBinding(EncryptionTarget target) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not add Target : Policy is ReadOnly");
            }
            this._targets.add(target);
        }

        public void addTargetBinding(Target target) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not add Target : Policy is ReadOnly");
            }
            this._targets.add(new EncryptionTarget(target));
        }

        public void removeTargetBindings(ArrayList targets) {
            if (this.isReadOnly()) {
                throw new RuntimeException("Can not remove Target : Policy is ReadOnly");
            }
            this._targets.removeAll(targets);
        }

        public boolean equals(WSSPolicy policy) {
            boolean assrt = false;
            try {
                FeatureBinding fBinding = (FeatureBinding)policy;
                assrt = this._targets.equals(fBinding.getTargetBindings());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return assrt;
        }

        public boolean equalsIgnoreTargets(WSSPolicy policy) {
            return true;
        }

        public Object clone() {
            FeatureBinding fBinding = new FeatureBinding();
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator i = this.getTargetBindings().iterator();
                while (i.hasNext()) {
                    list.add(((EncryptionTarget)i.next()).clone());
                }
                fBinding.getTargetBindings().addAll(list);
                WSSPolicy kBinding = (WSSPolicy)this.getKeyBinding();
                fBinding.setDataEncryptionAlgorithm(this.getDataEncryptionAlgorithm());
                if (kBinding != null) {
                    fBinding.setKeyBinding((MLSPolicy)kBinding.clone());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return fBinding;
        }

        public String getType() {
            return "EncryptionPolicy.FeatureBinding";
        }
    }
}

