/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.Rule;
import java.lang.reflect.Constructor;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.xml.sax.Attributes;

final class CreateLoaderRule
extends Rule {
    private String attributeName;
    private String loaderClass;

    public CreateLoaderRule(Digester digester, String loaderClass, String attributeName) {
        super(digester);
        this.loaderClass = loaderClass;
        this.attributeName = attributeName;
    }

    public void begin(Attributes attributes) throws Exception {
        String value;
        Container container = (Container)this.digester.peek();
        ClassLoader parentClassLoader = container.getParentClassLoader();
        String className = this.loaderClass;
        if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
            className = value;
        }
        Class<?> clazz = Class.forName(className);
        Class[] types = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{parentClassLoader};
        Constructor<?> constructor = clazz.getDeclaredConstructor(types);
        Loader loader = (Loader)constructor.newInstance(args);
        this.digester.push(loader);
        if (this.digester.getDebug() >= 1) {
            this.digester.log("new " + loader.getClass().getName());
        }
    }

    public void end() throws Exception {
        Loader loader = (Loader)this.digester.pop();
        if (this.digester.getDebug() >= 1) {
            this.digester.log("pop " + loader.getClass().getName());
        }
    }
}

