/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;

public class DirectoryLoader
extends ClassLoader {
    private Hashtable cache;
    private File root;

    public DirectoryLoader(File rootDir) {
        this.cache = new Hashtable();
        if (rootDir == null || !rootDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.root = rootDir;
    }

    private DirectoryLoader() {
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> result = (Class<?>)this.cache.get(className);
        if (result == null) {
            try {
                result = super.findSystemClass(className);
            }
            catch (ClassNotFoundException e) {
                byte[] classData = this.getClassFileData(className);
                if (classData == null) {
                    throw new ClassNotFoundException();
                }
                result = this.defineClass(classData, 0, classData.length);
                if (result == null) {
                    throw new ClassFormatError();
                }
                if (resolve) {
                    this.resolveClass(result);
                }
                this.cache.put(className, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassFileData(String className) {
        byte[] result = null;
        FileInputStream stream = null;
        File classFile = new File(this.root, className.replace('.', File.separatorChar) + ".class");
        try {
            stream = new FileInputStream(classFile);
            result = new byte[stream.available()];
            stream.read(result);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable e) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable e) {}
            }
        }
        return result;
    }
}

