/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBElementProperties;
import org.netbeans.modules.dbschema.DBElementProvider;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.nodes.IconStrings;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public abstract class DBElementNode
extends AbstractNode
implements IconStrings,
DBElementProperties,
Node.Cookie {
    private static final String[] ICON_AFFECTING_PROPERTIES = new String[0];
    protected DBElement element;
    protected boolean writeable;
    private transient PropertyChangeListener listener;
    static /* synthetic */ Class class$org$netbeans$modules$dbschema$nodes$DBElementNode;

    public DBElementNode(DBElement dBElement, Children children, boolean bl) {
        super(children);
        this.element = dBElement;
        this.writeable = bl;
        this.setIconBase(this.resolveIconBase());
        this.setName(dBElement.getName().getName());
        this.setDisplayName(dBElement.getName().getName());
        this.listener = new ElementListener();
        dBElement.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)dBElement));
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("dbschema_ctxhelp_wizard");
    }

    public boolean canRename() {
        return this.writeable;
    }

    public boolean canDestroy() {
        return this.writeable;
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put((ExTransferable.Single)new ElementStringTransferable());
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.writeable) {
            throw new IOException();
        }
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCut());
        exTransferable.put((ExTransferable.Single)new ElementStringTransferable());
        return exTransferable;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.writeable;
    }

    public void setActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie == null && (clazz.isAssignableFrom(DBElementProvider.class) || clazz.isAssignableFrom(DBElement.class))) {
            cookie = new DBElementProvider(this.element);
        }
        return cookie;
    }

    public boolean equals(Object object) {
        return object instanceof DBElementNode && this.element.equals(((DBElementNode)object).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    protected Node.Property createNameProperty(boolean bl) {
        return new ElementProp("name", String.class, bl){

            public Object getValue() {
                return DBElementNode.this.element.getName().getFullName();
            }
        };
    }

    void superSetName(String string) {
        super.setName(string);
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String string, Class clazz, boolean bl) {
            super(string, clazz, NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DBElementNode == null ? (class$org$netbeans$modules$dbschema$nodes$DBElementNode = DBElementNode.class$("org.netbeans.modules.dbschema.nodes.DBElementNode")) : class$org$netbeans$modules$dbschema$nodes$DBElementNode), (String)("PROP_" + string)), NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DBElementNode == null ? (class$org$netbeans$modules$dbschema$nodes$DBElementNode = DBElementNode.class$("org.netbeans.modules.dbschema.nodes.DBElementNode")) : class$org$netbeans$modules$dbschema$nodes$DBElementNode), (String)("HINT_" + string)), true, bl);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(NbBundle.getMessage((Class)(class$org$netbeans$modules$dbschema$nodes$DBElementNode == null ? (class$org$netbeans$modules$dbschema$nodes$DBElementNode = DBElementNode.class$("org.netbeans.modules.dbschema.nodes.DBElementNode")) : class$org$netbeans$modules$dbschema$nodes$DBElementNode), (String)"MSG_Cannot_Write"));
            }
        }
    }

    private class ElementListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                DBElementNode.this.setIconBase(DBElementNode.this.resolveIconBase());
            } else {
                String[] stringArray = DBElementNode.this.getIconAffectingProperties();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    DBElementNode.this.setIconBase(DBElementNode.this.resolveIconBase());
                    break;
                }
                if (string.equals("name")) {
                    try {
                        DBElementNode.this.superSetName(((DBMemberElement)DBElementNode.this.element).getName().toString());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (string.equals("cookie")) {
                    DBElementNode.this.superFireCookieChange();
                    return;
                }
            }
            DBElementNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return DBElementNode.this.element.toString();
        }
    }
}

