/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class CallflowCommand
extends S1ASCommand {
    private static final String FILTER_TYPE_OPTION = "filtertype";
    private static final String CALLER_IPFILTER = "CallerIPFilter";
    private static final String CALLER_PRINCIPALFILTER = "CallerPrincipalFilter";
    private static final String ENABLED = "Enabled";
    private static final String FILTER_TYPE_USER = "user";
    private static final String FILTER_TYPE_IP = "ip";
    private static final String START_CALL_FLOW = "start-callflow-monitoring";
    private String sFilterIP = null;
    private String sFilterUserID = null;

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String objectName = this.getObjectName();
        try {
            mbsc.setAttributes(new ObjectName(objectName), this.createCallflowAttributeList());
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    private AttributeList createCallflowAttributeList() throws CommandException, CommandValidationException {
        this.validateFilterType();
        boolean bEnable = this.name.equals(START_CALL_FLOW);
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute(ENABLED, bEnable));
        if (this.sFilterIP != null) {
            attrList.add(new Attribute(CALLER_IPFILTER, this.sFilterIP));
        }
        if (this.sFilterUserID != null) {
            attrList.add(new Attribute(CALLER_PRINCIPALFILTER, this.sFilterUserID));
        }
        return attrList;
    }

    private void validateFilterType() throws CommandException, CommandValidationException {
        if (this.getOption(FILTER_TYPE_OPTION) != null) {
            String filterType = this.getOption(FILTER_TYPE_OPTION);
            CLITokenizer filterTypeTok = new CLITokenizer(filterType, ":");
            while (filterTypeTok.hasMoreTokens()) {
                String nameAndvalue = filterTypeTok.nextToken();
                CLITokenizer nameTok = new CLITokenizer(nameAndvalue, "=");
                if (nameTok.countTokens() == 2) {
                    String sName = nameTok.nextTokenWithoutEscapeAndQuoteChars();
                    String sValue = nameTok.nextTokenWithoutEscapeAndQuoteChars();
                    if (sName.equals(FILTER_TYPE_IP)) {
                        this.sFilterIP = sValue;
                        continue;
                    }
                    if (sName.equals(FILTER_TYPE_USER)) {
                        this.sFilterUserID = sValue;
                        continue;
                    }
                    throw new CommandValidationException(this.getLocalizedString("InvalidFilterName", new Object[]{sName}));
                }
                throw new CommandValidationException(this.getLocalizedString("InvalidFilterType", new Object[]{filterType}));
            }
        }
    }
}

