/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ShowComponentStatusCommand
extends S1ASCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.displayComponentStatus(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private void displayComponentStatus(Object returnValue) throws CommandException {
        String componentName = (String)this.getOperands().get(0);
        if (returnValue == null) {
            throw new CommandException(this.getLocalizedString("UndetermineStatus", new Object[]{componentName}));
        }
        String returnValClassName = returnValue.getClass().getName();
        if (returnValClassName.equals(BOOLEAN_CLASS)) {
            boolean status = (Boolean)returnValue;
            if (status) {
                CLILogger.getInstance().printMessage(this.getLocalizedString("ComponentIsEnabled", new Object[]{componentName}));
            } else {
                CLILogger.getInstance().printMessage(this.getLocalizedString("ComponentIsDisabled", new Object[]{componentName}));
            }
        } else {
            throw new CommandException(this.getLocalizedString("UndetermineStatus", new Object[]{componentName}));
        }
    }
}

