/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CCClientSniffer {
    private HttpServletRequest request = null;
    private String agent = null;
    private String version = null;
    private int major = -1;

    public CCClientSniffer(HttpServletRequest request) {
        StringTokenizer st;
        this.request = request;
        this.agent = this.getUserAgent().toLowerCase();
        if (this.agent != null) {
            st = new StringTokenizer(this.agent, "/");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.version = st.nextToken();
            }
            if (this.version != null && (st = new StringTokenizer(this.version)).hasMoreTokens()) {
                this.version = st.nextToken();
            }
        }
        if (this.version != null && (st = new StringTokenizer(this.version, ".")).hasMoreTokens()) {
            try {
                this.major = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getUserAgent() {
        String s = null;
        if (this.request != null) {
            s = this.request.getHeader("USER-AGENT");
        }
        return s;
    }

    public int getUserAgentMajor() {
        return this.major;
    }

    public boolean isWin() {
        boolean result = false;
        if (this.agent != null && (this.agent.indexOf("win") != -1 || this.agent.indexOf("16bit") != -1)) {
            result = true;
        }
        return result;
    }

    public boolean isSun() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("sunos") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isGecko() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("gecko") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav() {
        boolean result = false;
        if (!(this.agent == null || this.agent.indexOf("mozilla") == -1 || this.agent.indexOf("spoofer") != -1 || this.agent.indexOf("compatible") != -1 || this.agent.indexOf("opera") != -1 || this.agent.indexOf("webtv") != -1 || this.agent.indexOf("hotjava") != -1 || this.isGecko() && this.agent.indexOf("netscape") == -1)) {
            result = true;
        }
        return result;
    }

    public boolean isNav4() {
        boolean result = false;
        if (this.isNav() && this.major == 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav4up() {
        boolean result = false;
        if (this.isNav() && this.major >= 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav6() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape6") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav6up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5) {
            result = true;
        }
        return result;
    }

    public boolean isNav7() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav70() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7.0") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav7up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5 && !this.isNav4() && !this.isNav6()) {
            result = true;
        }
        return result;
    }

    public boolean isIe() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("msie") != -1 && this.agent.indexOf("opera") == -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe3() {
        boolean result = false;
        if (this.isIe() && this.major < 4) {
            result = true;
        }
        return result;
    }

    public boolean isIe4() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 4") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe5() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 5") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe5up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4()) {
            result = true;
        }
        return result;
    }

    public boolean isIe6() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 6") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe6up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4() && !this.isIe5()) {
            result = true;
        }
        return result;
    }
}

