/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCTopologyModel;
import com.sun.web.ui.model.CCTopologyModelInterface;
import com.sun.web.ui.model.CCTopologyNode;
import com.sun.web.ui.model.TierNodeFactory;

public class CCTopologyGroupNode
extends CCTopologyNode
implements CCTopologyModelInterface.GroupNode {
    public static final String DIFFERENT_SEPARATOR = "..";
    public static final String SIMILAR_SEPARATOR = "-";
    protected CCTopologyModelInterface.Node[] nodes;
    protected boolean isExpanded;
    protected boolean useSubnodeRollup;
    protected boolean usesPluralIcon;

    public CCTopologyGroupNode(String id, String label, CCTopologyModelInterface.Node[] nodes) {
        super(id, label);
        this.setNodes(nodes);
        this.setAction(0);
        this.setBadgeAction(0);
        this.useSubnodeRollup = true;
        this.usesPluralIcon = true;
    }

    public CCTopologyGroupNode(String id, String label, CCTopologyModelInterface.Node[] nodes, boolean isExpanded, int icon, boolean usesPluralIcon) {
        super(id, label, null, 0, true, icon, 0, null, 0);
        this.setNodes(nodes);
        this.isExpanded = isExpanded;
        this.usesPluralIcon = usesPluralIcon;
        this.useSubnodeRollup = false;
    }

    public CCTopologyModelInterface.Node[] getNodes() {
        return this.nodes;
    }

    public void setNodes(CCTopologyModelInterface.Node[] nodes) {
        this.nodes = nodes;
        if (nodes != null) {
            for (int n = 0; n < nodes.length; ++n) {
                if (nodes[n] != null) continue;
                throw new IllegalArgumentException("CCTopologyGroupNode.setNodes: nodes[" + n + "] = null");
            }
        }
    }

    public int getIcon() {
        if (this.icon == 0 && this.useSubnodeRollup && this.nodes != null && this.nodes.length > 0) {
            return this.nodes[0].getIcon();
        }
        return this.icon;
    }

    public boolean isInFilter() {
        if (this.useSubnodeRollup) {
            boolean childInFilter = false;
            if (this.nodes != null) {
                for (int n = 0; n < this.nodes.length; ++n) {
                    childInFilter |= this.nodes[n].isInFilter();
                }
            }
            return childInFilter;
        }
        return this.inFilter;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public boolean usesPluralIcon() {
        return this.usesPluralIcon;
    }

    public void setPluralIcon(boolean usesPluralIcon) {
        this.usesPluralIcon = usesPluralIcon;
    }

    public boolean usesSubnodeRollup() {
        return this.useSubnodeRollup;
    }

    public void setSubnodeRollup(boolean useSubnodeRollup) {
        this.useSubnodeRollup = useSubnodeRollup;
    }

    public static CCTopologyModelInterface createGroupModel(CCTopologyModelInterface model, boolean allowNestedGrouping) {
        return CCTopologyGroupNode.createGroupModel(model, allowNestedGrouping, 12, 1);
    }

    public static CCTopologyModelInterface createGroupModel(CCTopologyModelInterface model, boolean allowNestedGrouping, int maxNodesPerGroup, int primaryTier) {
        if (model == null) {
            throw new IllegalArgumentException("CCTopologyGroupNode.createGroupModel: model param cannot be null");
        }
        if (maxNodesPerGroup < 1) {
            throw new IllegalArgumentException("CCTopologyGroupNode.createGroupModel: maxNodesPerGroup param cannot be less than 1");
        }
        if (primaryTier < 0 || primaryTier > 2) {
            throw new IllegalArgumentException("CCTopologyGroupNode.createGroupModel: primaryTier param must have a value of 1, 2 or 3");
        }
        int tierCount = model.getTierCount();
        if (tierCount == 0) {
            return model;
        }
        CCTopologyModelInterface.Edge[] edges = model.getEdges();
        CCTopologyModelInterface.Node[][] tierNodes = new CCTopologyModelInterface.Node[tierCount][];
        for (int t = 0; t < tierCount; ++t) {
            tierNodes[t] = model.getTierNodes(t);
        }
        TierNodeFactory tierNodeFactory = new TierNodeFactory();
        CCTopologyModelInterface.Node[][] newTierNodes = tierNodeFactory.getTierNodes(tierNodes, tierCount, primaryTier, edges, allowNestedGrouping, maxNodesPerGroup);
        return new CCTopologyModel(newTierNodes, model.getEdges(), model.getIconSet(), model.getBadgeSet(), model.getActionSet());
    }
}

