/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCDefaultActionSet;
import com.sun.web.ui.model.CCDefaultBadgeSet;
import com.sun.web.ui.model.CCDefaultIconSet;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class CCTopologyModel
implements CCTopologyModelInterface {
    protected CCTopologyModelInterface.Node[][] tierNodes;
    protected CCTopologyModelInterface.Edge[] edges;
    protected CCTopologyModelInterface.IconSet iconSet;
    protected CCTopologyModelInterface.BadgeSet badgeSet;
    protected CCTopologyModelInterface.ActionSet actionSet;
    protected Map nodeMap = new HashMap();
    protected Map edgeMap = new HashMap();
    private String jatoName;
    private Map jatoValues;

    public CCTopologyModel() {
    }

    public CCTopologyModel(ServletContext context) {
        this.iconSet = new CCDefaultIconSet(context);
        this.badgeSet = new CCDefaultBadgeSet(context);
        this.actionSet = new CCDefaultActionSet();
    }

    public CCTopologyModel(CCTopologyModelInterface.Node[][] tierNodes, CCTopologyModelInterface.Edge[] edges, CCTopologyModelInterface.IconSet iconSet, CCTopologyModelInterface.BadgeSet badgeSet, CCTopologyModelInterface.ActionSet actionSet) {
        this.setTierNodes(tierNodes);
        this.setEdges(edges);
        this.iconSet = iconSet;
        this.badgeSet = badgeSet;
        this.actionSet = actionSet;
    }

    public int getTierCount() {
        return this.tierNodes == null ? 0 : this.tierNodes.length;
    }

    public CCTopologyModelInterface.Node[] getTierNodes(int tier) {
        if (tier < 0 || tier >= this.getTierCount() || this.tierNodes[tier] == null) {
            return new CCTopologyModelInterface.Node[0];
        }
        return this.tierNodes[tier];
    }

    public void setTierNodes(CCTopologyModelInterface.Node[][] tierNodes) {
        HashMap newNodeMap = new HashMap();
        if (tierNodes != null) {
            for (int t = 0; t < tierNodes.length; ++t) {
                this.addNodesToMap(newNodeMap, tierNodes[t], t);
            }
        }
        this.tierNodes = tierNodes;
        this.nodeMap = newNodeMap;
    }

    private void addNodesToMap(Map nodeMap, CCTopologyModelInterface.Node[] nodes, int tier) {
        if (nodes != null) {
            for (int n = 0; n < nodes.length; ++n) {
                CCTopologyModelInterface.Node node = nodes[n];
                if (node == null) {
                    throw new IllegalArgumentException("tierNodes[" + tier + "]...[" + n + "] == null");
                }
                nodeMap.put(node.getId(), node);
                if (!(node instanceof CCTopologyModelInterface.GroupNode)) continue;
                this.addNodesToMap(nodeMap, ((CCTopologyModelInterface.GroupNode)node).getNodes(), tier);
            }
        }
    }

    public CCTopologyModelInterface.Edge[] getEdges() {
        return this.edges == null ? new CCTopologyModelInterface.Edge[]{} : this.edges;
    }

    public void setEdges(CCTopologyModelInterface.Edge[] edges) {
        HashMap<String, CCTopologyModelInterface.Edge> newEdgeMap = new HashMap<String, CCTopologyModelInterface.Edge>();
        if (edges != null) {
            for (int e = 0; e < edges.length; ++e) {
                CCTopologyModelInterface.Edge edge = edges[e];
                if (edge == null) {
                    throw new IllegalArgumentException("edges[" + e + "] == null");
                }
                newEdgeMap.put(edge.getId(), edge);
            }
        }
        this.edges = edges;
        this.edgeMap = newEdgeMap;
    }

    public CCTopologyModelInterface.IconSet getIconSet() {
        return this.iconSet;
    }

    public void setIconSet(CCTopologyModelInterface.IconSet iconSet) {
        this.iconSet = iconSet;
    }

    public CCTopologyModelInterface.BadgeSet getBadgeSet() {
        return this.badgeSet;
    }

    public void setBadgeSet(CCTopologyModelInterface.BadgeSet badgeSet) {
        this.badgeSet = badgeSet;
    }

    public CCTopologyModelInterface.ActionSet getActionSet() {
        return this.actionSet;
    }

    public void setActionSet(CCTopologyModelInterface.ActionSet actionSet) {
        this.actionSet = actionSet;
    }

    public CCTopologyModelInterface.Node getNode(String nodeId) {
        return (CCTopologyModelInterface.Node)this.nodeMap.get(nodeId);
    }

    public CCTopologyModelInterface.Edge getEdge(String edgeId) {
        return (CCTopologyModelInterface.Edge)this.edgeMap.get(edgeId);
    }

    public String getName() {
        return this.jatoName != null ? this.jatoName : "TopologyModel_" + this.hashCode();
    }

    public Object getValue(String name) {
        return this.jatoValues != null ? this.jatoValues.get(name) : null;
    }

    public Object[] getValues(String name) {
        Object value = this.getValue(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public void setName(String name) {
        this.jatoName = name;
    }

    public synchronized void setValue(String name, Object value) {
        if (this.jatoValues == null) {
            this.jatoValues = new HashMap();
        }
        this.jatoValues.put(name, value);
    }

    public void setValues(String name, Object[] values) {
        this.setValue(name, values);
    }
}

