/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.alert;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.alert.CCAlertTag;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import com.sun.web.ui.taglib.help.CCHelpInlineTag;
import com.sun.web.ui.taglib.html.CCImageTag;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCImageField;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCAlertInlineTag
extends CCAlertTag {
    protected static final String ATTRIB_DETAIL = "detail";
    protected static final String ATTRIB_ESCAPE = "escape";
    protected static final String ATTRIB_SUMMARY = "summary";
    protected String detail;
    protected String summary;
    private String alertStyle = "AlrtErrTxt";
    private String image = CCImage.ALERT_ERROR_LARGE;
    private String imageHeight = "21";
    private String imageWidth = "21";
    private String imageAltText = "alert.errorImageAltText";
    private final String OPEN_HELP_WINDOW_TAG = "<helpwindow";
    private final String CLOSE_HELP_WINDOW_TAG = "</helpwindow>";
    private static final String imageVspace = "3";
    private static final String onLoadScript = "; javascript: try { ccScroll.reset(); } catch (er) { /* expected if ccScroll not in use */ }; ";

    public void reset() {
        super.reset();
        this.alertStyle = "AlrtErrTxt";
        this.image = CCImage.ALERT_ERROR_LARGE;
        this.imageHeight = "21";
        this.imageWidth = "21";
        this.imageAltText = "alert.errorImageAltText";
        this.summary = null;
        this.detail = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        this.checkAndSetParent(parent, pageContext, view);
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCAlertInline.class);
        CCAlertInline container = (CCAlertInline)view;
        this.setAttributes(container);
        if (this.summary == null || this.summary.trim().length() == 0) {
            return "";
        }
        this.initProperties();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(1024);
        if (!this.isNav4()) {
            CCHtmlHeaderTag headerTag = (CCHtmlHeaderTag)CCAlertInlineTag.findAncestorWithClass((Tag)this, (Class)CCHtmlHeaderTag.class);
            if (headerTag != null) {
                String onLoad = headerTag.getOnLoad() != null ? headerTag.getOnLoad() : "";
                headerTag.setOnLoad(onLoad + onLoadScript);
            }
        }
        this.summary = this.formatSummary(container);
        buffer.append("<table align=\"center\" border=\"0\" cellpadding=\"0\"").append(" cellspacing=\"0\" class=\"").append("AlrtTbl").append("\" title=\"\">\n").append("<tr>\n").append("<td valign=\"middle\">\n").append("<div class=\"").append(this.alertStyle).append("\"> ").append(this.getAlertImageHTML(container)).append(this.summary).append("</div>\n");
        this.appendDetail(container, buffer);
        buffer.append("</td></tr></table>");
        return buffer.toString();
    }

    protected void setAttributes(CCAlertInline container) {
        this.summary = container.getSummary() != null ? container.getSummary() : this.getSummary();
        String string = this.detail = container.getDetail() != null ? container.getDetail() : this.getDetail();
        if (container.getValue() != null) {
            this.setDefaultValue(container.getValue().toString());
        }
    }

    private void initProperties() {
        String type = this.getDefaultValue();
        if (type.toLowerCase().equals("info")) {
            this.alertStyle = "AlrtInfTxt";
            this.imageAltText = "alert.infoImageAltText";
            this.image = CCImage.ALERT_INFO_LARGE;
            this.imageHeight = "21";
            this.imageWidth = "21";
        } else if (type.toLowerCase().equals("warning")) {
            this.alertStyle = "AlrtWrnTxt";
            this.imageAltText = "alert.warningImageAltText";
            this.image = CCImage.ALERT_WARNING_LARGE;
            this.imageHeight = "21";
            this.imageWidth = "21";
        } else {
            this.alertStyle = "AlrtErrTxt";
            this.imageAltText = "alert.errorImageAltText";
            this.image = CCImage.ALERT_ERROR_LARGE;
            this.imageHeight = "21";
            this.imageWidth = "21";
        }
    }

    private String formatSummary(CCAlertInline container) {
        String fmtSummary = container.getSummaryArgs() != null ? this.getMessage(this.summary, container.getSummaryArgs()) : this.getMessage(this.summary);
        fmtSummary = this.getEscape() == null || this.isTrue(this.getEscape()) ? HtmlUtil.escape((String)fmtSummary) : fmtSummary;
        return fmtSummary;
    }

    private void appendDetail(CCAlertInline container, NonSyncStringBuffer buffer) throws JspException {
        if (this.detail == null || this.detail.trim().length() == 0) {
            return;
        }
        String fmtDetail = container.getDetailArgs() != null ? this.getMessage(this.detail, container.getDetailArgs()) : this.getMessage(this.detail);
        CCHelpInlineTag helpInlineTag = new CCHelpInlineTag();
        helpInlineTag.setStyleClass("AlrtLnk");
        fmtDetail = helpInlineTag.parseHelpTags(this.getParent(), this.pageContext, fmtDetail);
        this.appendDetailWithLinks(fmtDetail, buffer);
    }

    private void appendDetailWithLinks(String detail, NonSyncStringBuffer buffer) {
        String closingAnchor = "</a>";
        String closingDiv = "</div>\n";
        String openingAnchor = "<a href";
        String openingLnkDiv = "<div class=\"AlrtLnkDiv\">";
        String openingMsgDiv = "<div class=\"AlrtMsgTxt\">";
        buffer.append(openingMsgDiv);
        StringBuffer newDetail = new StringBuffer(detail);
        int index = detail.toLowerCase().indexOf(openingAnchor);
        if (index != -1) {
            newDetail.insert(index, openingLnkDiv);
            newDetail.insert(index, closingDiv);
            index = newDetail.toString().toLowerCase().indexOf(closingAnchor, index);
            if (index != -1) {
                newDetail.insert(index += closingAnchor.length(), closingDiv);
                buffer.append((Object)newDetail);
            } else {
                buffer.append((Object)newDetail).append(closingAnchor).append(closingDiv);
            }
        } else {
            buffer.append(detail).append(closingDiv);
        }
    }

    private String getAlertImageHTML(CCAlertInline container) throws JspException {
        CCImageTag ccImageTag = new CCImageTag();
        View child = container.getChild("AlertImage");
        this.checkChildType(child, CCImageField.class);
        CCImageField ccImageField = (CCImageField)child;
        ccImageTag.setBundleID("com.sun.web.ui");
        ccImageTag.setAlt(this.getTagMessage(this.imageAltText));
        ccImageTag.setDefaultValue(this.image);
        ccImageTag.setHeight(this.imageHeight);
        ccImageTag.setWidth(this.imageWidth);
        return ccImageTag.getHTMLString(this.getParent(), this.pageContext, (View)ccImageField);
    }

    public String getDefaultValue() {
        String type = (String)this.getValue("defaultValue");
        if (type == null || !type.equalsIgnoreCase("error") && !type.equalsIgnoreCase("info") && !type.equalsIgnoreCase("warning")) {
            CCDebug.trace1("Invalid defaultValue");
            return "error";
        }
        return type;
    }

    public void setDefaultValue(String value) {
        this.setValue("defaultValue", value);
    }

    public String getDetail() {
        return (String)this.getValue(ATTRIB_DETAIL);
    }

    public void setDetail(String value) {
        this.setValue(ATTRIB_DETAIL, value);
    }

    public String getSummary() {
        return (String)this.getValue(ATTRIB_SUMMARY);
    }

    public void setSummary(String value) {
        this.setValue(ATTRIB_SUMMARY, value);
    }

    public String getEscape() {
        return (String)this.getValue(ATTRIB_ESCAPE);
    }

    public void setEscape(String value) {
        this.setValue(ATTRIB_ESCAPE, value);
    }
}

