/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.help;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCHelpDescriptor;
import com.sun.web.ui.common.CCHelpLoader;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCServerInterface;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.taglib.help.CCHelpTag;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCHelpWindowTag
extends CCHelpTag {
    public static final String PARAM_APPNAME = "appName";
    public static final String PARAM_HELPFILE = "helpFile";
    public static final String PARAM_MASTHEADALT = "mastheadAlt";
    public static final String PARAM_MASTHEADTITLE = "mastheadTitle";
    public static final String PARAM_PAGETITLE = "pageTitle";
    public static final String PARAM_WINDOWTITLE = "windowTitle";
    public static final String PARAM_FIRSTLOAD = "firstLoad";
    public static final String PARAM_SHOWCLOSEBUTTON = "showCloseButton";
    public static final String PARAM_HELPLOGOWIDTH = "helpLogoWidth";
    public static final String PARAM_HELPLOGOHEIGHT = "helpLogoHeight";
    public static final String PARAM_MERGE = "merge";
    public static final String PARAM_VERSIONFILE = "versionFile";
    public static final String PARAM_VERSIONTOOLTIP = "versionTooltip";
    public static final String PARAM_PATHPREFIX = "pathPrefix";
    public static final String HELPTYPE_HELP2 = "help2";
    public static final String HELPTYPE_HELP = "help";
    public static final String HELPTYPE_DEFAULT = "help";
    protected static final String ATTRIB_ANCHOR = "anchor";
    protected static final String ATTRIB_HEIGHT = "height";
    protected static final String ATTRIB_HELPFILENAME = "helpFileName";
    protected static final String ATTRIB_HELPTOOLTIP = "helpTooltip";
    protected static final String ATTRIB_HELPTYPE = "helpType";
    protected static final String ATTRIB_MASTHEADALT = "mastheadAlt";
    protected static final String ATTRIB_MASTHEADTITLE = "mastheadTitle";
    protected static final String ATTRIB_MERGE = "merge";
    protected static final String ATTRIB_PAGETITLE = "pageTitle";
    protected static final String ATTRIB_PATHPREFIX = "pathPrefix";
    protected static final String ATTRIB_APPNAME = "appName";
    protected static final String ATTRIB_SHOWCLOSEBUTTON = "showCloseButton";
    protected static final String ATTRIB_SHOWLINKICON = "showLinkIcon";
    protected static final String ATTRIB_STATUS = "status";
    protected static final String ATTRIB_HELPLOGOWIDTH = "helpLogoWidth";
    protected static final String ATTRIB_HELPLOGOHEIGHT = "helpLogoHeight";
    protected static final String ATTRIB_VERSIONTOOLTIP = "versionTooltip";
    protected static final String ATTRIB_VERSIONFILENAME = "versionFileName";
    protected static final String ATTRIB_WIDTH = "width";
    protected static final String ATTRIB_WINDOWTITLE = "windowTitle";
    protected static final String ATTRIB_ONCLICK = "onClick";
    private static final String HELP2_DEFAULT_HEIGHT = "500";
    private static final String HELP2_DEFAULT_WIDTH = "750";
    private static final String HELP2_DEFAULT_TARGET = "help2_Window";
    private static final String HELP_DEFAULT_HEIGHT = "480";
    private static final String HELP_DEFAULT_WIDTH = "640";
    private static final String HELP_DEFAULT_TARGET = "help_Window";
    private static final String DEFAULT_HELPDIR = "html";
    private static final String HELP2_DISPLAY_URL = "/cchelp2/Help2";
    private static final String HELP_DISPLAY_URL = "/cchelp/Help";
    private NonSyncStringBuffer displayURL;
    private String defaultTarget;
    private String defaultHeight;
    private String defaultWidth;
    private boolean isHelp2;
    private String urlStart;

    public void reset() {
        super.reset();
        this.displayURL = null;
        this.defaultTarget = null;
        this.defaultHeight = null;
        this.defaultWidth = null;
        this.isHelp2 = false;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        super.getHTMLStringInternal(parent, pageContext, view);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        try {
            if (this.urlStart == null) {
                throw new JspException("port not available to display help files");
            }
            this.displayURL = new NonSyncStringBuffer(this.urlStart);
            String appContext = this.getRequestContext().getRequest().getContextPath();
            if (this.isHelp2) {
                if (this.isIe()) {
                    this.displayURL.append(appContext + HELP2_DISPLAY_URL + "Ie");
                } else if (this.isNav4()) {
                    this.displayURL.append(appContext + HELP2_DISPLAY_URL + "Nav4");
                } else if (this.isGecko()) {
                    this.displayURL.append(appContext + HELP2_DISPLAY_URL + "Nav6up");
                } else {
                    this.displayURL.append(appContext + HELP2_DISPLAY_URL + "Nav6up");
                }
                this.defaultTarget = CCSystem.isAppInConsole() ? HELP2_DEFAULT_TARGET : "help2_Window_" + this.getAppName();
                this.defaultHeight = HELP2_DEFAULT_HEIGHT;
                this.defaultWidth = HELP2_DEFAULT_WIDTH;
            } else {
                this.displayURL.append(appContext + HELP_DISPLAY_URL);
                this.defaultTarget = CCSystem.isAppInConsole() ? HELP_DEFAULT_TARGET : "help_Window_" + this.getAppName();
                this.defaultHeight = HELP_DEFAULT_HEIGHT;
                this.defaultWidth = HELP_DEFAULT_WIDTH;
            }
            this.appendOpeningTag(buffer);
        }
        catch (UnsupportedEncodingException e) {
            CCDebug.trace1(this.encoding + " encoding is not supported.");
        }
        if (this.getBodyContent() != null) {
            buffer.append(this.getBodyContent().getString());
        }
        buffer.append("</a>");
        return buffer.toString();
    }

    private void appendOpeningTag(NonSyncStringBuffer buffer) throws JspException, UnsupportedEncodingException {
        buffer.append("<a").append(" href=\"").append(this.displayURL.toString());
        NonSyncStringBuffer paramsBuffer = new NonSyncStringBuffer(8192);
        this.addEncodedParameter(paramsBuffer, "appName", this.getAppName());
        this.addEncodedParameter(paramsBuffer, PARAM_HELPFILE, this.getLocalizedTextFile(this.getHelpFileName()));
        if (this.getAnchor() != null) {
            paramsBuffer.append(URLEncoder.encode("#", this.encoding)).append(URLEncoder.encode(this.getAnchor(), this.encoding));
        }
        this.addEncodedParameter(paramsBuffer, "merge", this.getMerge());
        this.addEncodedParameter(paramsBuffer, "windowTitle", this.getMessage(this.getWindowTitle()));
        this.addEncodedParameter(paramsBuffer, "mastheadTitle", this.getMessage(this.getMastheadTitle()));
        this.addEncodedParameter(paramsBuffer, "mastheadAlt", this.getMessage(this.getMastheadAlt()));
        this.addEncodedParameter(paramsBuffer, "pageTitle", this.getMessage(this.getPageTitle()));
        if (this.isHelp2) {
            this.addEncodedParameter(paramsBuffer, PARAM_FIRSTLOAD, "true");
        }
        if (!this.isHelp2) {
            this.addEncodedParameter(paramsBuffer, "showCloseButton", this.getShowCloseButton());
        }
        this.addEncodedParameter(paramsBuffer, "helpLogoWidth", this.getHelpLogoWidth());
        this.addEncodedParameter(paramsBuffer, "helpLogoHeight", this.getHelpLogoHeight());
        this.addEncodedParameter(paramsBuffer, "pathPrefix", this.getPathPrefix());
        buffer.append(paramsBuffer.toString());
        buffer.append("\"");
        CCHelpWindowTag.appendAttribute(buffer, "class", this.getStyleClass());
        CCHelpWindowTag.appendAttribute(buffer, "target", this.defaultTarget);
        CCHelpWindowTag.appendAttribute(buffer, "title", this.getMessage(this.getHelpTooltip()));
        NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer();
        if (this.getStatus() != null) {
            tmpBuffer.append("javascript:").append("window.status='").append(CCHelpWindowTag.escapeJsQuotes(this.getMessage(this.getStatus()))).append("'; return true");
            CCHelpWindowTag.appendAttribute(buffer, "onmouseover", tmpBuffer.toString());
            CCHelpWindowTag.appendAttribute(buffer, "onfocus", tmpBuffer.toString());
            tmpBuffer = new NonSyncStringBuffer("javascript: window.status=''; return true");
            CCHelpWindowTag.appendAttribute(buffer, "onmouseout", tmpBuffer.toString());
            CCHelpWindowTag.appendAttribute(buffer, "onblur", tmpBuffer.toString());
        }
        String features = this.isHelp2 ? "resizable" : "scrollbars,resizable";
        tmpBuffer = new NonSyncStringBuffer();
        if (this.getOnClick() != null) {
            tmpBuffer.append(this.getOnClick());
        }
        tmpBuffer.append(this.getOpenWindowJavascript("", this.defaultTarget, Integer.parseInt(this.getHeight() != null ? this.getHeight() : this.defaultHeight), Integer.parseInt(this.getWidth() != null ? this.getWidth() : this.defaultWidth), features));
        CCHelpWindowTag.appendAttribute(buffer, "onclick", tmpBuffer.toString());
        if (this.getTabIndex() != null) {
            CCHelpWindowTag.appendAttribute(buffer, "tabindex", this.getTabIndex());
        }
        buffer.append(">");
        if (this.isTrue(this.getShowLinkIcon())) {
            buffer.append(CCHelpWindowTag.getImageHTMLString(CCImage.HREF_LINK, Integer.parseInt("10"), Integer.parseInt("12")));
        }
    }

    private void addEncodedParameter(NonSyncStringBuffer buffer, String name, String value) throws UnsupportedEncodingException {
        if (buffer == null || name == null || value == null) {
            return;
        }
        buffer.append(buffer.length() == 0 ? "?" : "&amp;").append(name).append("=").append(URLEncoder.encode(value, this.encoding));
    }

    private String getLocalizedTextFile(String file) {
        CCDebug.trace3("file param: " + file);
        if (file == null) {
            return null;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        NonSyncStringBuffer buffer1 = new NonSyncStringBuffer(256);
        String localizedFile = null;
        String temp = this.getPathPrefix();
        if (temp != null && temp.length() > 0) {
            boolean pathPrefixStartsWithContextPath = false;
            String contextPath = this.getRequestContext().getRequest().getContextPath();
            if ((temp + "/").startsWith(contextPath + "/")) {
                int beginIndex = contextPath.length() + 1;
                temp = temp.substring(beginIndex);
                pathPrefixStartsWithContextPath = true;
            }
            buffer.append(this.getAppName()).append("/").append(temp);
            if (this.isHelp2 || !pathPrefixStartsWithContextPath) {
                buffer.append("/").append(DEFAULT_HELPDIR);
            }
            CCDebug.trace3("PathPrefix: " + buffer.toString());
        } else {
            buffer.append(this.getAppName()).append("/").append(DEFAULT_HELPDIR);
        }
        if (!buffer.toString().startsWith("/")) {
            buffer.insert(0, "/");
        }
        CCDebug.trace3("PathPrefix: " + buffer.toString());
        HttpServletRequest request = this.getRequestContext().getRequest();
        String localAppName = request.getContextPath();
        String prefixedPath = buffer.toString();
        if (this.isHelp2) {
            file = "help/" + file;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(CCI18N.getTagsLocale(this.pageContext.getRequest()));
        locales.add(Locale.ENGLISH);
        if ((prefixedPath + "/").startsWith(localAppName + "/")) {
            CCDebug.trace3("help file in same app");
            prefixedPath = prefixedPath.substring(localAppName.length());
            ServletContext appContext = this.getRequestContext().getServletContext();
            for (int i = 0; i < locales.size(); ++i) {
                String urlPath = prefixedPath + "/" + (Locale)locales.get(i) + "/" + file;
                urlPath = urlPath.replaceAll("//*", "/");
                CCDebug.trace3("URLPATH 1 : " + urlPath);
                String testPath = urlPath;
                int index = testPath.indexOf("?");
                if (index >= 0) {
                    testPath = urlPath.substring(0, index);
                }
                try {
                    localizedFile = this.urlStart + localAppName + urlPath;
                    URL url = new URL(localizedFile);
                    InputStream is = url.openStream();
                    is.close();
                    break;
                }
                catch (MalformedURLException muex) {
                    localizedFile = null;
                    CCDebug.trace2("getResource failed for " + urlPath);
                    continue;
                }
                catch (IOException ioe) {
                    localizedFile = null;
                    CCDebug.trace2("getResource failed with IOException " + urlPath);
                }
            }
        } else {
            String urlHdr = CCSystem.getHelpUrlHeader(request);
            String urlTemp = buffer.toString() + "/";
            for (int i = 0; i < locales.size(); ++i) {
                String urlPath = urlTemp + (Locale)locales.get(i) + "/" + file;
                try {
                    URL url = new URL(urlHdr + urlPath);
                    InputStream is = url.openStream();
                    is.close();
                    localizedFile = this.urlStart + urlPath;
                    break;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (MalformedURLException e) {
                    CCDebug.trace1("MalformedURLException", e);
                    continue;
                }
                catch (IOException e) {
                    CCDebug.trace1("IOE", e);
                }
            }
        }
        CCDebug.trace3("Localized help file: " + localizedFile + "\n");
        return localizedFile;
    }

    public String getStyleClass() {
        String className = super.getStyleClass();
        if (className == null) {
            className = this.getType() != null && this.getType().equals("field") ? "HlpFldLnk" : "HlpPgeLnk";
        }
        return className;
    }

    protected void setAttributes() {
        String localAppName = this.getRequestContext().getRequest().getContextPath();
        if (localAppName == null) {
            CCDebug.trace1("Unable to obtain app name from request.");
        } else if (localAppName.startsWith("/")) {
            localAppName = localAppName.substring(1).trim();
        }
        if (this.getAppName() == null) {
            this.setAppName(localAppName);
        }
        String appName = this.getAppName();
        try {
            boolean isExternalApp = localAppName != null && !localAppName.equals(this.getAppName());
            String helpAppName = isExternalApp ? appName : localAppName;
            String pluginName = null;
            pluginName = helpAppName.startsWith("/") ? helpAppName.substring(1).trim() : helpAppName;
            CCServerInterface server = CCSystem.getServerInterface();
            CCHelpDescriptor help = server.getCCHelpDescriptor(helpAppName);
            if (help != null) {
                if (this.getBundleID() == null) {
                    this.setBundleID(pluginName);
                    if (help.getBundle() != null) {
                        if (isExternalApp && CCSystem.isAppInConsole()) {
                            ClassLoader cl = CCHelpLoader.getHelpClassLoader(pluginName);
                            CCI18N.setResourceBundle(this.pageContext.getRequest(), this.pageContext.getResponse(), help.getBundle(), pluginName, null, cl);
                        } else {
                            CCI18N.setResourceBundle(this.pageContext.getRequest(), this.pageContext.getResponse(), help.getBundle(), pluginName, null);
                        }
                    }
                }
                if (this.getAnchor() == null) {
                    this.setAnchor(help.getAnchor());
                }
                if (this.getHeight() == null) {
                    this.setHeight(help.getHeight());
                }
                if (this.getHelpFileName() == null) {
                    this.setHelpFileName(help.getHelpFileName());
                }
                if (this.getHelpTooltip() == null) {
                    this.setHelpTooltip(help.getHelpTooltip());
                }
                if (this.getMastheadTitle() == null) {
                    this.setMastheadTitle(help.getMastheadTitle());
                }
                if (this.getMastheadAlt() == null) {
                    this.setMastheadAlt(help.getMastheadAlt());
                }
                if (this.getPathPrefix() == null) {
                    this.setPathPrefix(help.getPathPrefix());
                }
                if (this.getStatus() == null) {
                    this.setStatus(help.getStatus());
                }
                if (this.getWidth() == null) {
                    this.setWidth(help.getWidth());
                }
                if (this.getWindowTitle() == null) {
                    this.setWindowTitle(help.getWindowTitle());
                }
                if (this.getShowCloseButton() == null) {
                    this.setShowCloseButton(help.getShowCloseButton() ? "true" : "false");
                }
                if (this.getHelpLogoWidth() == null) {
                    this.setHelpLogoWidth(help.getHelpLogoWidth());
                }
                if (this.getHelpLogoHeight() == null) {
                    this.setHelpLogoHeight(help.getHelpLogoHeight());
                }
                if (this.getHelpType() == null) {
                    this.setHelpType(help.getHelpType());
                }
            } else {
                CCDebug.trace3("Unable to obtain app.xml Help object");
            }
        }
        catch (Exception ex) {
            CCDebug.trace1("Help info object not found");
        }
        String helpType = this.getHelpType();
        if (helpType == null || !helpType.equalsIgnoreCase("help") && !helpType.equalsIgnoreCase(HELPTYPE_HELP2)) {
            helpType = "help";
            this.setHelpType(helpType);
        }
        this.isHelp2 = helpType.equalsIgnoreCase(HELPTYPE_HELP2);
        HttpServletRequest request = this.getRequestContext().getRequest();
        String port = Integer.toString(request.getServerPort());
        NonSyncStringBuffer buff1 = new NonSyncStringBuffer(request.getScheme()).append("://").append(request.getServerName()).append(":").append(port);
        this.urlStart = buff1.toString();
        if (this.getPageTitle() == null) {
            this.setPageTitle(this.isHelp2 ? "help2.pageTitle" : "help.pageTitle");
        }
    }

    public String getAppName() {
        return (String)this.getValue("appName");
    }

    public void setAppName(String value) {
        this.setValue("appName", value);
    }

    public String getHeight() {
        return (String)this.getValue(ATTRIB_HEIGHT);
    }

    public void setHeight(String value) {
        this.setValue(ATTRIB_HEIGHT, value);
    }

    public String getHelpTooltip() {
        return (String)this.getValue(ATTRIB_HELPTOOLTIP);
    }

    public void setHelpTooltip(String value) {
        this.setValue(ATTRIB_HELPTOOLTIP, value);
    }

    public String getHelpType() {
        return (String)this.getValue(ATTRIB_HELPTYPE);
    }

    public void setHelpType(String value) {
        this.setValue(ATTRIB_HELPTYPE, value);
    }

    public String getPageTitle() {
        return (String)this.getValue("pageTitle");
    }

    public void setPageTitle(String value) {
        this.setValue("pageTitle", value);
    }

    public String getMastheadTitle() {
        return (String)this.getValue("mastheadTitle");
    }

    public void setMastheadTitle(String value) {
        this.setValue("mastheadTitle", value);
    }

    public String getMastheadAlt() {
        return (String)this.getValue("mastheadAlt");
    }

    public void setMastheadAlt(String value) {
        this.setValue("mastheadAlt", value);
    }

    public String getPathPrefix() {
        return (String)this.getValue("pathPrefix");
    }

    public void setPathPrefix(String value) {
        this.setValue("pathPrefix", value);
    }

    public String getShowCloseButton() {
        return (String)this.getValue("showCloseButton");
    }

    public void setShowCloseButton(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue("showCloseButton", value);
    }

    public String getShowLinkIcon() {
        return (String)this.getValue(ATTRIB_SHOWLINKICON);
    }

    public void setShowLinkIcon(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOWLINKICON, value);
    }

    public String getStatus() {
        return (String)this.getValue(ATTRIB_STATUS);
    }

    public void setStatus(String value) {
        this.setValue(ATTRIB_STATUS, value);
    }

    public String getWidth() {
        return (String)this.getValue(ATTRIB_WIDTH);
    }

    public void setWidth(String value) {
        this.setValue(ATTRIB_WIDTH, value);
    }

    public String getWindowTitle() {
        return (String)this.getValue("windowTitle");
    }

    public void setWindowTitle(String value) {
        this.setValue("windowTitle", value);
    }

    public String getAnchor() {
        return (String)this.getValue(ATTRIB_ANCHOR);
    }

    public void setAnchor(String value) {
        this.setValue(ATTRIB_ANCHOR, value);
    }

    public String getHelpFileName() {
        return (String)this.getValue(ATTRIB_HELPFILENAME);
    }

    public void setHelpFileName(String value) {
        this.setValue(ATTRIB_HELPFILENAME, value);
    }

    public String getHelpLogoWidth() {
        return (String)this.getValue("helpLogoWidth");
    }

    public void setHelpLogoWidth(String value) {
        this.setValue("helpLogoWidth", value);
    }

    public String getHelpLogoHeight() {
        return (String)this.getValue("helpLogoHeight");
    }

    public void setHelpLogoHeight(String value) {
        this.setValue("helpLogoHeight", value);
    }

    public String getMerge() {
        return (String)this.getValue("merge");
    }

    public void setMerge(String value) {
        this.setValue("merge", value);
    }

    public String getVersionFileName() {
        return (String)this.getValue(ATTRIB_VERSIONFILENAME);
    }

    public void setVersionFileName(String value) {
        this.setValue(ATTRIB_VERSIONFILENAME, value);
    }

    public String getVersionTooltip() {
        return (String)this.getValue("versionTooltip");
    }

    public void setVersionTooltip(String value) {
        this.setValue("versionTooltip", value);
    }

    public String getOnClick() {
        return (String)this.getValue(ATTRIB_ONCLICK);
    }

    public void setOnClick(String value) {
        this.setValue(ATTRIB_ONCLICK, value);
    }
}

