/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.wizard;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCTabsModel;
import com.sun.web.ui.model.CCTabsModelInterface;
import com.sun.web.ui.view.tabs.CCNodeEventHandlerInterface;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.IOException;
import javax.servlet.ServletException;

public class CCWizardTabs
extends CCTabs {
    public static final String STEPS_TAB_LABEL = "wizard.tab.label.steps";
    public static final String STEPS_TAB_TOOLTIP = "wizard.tab.tooltip.steps";
    public static final String STEPS_TAB_STATUS = "wizard.tab.status.steps";
    public static final String HELP_TAB_LABEL = "wizard.tab.label.help";
    public static final String HELP_TAB_TOOLTIP = "wizard.tab.tooltip.help";
    public static final String HELP_TAB_STATUS = "wizard.tab.status.help";
    private CCTabsModel tabsModel;

    private void createTabsModel() {
        this.tabsModel = new CCTabsModel();
        CCNavNode stepsTab = new CCNavNode(0, STEPS_TAB_LABEL, STEPS_TAB_TOOLTIP, STEPS_TAB_STATUS);
        CCNavNode helpTab = new CCNavNode(1, HELP_TAB_LABEL, HELP_TAB_LABEL, HELP_TAB_STATUS);
        this.tabsModel.addNode(stepsTab);
        this.tabsModel.addNode(helpTab);
        this.tabsModel.setSelectedNode(stepsTab);
    }

    public CCWizardTabs(View parent, CCTabsModelInterface model, String name) {
        super(parent, model, name);
        if (model == null) {
            this.createTabsModel();
            this.setCCTabsModel(this.tabsModel);
            this.registerChildren();
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
    }

    public int getActiveTab() {
        CCTabsModelInterface model = this.getCCTabsModel();
        CCNavNode tab = (CCNavNode)model.getSelectedNode();
        int id = tab.getId();
        return id;
    }

    public boolean isHelpTabActive() {
        return this.getActiveTab() == 1;
    }

    public void setActiveTab(int id) {
        String selTip = null;
        String unSelTip = null;
        CCTabsModelInterface model = this.getCCTabsModel();
        CCNavNode selTab = (CCNavNode)model.getNodeById(id);
        CCNavNode unSelTab = null;
        model.setSelectedNode(selTab);
        if (id == 0) {
            selTip = STEPS_TAB_TOOLTIP;
            unSelTip = HELP_TAB_LABEL;
            unSelTab = (CCNavNode)model.getNodeById(1);
        } else {
            selTip = HELP_TAB_TOOLTIP;
            unSelTip = STEPS_TAB_LABEL;
            unSelTab = (CCNavNode)model.getNodeById(0);
        }
        selTab.setTooltip(selTip);
        unSelTab.setTooltip(unSelTip);
    }

    public void handleTabHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        CCTabsModelInterface model = this.getCCTabsModel();
        if (model == null) {
            CCDebug.trace1("Tabs model is null.");
            return;
        }
        View vb = this.getParent();
        String value = (String)this.getDisplayFieldValue("TabHref");
        int id = -1;
        try {
            id = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            CCDebug.trace1("Could not get tab ID: " + nfe.getMessage());
        }
        ((CCNodeEventHandlerInterface)vb).nodeClicked(event, id);
    }
}

