/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CCI18NFileIO
extends CCI18N {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String PROPS_SUFFIX = ".properties";

    public CCI18NFileIO(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        super(request, bundleID);
        if (bundleID != null) {
            CCI18NFileIO.setResourceBundle(request, response, baseName, bundleID, locale, appRoot, jarName);
        } else {
            CCI18NFileIO.initContentType(request, response);
            this.setResourceBundle(CCI18NFileIO.findResourceBundle(request, baseName, locale != null ? locale : CCI18NFileIO.getTagsLocale(request), appRoot, jarName));
        }
    }

    public static boolean setResourceBundle(ServletRequest request, ServletResponse response, String baseName, String bundleID, Locale locale, String appRoot, String jarName) {
        CCI18NFileIO.initContentType(request, response);
        ResourceBundle bundle = CCI18NFileIO.findResourceBundle(request, baseName, locale != null ? locale : CCI18NFileIO.getTagsLocale(request), appRoot, jarName);
        if (bundle == null) {
            CCDebug.trace3("The resource bundle could not be found.");
            return false;
        }
        CCI18NFileIO.setResourceBundle(request, bundle, bundleID);
        CCI18NFileIO.setBaseName(request, baseName, bundleID);
        return true;
    }

    private static ResourceBundle findResourceBundle(ServletRequest request, String baseName, Locale locale, String appRoot, String jarName) {
        Locale l;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        ResourceBundle bundle = null;
        ArrayList<Object> locales = new ArrayList<Locale>();
        if (locale != null) {
            locales.add(locale);
        } else {
            locales = Collections.list(request.getLocales());
        }
        for (int i = 0; i < locales.size() && (!(l = (Locale)locales.get(i)).getLanguage().equals(Locale.ENGLISH.getLanguage()) || !l.getCountry().equals(Locale.US.getCountry()) && l.getCountry().length() != 0); ++i) {
            bundle = CCI18NFileIO.loadResourceBundle(request, baseName, l, appRoot, jarName);
            if (bundle == null) continue;
            if (bundle.getLocale() == null || bundle.getLocale().getLanguage().length() > 0) break;
            CCDebug.trace3("Locale not available: " + locale);
        }
        if (bundle == null || bundle.getLocale() == null || bundle.getLocale().getLanguage().length() == 0) {
            bundle = CCI18NFileIO.loadResourceBundle(request, baseName, new Locale(""), appRoot, jarName);
        }
        return bundle;
    }

    private static ResourceBundle loadResourceBundle(ServletRequest request, String baseName, Locale locale, String appRoot, String jarName) {
        if (appRoot == null) {
            throw new IllegalArgumentException("appRoot cannot be null");
        }
        ArrayList<String> suffix = new ArrayList<String>();
        ResourceBundle bundle = null;
        if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            suffix.add(CCI18NFileIO.getSuffix(locale.getLanguage(), locale.getCountry(), locale.getVariant()));
        }
        if (locale.getLanguage().length() > 0 && locale.getCountry().length() > 0) {
            suffix.add(CCI18NFileIO.getSuffix(locale.getLanguage(), locale.getCountry(), ""));
        }
        if (locale.getLanguage().length() > 0) {
            suffix.add(CCI18NFileIO.getSuffix(locale.getLanguage(), "", ""));
        }
        suffix.add("");
        for (int i = 0; i < suffix.size() && (bundle = CCI18NFileIO.loadResourceBundle((String)suffix.get(i), baseName, appRoot, jarName)) == null; ++i) {
        }
        return bundle;
    }

    private static ResourceBundle loadResourceBundle(String suffix, String baseName, String appRoot, String jarName) {
        String fullBaseName = baseName + suffix;
        String fullJarName = jarName != null ? jarName + suffix + ".jar" : null;
        return CCI18NFileIO.findResourceFile(fullBaseName, appRoot, fullJarName);
    }

    private static ResourceBundle findResourceFile(String fullBaseName, String appRoot, String fullJarName) {
        String normalizedBaseName = CCI18NFileIO.normalizeBaseName(fullBaseName);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(appRoot).append(SEPARATOR).append("WEB-INF").append(SEPARATOR).append("lib").append(SEPARATOR).append(fullJarName);
        File jarNameFile = new File(buffer.toString());
        if (jarNameFile.exists()) {
            try {
                JarFile jarFile = new JarFile(jarNameFile);
                JarEntry entry = jarFile.getJarEntry(normalizedBaseName);
                if (entry != null) {
                    InputStream is = jarFile.getInputStream(entry);
                    return new PropertyResourceBundle(is);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        buffer = new NonSyncStringBuffer(appRoot).append(SEPARATOR).append("WEB-INF").append(SEPARATOR).append("classes").append(SEPARATOR).append(normalizedBaseName);
        try {
            File resourcesFile = new File(buffer.toString());
            FileInputStream fis = new FileInputStream(resourcesFile);
            return new PropertyResourceBundle(fis);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String normalizeBaseName(String baseName) {
        String normalizedBaseName = baseName.replace('.', SEPARATOR.toCharArray()[0]);
        return normalizedBaseName + PROPS_SUFFIX;
    }

    private static String getSuffix(String language, String country, String variant) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        String ext = "_";
        if (language.length() > 0) {
            buffer.append(ext + language);
        }
        if (country.length() > 0) {
            buffer.append(ext + country);
        }
        if (variant.length() > 0) {
            buffer.append(ext + variant);
        }
        return buffer.toString();
    }

    private static void setBaseName(ServletRequest request, String baseName, String bundleID) {
        request.setAttribute("com.sun.web.ui.common.CCI18N.Base:" + bundleID, (Object)baseName);
    }
}

