/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.model.CCDefaultEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

abstract class CCDocumentBuilder {
    CCDocumentBuilder() {
    }

    public static Document createDocument(InputStream xmlStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(true);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            EntityResolver resolver = CCSystem.getEntityResolver();
            if (resolver == null) {
                resolver = new CCDefaultEntityResolver();
            }
            documentBuilder.setEntityResolver(resolver);
            documentBuilder.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }

                public void fatalError(SAXParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }

                public void warning(SAXParseException e) {
                    CCDebug.trace3(e.getMessage());
                }
            });
            return documentBuilder.parse(xmlStream);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public static Document createDocument(String string) {
        if (string == null) {
            throw new IllegalArgumentException("XML string empty!");
        }
        return CCDocumentBuilder.createDocument(new ByteArrayInputStream(string.getBytes()));
    }

    public static String getXMLString(InputStream xmlStream) {
        try {
            int bytesRead = xmlStream.available();
            String xmlString = "";
            do {
                byte[] bytes;
                if ((bytesRead = xmlStream.read(bytes = new byte[bytesRead])) <= 0) continue;
                xmlString = xmlString + new String(bytes, 0, bytesRead);
            } while (bytesRead > 0);
            xmlStream.close();
            return xmlString;
        }
        catch (IOException e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }
}

