/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.common;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.web.ui.common.CCBodyContentImpl;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCJspWriterImpl;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCOptionGroup;
import com.sun.web.ui.view.html.CCOptionSeparator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CCDescriptorTagBase
extends CCTagBase {
    protected String parseCCElement(Node node, ContainerView view, String element) throws JspException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null.");
        }
        if (!node.hasAttributes()) {
            return node.getNodeValue();
        }
        NamedNodeMap nodeAttrs = node.getAttributes();
        Node nameNode = nodeAttrs.getNamedItem("name");
        Node tagclassNode = nodeAttrs.getNamedItem("tagclass");
        String viewName = nameNode != null ? nameNode.getNodeValue() : null;
        String tagclassName = tagclassNode != null ? tagclassNode.getNodeValue() : null;
        View child = view.getChild(viewName);
        CCTagBase tag = this.getCCTag(tagclassName);
        tag.setName(viewName);
        if (tag.getTabIndex() == null) {
            tag.setTabIndex(this.getTabIndex());
        }
        if (node.hasChildNodes()) {
            NodeList childNodeList = node.getChildNodes();
            CCBodyContentImpl bodyContent = tag instanceof BodyTag ? new CCBodyContentImpl(new CCJspWriterImpl(null, 100, false)) : null;
            OptionList options = child != null && child instanceof SelectableGroup ? new OptionList() : null;
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                this.parseCCElementChild(childNodeList.item(i), view, tag, element, bodyContent, options);
            }
            if (bodyContent != null) {
                ((BodyTag)tag).setBodyContent((BodyContent)bodyContent);
            }
            if (options != null && options.size() > 0) {
                ((SelectableGroup)child).setOptions(options);
            }
        }
        String html = null;
        if (this.fireBeginDisplayEvent(view, tag)) {
            this.setTagAttributes(child, tag, element);
            html = tag.getHTMLString(this.getParent(), this.pageContext, child);
        }
        return this.fireEndDisplayEvent(view, tag, html);
    }

    protected void parseCCElementChild(Node node, ContainerView view, CCTagBase tag, String element, BodyContent bodyContent, OptionList options) throws JspException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            CCDebug.trace1("Unable to obtain child node");
            return;
        }
        if (nodeName.equals("attribute")) {
            this.parseAttributeElement(node, tag);
        } else if (nodeName.equals("option") || nodeName.equals("optionGroup") || nodeName.equals("optionSeparator")) {
            if (options == null) {
                throw new IllegalArgumentException("The content of element named ccis invalid; " + ((Object)((Object)tag)).getClass().getName() + " does not implement SelectableGroup");
            }
            Option option = null;
            if (nodeName.equals("option")) {
                option = this.parseOptionElement(node);
            } else if (nodeName.equals("optionGroup")) {
                option = this.parseOptionGroupElement(node);
            } else if (nodeName.equals("optionSeparator")) {
                option = this.parseOptionSeparatorElement(node);
            }
            if (option != null) {
                options.add(option);
            }
        } else if (nodeName.equals("cc")) {
            if (bodyContent == null) {
                throw new IllegalArgumentException("The content of element named ccis invalid; " + ((Object)((Object)tag)).getClass().getName() + " does not implement BodyTag");
            }
            try {
                String html = this.parseCCElement(node, view, element);
                if (html != null) {
                    bodyContent.print(html);
                    ((BodyTag)tag).setBodyContent(bodyContent);
                }
            }
            catch (IOException e) {
                CCDebug.trace3(e.getMessage());
            }
        } else {
            if (bodyContent == null) {
                return;
            }
            try {
                if (node.getNodeValue() != null) {
                    bodyContent.print(node.getNodeValue());
                }
            }
            catch (IOException e) {
                CCDebug.trace3(e.getMessage());
            }
        }
    }

    protected abstract void setTagAttributes(View var1, CCTagBase var2, String var3) throws JspException;

    protected void parseAttributeElement(Node node, CCTagBase tag) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!node.hasAttributes()) {
            CCDebug.trace1("Node has no attributes.");
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node nameNode = namedNodeMap.getNamedItem("name");
        Node valueNode = namedNodeMap.getNamedItem("value");
        String name = nameNode.getNodeValue();
        String value = valueNode != null ? valueNode.getNodeValue() : "";
        char c = Character.toUpperCase(name.charAt(0));
        String methodName = "set" + c + name.substring(1);
        try {
            Method method = ((Object)((Object)tag)).getClass().getMethod(methodName, String.class);
            method.invoke((Object)tag, value);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected CCOption parseOptionElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (!node.hasAttributes()) {
            CCDebug.trace1("Node has no attributes.");
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node labelNode = namedNodeMap.getNamedItem("label");
        Node valueNode = namedNodeMap.getNamedItem("value");
        Node titleNode = namedNodeMap.getNamedItem("title");
        Node titleDisabledNode = namedNodeMap.getNamedItem("titleDisabled");
        Node disabledNode = namedNodeMap.getNamedItem("disabled");
        return new CCOption(labelNode.getNodeValue(), valueNode.getNodeValue(), titleNode != null ? titleNode.getNodeValue() : null, titleDisabledNode != null ? titleDisabledNode.getNodeValue() : null, new Boolean(disabledNode != null ? disabledNode.getNodeValue() : "false"));
    }

    protected CCOptionGroup parseOptionGroupElement(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (!node.hasAttributes()) {
            CCDebug.trace1("Node has no attributes.");
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node labelNode = namedNodeMap.getNamedItem("label");
        Node titleNode = namedNodeMap.getNamedItem("title");
        CCOptionGroup optionGroup = new CCOptionGroup(labelNode.getNodeValue(), titleNode != null ? titleNode.getNodeValue() : null);
        NodeList childNodeList = node.getChildNodes();
        if (childNodeList == null) {
            CCDebug.trace1("Could not obtain child nodes for option group");
            return optionGroup;
        }
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            String childNodeName = childNode.getNodeName();
            CCOption option = this.parseOptionElement(childNode);
            if (option == null) continue;
            optionGroup.add(option);
        }
        return optionGroup;
    }

    protected CCOptionSeparator parseOptionSeparatorElement(Node node) {
        CCOptionSeparator optionSeparator = new CCOptionSeparator();
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null.");
        }
        if (!node.hasAttributes()) {
            CCDebug.trace3("Node has no attributes.");
            return optionSeparator;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node labelNode = namedNodeMap.getNamedItem("label");
        Node valueNode = namedNodeMap.getNamedItem("value");
        Node maxHtmlCharsNode = namedNodeMap.getNamedItem("maxHtmlChars");
        if (labelNode != null) {
            optionSeparator.setLabel(labelNode.getNodeValue());
        }
        if (valueNode != null) {
            optionSeparator.setValue(valueNode.getNodeValue());
        }
        if (maxHtmlCharsNode != null) {
            try {
                optionSeparator.setMaxHTMLChars(Integer.parseInt(maxHtmlCharsNode.getNodeValue()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return optionSeparator;
    }

    protected CCTagBase getCCTag(String name) throws JspException {
        CCTagBase tag = null;
        Class<?> tagclass = null;
        try {
            ClassLoader classLoader = this.getClassLoader(this.getRequestContext().getRequest());
            tagclass = classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            CCDebug.trace1("Could not obtain class: " + name);
            throw new JspException(e.getMessage());
        }
        if (CCTagBase.class.isAssignableFrom(tagclass)) {
            try {
                tag = (CCTagBase)((Object)tagclass.newInstance());
            }
            catch (InstantiationException e) {
                CCDebug.trace1("Could not instantiate: " + tagclass);
                throw new JspException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                CCDebug.trace1("Could not instantiate: " + tagclass);
                throw new JspException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("CCTagBase is not a superclass of: " + tagclass);
        }
        return tag;
    }

    private ClassLoader getClassLoader(HttpServletRequest request) {
        ClassLoader classLoader = RequestManager.getHandlingServlet().getClass().getClassLoader();
        return classLoader != null ? classLoader : ((Object)((Object)this)).getClass().getClassLoader();
    }
}

