/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.filechooser;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.JspDisplayEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.model.CCFileChooserTimeInterface;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCButtonTag;
import com.sun.web.ui.taglib.html.CCDropDownMenuTag;
import com.sun.web.ui.taglib.html.CCHiddenTag;
import com.sun.web.ui.taglib.html.CCLabelTag;
import com.sun.web.ui.taglib.html.CCSelectableListTag;
import com.sun.web.ui.taglib.html.CCTextFieldTag;
import com.sun.web.ui.view.filechooser.CCFileChooser;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.html.CCTextField;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCFileChooserTag
extends CCTagBase {
    protected static final String ATTRIB_TYPE = "type";
    protected static final String ATTRIB_MULTIPLE_SELECT = "allowMultipleSelect";
    protected CCFileChooser fileChooser;
    private File[] files;
    public static final String HYFEN = "-";
    public static final String ASTERIX = "*";

    public CCFileChooserTag() {
        CCDebug.initTrace();
    }

    public void reset() {
        super.reset();
        this.fileChooser = null;
        this.files = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCFileChooser.class);
        this.fileChooser = (CCFileChooser)view;
        CCFileChooserModelInterface model = this.fileChooser.getModel();
        if (model == null) {
            CCDebug.trace1("Model is null.");
            throw new IllegalArgumentException();
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        try {
            this.fileChooser.beginDisplay((DisplayEvent)new JspDisplayEvent((Tag)this, pageContext));
        }
        catch (ModelControlException e) {
            throw new JspException(e.getMessage());
        }
        String formName = this.getFormName();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        this.appendStartingHTML(buffer);
        this.appendServerRow(buffer, model);
        this.appendLookinTextField(buffer, model);
        this.appendFilterField(buffer);
        this.appendSortMenus(buffer, model);
        this.appendFilesList(buffer, model);
        this.appendUpLevelButton(buffer, model);
        this.appendOpenFolderButton(buffer);
        this.appendSelectedResource(buffer, model);
        return buffer.toString();
    }

    protected void appendStartingHTML(NonSyncStringBuffer buffer) throws JspException {
        String title = HtmlUtil.escape((String)this.getTagMessage("filechooser.title"));
        String summary = HtmlUtil.escape((String)this.getTagMessage("filechooser.summary"));
        buffer.append("<div class=\"").append("ConMgn").append("\">\n").append("<table title=\"\" border=\"0\" cellspacing=\"0\"").append(" cellpadding=\"0\"").append(" summary=\"" + summary + "\">\n");
    }

    protected void appendServerRow(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCHiddenTag hiddenTag = new CCHiddenTag();
        String fileNameHtml = hiddenTag.getHTMLString(this.getParent(), this.pageContext, this.fileChooser.getChild("enterFlag"));
        String value = HtmlUtil.escape((String)this.getTagMessage("filechooser.serverPrompt"));
        buffer.append("<tr>\n").append("<td>").append(CCFileChooserTag.getImageHTMLString(CCImage.DOT, 20, 1)).append("</td>\n </tr>\n").append("<tr>\n<td><span class=\"").append("ChoLblTxt").append("\">").append(value).append("</span>").append("&nbsp;&nbsp;").append("<span class=\"").append("ChoSrvTxt").append("\">").append(HtmlUtil.escape((String)model.getServerName())).append("</span>").append(fileNameHtml).append("</td></tr>\n").append(this.appendEmptyLine(null, "1", "20"));
    }

    protected void appendLookinTextField(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCTextFieldTag lookInTextTag = new CCTextFieldTag();
        CCTextField lookInText = (CCTextField)this.fileChooser.getChild("lookIn");
        String textData = model.getCurrentDirectory();
        if (textData == null) {
            textData = model.getHomeDirectory();
        }
        lookInText.setValue(textData);
        lookInTextTag.setSize("40");
        lookInTextTag.setExtraHtml("style=\"width:422px\"");
        lookInTextTag.setTabIndex(this.getTabIndex());
        CCHref href = new CCHref((ContainerView)lookInText.getParent(), "lookInEntered", null);
        String actionURLJavascript = this.getActionURLJavascript((ContainerView)lookInText.getParent(), "lookInEntered");
        this.getTextFieldScript(actionURLJavascript, lookInTextTag, "enterPressed");
        buffer.append("\n<tr>\n<td> <table title=\"\" ").append("border=\"0\" cellpadding=\"0\"").append("cellspacing=\"0\">").append(this.appendEmptyLine("3", "1", "3")).append("<tr>\n<td nowrap=\"nowrap\">").append(this.getLabel(lookInText.getParent(), lookInText.getName(), "filechooser.lookin")).append("</td>").append(this.getDotImage(null, "10", "1")).append("<td>").append(lookInTextTag.getHTMLString(this.getParent(), this.pageContext, (View)lookInText)).append("</td>\n</tr>\n");
    }

    protected void appendFilterField(NonSyncStringBuffer buffer) throws JspException {
        CCTextFieldTag filterTextTag = new CCTextFieldTag();
        CCTextField filterText = (CCTextField)this.fileChooser.getChild("fileType");
        filterText.setValue(ASTERIX, false);
        int size = 18;
        if (this.isNav4()) {
            size = 14;
        } else if (this.isNav6up()) {
            size = 32;
        }
        filterTextTag.setSize(Integer.toString(size));
        filterTextTag.setTabIndex(this.getTabIndex());
        CCHref href = new CCHref((ContainerView)filterText.getParent(), "lookInEntered", null);
        String actionURLJavascript = this.getActionURLJavascript((ContainerView)filterText.getParent(), "lookInEntered");
        this.getTextFieldScript(actionURLJavascript, filterTextTag, "enterPressed");
        buffer.append(this.appendEmptyLine("3", "1", "5")).append("<tr>\n<td nowrap=\"nowrap\">").append(this.getLabel(filterText.getParent(), filterText.getName(), "filechooser.filterOn")).append("</td>").append(this.getDotImage(null, "10", "1")).append("<td>").append(filterTextTag.getHTMLString(this.getParent(), this.pageContext, (View)filterText)).append("</td></tr>");
        this.appendHelpMsg1(buffer);
        buffer.append("<tr>\n").append(this.getDotImage("3", "1", "15")).append("</tr>\n</table>\n</td>\n</tr>\n");
    }

    protected void getTextFieldScript(String actionURLJavascript, CCDisplayFieldTagBase tag, String enterType) {
        CCHiddenField flag = (CCHiddenField)this.fileChooser.getChild("enterFlag");
        String flagName = flag.getQualifiedName();
        NonSyncStringBuffer jsBuffer = new NonSyncStringBuffer(8192);
        jsBuffer.append("var enter = elements['").append(flagName).append("'];").append("enter.value='").append(enterType).append("'; ");
        NonSyncStringBuffer scriptBuffer = new NonSyncStringBuffer(8192);
        String javaScript = "javascript:";
        actionURLJavascript = actionURLJavascript.substring(javaScript.length());
        scriptBuffer.append("javascript: var keycode = -1; ");
        if (this.isNav4()) {
            scriptBuffer.append("if (event) keycode = event.which;").append("if (keycode != 0) return true; else {").append(jsBuffer.toString() + actionURLJavascript).append("}");
            tag.setOnChange(scriptBuffer.toString());
        } else if (this.isIe5up()) {
            scriptBuffer.append("if (window.event) keycode = ").append("window.event.keyCode;").append("else if (event) keycode = event.which; ").append("if (keycode != 13) return true; else {").append(jsBuffer.toString()).append(actionURLJavascript).append(" return false;}");
            tag.setOnKeyPress(scriptBuffer.toString());
        } else {
            scriptBuffer.append("if (window.event) keycode = ").append("window.event.keyCode;").append("else if (event) keycode = event.which;").append("if (keycode != 13) return true; else {").append(jsBuffer.toString() + actionURLJavascript).append("}");
            tag.setOnKeyPress(scriptBuffer.toString());
        }
    }

    protected void appendSortMenus(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCDropDownMenuTag sortFieldTag = new CCDropDownMenuTag();
        sortFieldTag.setBundleID("com.sun.web.ui");
        sortFieldTag.setTabIndex(this.getTabIndex());
        CCSelectableList fileList = (CCSelectableList)this.fileChooser.getChild("files");
        String fileListName = fileList.getQualifiedName();
        NonSyncStringBuffer jsBuffer = new NonSyncStringBuffer(8192);
        jsBuffer.append("var select = elements['").append(fileListName).append("'];\n").append("select.selectedIndex = -1; \n");
        sortFieldTag.setOnChange(jsBuffer.toString());
        CCDropDownMenu sortFieldView = (CCDropDownMenu)this.fileChooser.getChild("sortField");
        CCHref href = new CCHref((ContainerView)sortFieldView.getParent(), "timeToSort", null);
        buffer.append("\n<tr>\n<td align=\"right\">").append(this.getLabel(sortFieldView.getParent(), sortFieldView.getName(), "filechooser.sortBy")).append("&nbsp;").append(sortFieldTag.getHTMLString(this.getParent(), this.pageContext, (View)sortFieldView)).append("</td>\n</tr>\n").append(this.appendEmptyLine(null, "1", "5"));
    }

    protected void appendFilesList(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCSelectableListTag selectTag = new CCSelectableListTag();
        selectTag.setSize(String.valueOf(model.getFileListBoxHeight()));
        String titleKey = null;
        titleKey = model.getType().equals("file") ? "filechooser.listTitleFile" : "filechooser.listTitleFolder";
        selectTag.setTitle(this.getTagMessage(titleKey));
        selectTag.setDisableStyleOnly("true");
        CCSelectableList fileList = (CCSelectableList)this.fileChooser.getChild("files");
        CCHref href = new CCHref((ContainerView)fileList.getParent(), "DBClicked", null);
        CCHref enterHref = new CCHref((ContainerView)fileList.getParent(), "listLookInEntered", null);
        String actionURLJavascript = this.getActionURLJavascript((ContainerView)fileList.getParent(), "listLookInEntered");
        this.getTextFieldScript(actionURLJavascript, selectTag, "enterList");
        NonSyncStringBuffer dblClickDisableScript = new NonSyncStringBuffer(8192);
        dblClickDisableScript.append("ondblclick=\"");
        String dblClickJavascript = this.getActionURLJavascript((ContainerView)fileList.getParent(), "DBClicked");
        String onChangeJavascript = this.setFileListContents(dblClickDisableScript);
        if (onChangeJavascript != null) {
            selectTag.setOnChange(onChangeJavascript);
        }
        dblClickDisableScript.append(dblClickJavascript).append("\"");
        fileList.setExtraHtml(dblClickDisableScript.toString());
        selectTag.setMonospace("true");
        selectTag.setEscape("false");
        buffer.append("\n<tr>\n<td>").append(selectTag.getHTMLString(this.getParent(), this.pageContext, (View)fileList)).append("</td>\n</tr>").append(this.appendEmptyLine(null, "1", "5"));
    }

    protected void appendUpLevelButton(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCTextField lookInText = (CCTextField)this.fileChooser.getChild("lookIn");
        String lookInTextName = lookInText.getQualifiedName();
        View child = this.fileChooser.getChild("moveUp");
        this.checkChildType(child, CCButton.class);
        CCButton button = (CCButton)child;
        CCButtonTag buttonTag = new CCButtonTag();
        buttonTag.setBundleID("com.sun.web.ui");
        buttonTag.setType("secondaryMini");
        buttonTag.setTabIndex(this.getTabIndex());
        String formName = this.getFormName();
        button.setAlt("filechooser.upOneLevelTitle");
        button.setTitle("filechooser.upOneLevelTitle");
        buffer.append("<tr>\n").append("<td> <table title=\"\" width=\"100%\" border=\"0\"").append(" cellpadding=\"0\" cellspacing=\"0\">").append("\n<tr>");
        if (model.multipleSelect()) {
            String helpMsg2 = this.getTagMessage("filechooser.multiSelectHelp");
            buffer.append("\n<td valign=\"top\"><span class=\"").append("HlpFldTxt").append("\">").append(helpMsg2).append("</span></td>");
        } else {
            buffer.append("\n<td valign=\"top\">&nbsp;</td>");
        }
        buffer.append(this.getDotImage(null, "10", "1")).append("<td align=\"right\" nowrap=\"nowrap\">").append(buttonTag.getHTMLString(this.getParent(), this.pageContext, (View)button)).append(" ");
    }

    protected void appendOpenFolderButton(NonSyncStringBuffer buffer) throws JspException {
        View child1 = this.fileChooser.getChild("openFolder");
        this.checkChildType(child1, CCButton.class);
        CCButton button1 = (CCButton)child1;
        CCButtonTag buttonTag = new CCButtonTag();
        buttonTag.setTabIndex(this.getTabIndex());
        buttonTag.setBundleID("com.sun.web.ui");
        buttonTag.setType("secondaryMini");
        buttonTag.setDynamic("true");
        button1.setDisabled(true);
        button1.setAlt("filechooser.openFolderTitle");
        button1.setTitle("filechooser.openFolderTitle");
        button1.setTitleDisabled("filechooser.openFolderTitle");
        buffer.append(buttonTag.getHTMLString(this.getParent(), this.pageContext, (View)button1)).append("</td>\n</tr>\n</table>\n</td>\n</tr>").append(this.appendEmptyLine(null, "1", "10"));
    }

    protected void appendSelectedResource(NonSyncStringBuffer buffer, CCFileChooserModelInterface model) throws JspException {
        CCTextFieldTag selectFileTextTag = new CCTextFieldTag();
        CCTextField selectFileText = (CCTextField)this.fileChooser.getChild("fileName");
        String styleHtml = null;
        String labelKey = null;
        if (model.getType().equals("file")) {
            labelKey = "filechooser.selectedFile";
            styleHtml = "style=\"width:390px\"";
        } else {
            labelKey = "filechooser.selectedFolder";
            styleHtml = "style=\"width:386px\"";
        }
        if (model.multipleSelect()) {
            labelKey = labelKey.concat("s");
            selectFileTextTag.setSize("40");
        } else {
            styleHtml = null;
            selectFileTextTag.setSize("30");
        }
        if (styleHtml != null) {
            selectFileTextTag.setExtraHtml(styleHtml);
        }
        selectFileTextTag.setTabIndex(this.getTabIndex());
        CCHref href = new CCHref((ContainerView)selectFileText.getParent(), "selectedFileEntered", null);
        String actionURLJavascript = this.getActionURLJavascript((ContainerView)selectFileText.getParent(), "selectedFileEntered");
        this.getTextFieldScript(actionURLJavascript, selectFileTextTag, "selectedFileEntered");
        buffer.append("\n<tr>\n<td> <table title=\"\" ").append("border=\"0\" cellpadding=\"0\"").append("cellspacing=\"0\">").append("<tr>\n<td nowrap=\"nowrap\">").append(this.getLabel(selectFileText.getParent(), selectFileText.getName(), labelKey)).append("</td>").append(this.getDotImage(null, "10", "1")).append("<td>").append(selectFileTextTag.getHTMLString(this.getParent(), this.pageContext, (View)selectFileText)).append("</td>\n</tr>\n</table>").append("</td>\n</tr>\n").append(this.appendEmptyLine(null, "1", "30")).append("</table>\n</div>\n");
    }

    protected void appendHelpMsg1(NonSyncStringBuffer buffer) throws JspException {
        String helpMsg = HtmlUtil.escape((String)this.getTagMessage("filechooser.enterKeyHelp"));
        buffer.append("<tr>").append(this.getDotImage("2", "1", "1")).append("\n<td>").append("<span class=\"").append("HlpFldTxt").append("\">").append(helpMsg).append("</span>").append("</td></tr>\n");
    }

    protected String appendEmptyLine(String colSpan, String wd, String ht) {
        StringBuffer emptyLine = new StringBuffer();
        emptyLine.append("<tr>\n").append(this.getDotImage(colSpan, wd, ht)).append("</tr>\n");
        return emptyLine.toString();
    }

    protected String getDotImage(String colSpan, String wd, String ht) {
        StringBuffer dotImageBuffer = new StringBuffer();
        if (colSpan != null) {
            dotImageBuffer.append("<td colspan=\"").append(colSpan).append("\">");
        } else {
            dotImageBuffer.append("<td>");
        }
        dotImageBuffer.append(CCFileChooserTag.getImageHTMLString(CCImage.DOT, ht, wd)).append("</td>\n");
        return dotImageBuffer.toString();
    }

    private String getSpace() {
        String space = null;
        space = this.isNav4() ? "." : "&nbsp;";
        return space;
    }

    private String setFileListContents(NonSyncStringBuffer dblClickBuffer) {
        int i;
        int fileNameLen = 40;
        int fileSizeLen = 10;
        int fileDateLen = 8;
        String space = this.getSpace();
        Vector<String> selectableValuesVec = new Vector<String>();
        Vector<String> selectableNamesVec = new Vector<String>();
        Vector<String> fileOrFolderVec = new Vector<String>();
        CCFileChooserModelInterface model = this.fileChooser.getModel();
        String type = model.getType();
        FileFilter filter = null;
        CCTextField filterText = (CCTextField)this.fileChooser.getChild("fileType");
        String filterString = (String)filterText.getValue();
        filter = model.instantiateFilter(filterString);
        CCTextField lookInText = (CCTextField)this.fileChooser.getChild("lookIn");
        String location = (String)lookInText.getValue();
        try {
            if (model.canRead(location)) {
                this.files = model.getFiles(location);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        model.setCurrentDirectory(location);
        OptionList optionList = new OptionList();
        boolean filesExist = false;
        Locale locale = model.getLocale();
        if (locale == null) {
            locale = CCI18N.getTagsLocale(this.pageContext.getRequest());
        }
        if (this.files != null && this.files.length > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(model.getDateFormat(), locale);
            SimpleDateFormat timeFormat = null;
            String tmFormat = null;
            tmFormat = model instanceof CCFileChooserTimeInterface ? ((CCFileChooserTimeInterface)((Object)model)).getTimeFormat() : "HH:mm";
            timeFormat = new SimpleDateFormat(tmFormat, locale);
            for (i = 0; i < this.files.length; ++i) {
                String name = this.files[i].getName();
                String value = new Integer(i).toString();
                boolean bSelectable = false;
                boolean bIsDirectory = this.files[i].isDirectory();
                boolean disabled = false;
                if (!bIsDirectory) {
                    if (!filter.accept(this.files[i])) continue;
                    bSelectable = true;
                    if (model.getType().equals("folder")) {
                        disabled = true;
                    }
                } else {
                    bSelectable = true;
                }
                if (bSelectable) {
                    selectableValuesVec.addElement(value);
                    selectableNamesVec.addElement(name);
                    if (bIsDirectory) {
                        fileOrFolderVec.addElement("folder");
                    } else {
                        fileOrFolderVec.addElement("file");
                    }
                }
                if (bIsDirectory) {
                    name = name + File.separator;
                }
                name = this.getDisplayString(name, fileNameLen, space);
                String size = Long.toString(this.files[i].length());
                size = this.getDisplayString(size, fileSizeLen, space);
                Date modifiedDate = new Date(this.files[i].lastModified());
                String date = dateFormat.format(modifiedDate);
                String time = timeFormat.format(modifiedDate);
                NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
                buffer.append(name).append(space).append(space).append(space).append(size).append(space).append(space).append(date).append(space).append(time);
                CCOption option = new CCOption(buffer.toString(), value, disabled);
                optionList.add((Option)option);
                filesExist = true;
            }
        }
        if (!filesExist) {
            String label = "";
            String value = "0";
            int len = fileNameLen + fileSizeLen + fileDateLen + 6;
            for (i = 0; i < len; ++i) {
                label = label + HYFEN;
            }
            CCOption option = new CCOption(label, "0", true);
            optionList.add((Option)option);
        }
        CCSelectableList fileList = (CCSelectableList)this.fileChooser.getChild("files");
        CCTextField selectedFiles = (CCTextField)this.fileChooser.getChild("fileName");
        CCButton openBtn = (CCButton)this.fileChooser.getChild("openFolder");
        fileList.setOptions(optionList);
        fileList.setMultiple(model.multipleSelect());
        return this.createJavaScriptForFileList(fileList, selectedFiles, openBtn, selectableValuesVec, selectableNamesVec, fileOrFolderVec, dblClickBuffer);
    }

    private String getDisplayString(String str, int maxLen, String space) {
        int length = str.length();
        if (length < maxLen) {
            int spaceCount = maxLen - length;
            for (int j = 0; j < spaceCount; ++j) {
                str = str + space;
            }
        } else if (length > maxLen) {
            int shownLen = maxLen - 3;
            if (this.isNav4()) {
                shownLen += 3;
            }
            str = str.substring(0, shownLen);
            if (!this.isNav4()) {
                str = str + "...";
            }
        }
        return str;
    }

    private String createJavaScriptForFileList(CCSelectableList fileList, CCTextField selectedFiles, CCButton openBtn, Vector values, Vector names, Vector types, NonSyncStringBuffer dblClickBuffer) {
        int size = values.size();
        String fileListName = fileList.getQualifiedName();
        String textBoxName = selectedFiles.getQualifiedName();
        String buttonName = openBtn.getQualifiedName();
        CCFileChooserModelInterface model = this.fileChooser.getModel();
        dblClickBuffer.append("javascript: var types = new Array(").append(size).append(");\n");
        for (int i = 0; i < size; ++i) {
            dblClickBuffer.append("types[").append(i).append("] = '").append(types.elementAt(i)).append("';\n");
        }
        dblClickBuffer.append("var select = elements['").append(fileListName).append("'];\n").append("if (select.selectedIndex == -1) {\n").append("    return false; \n}\n").append("if ((types[select.selectedIndex] == 'file') &&").append(" (types[select.selectedIndex] != '").append(model.getType()).append("')) { \n").append("return false;\n}\n");
        NonSyncStringBuffer jsBuffer = new NonSyncStringBuffer(8192);
        jsBuffer.append("javascript: var values = new Array(").append(size).append(");").append("var names = new Array(").append(size).append(");").append("var types = new Array(").append(size).append(");\n");
        for (int i = 0; i < size; ++i) {
            jsBuffer.append("values[").append(i).append("] = '").append(values.elementAt(i)).append("';").append("names[").append(i).append("] = '").append(names.elementAt(i)).append("';").append("types[").append(i).append("] = '").append(types.elementAt(i)).append("';\n");
        }
        jsBuffer.append("var select = elements['").append(fileListName).append("'];\n").append("ccSetButtonDisabled('").append(buttonName).append("', '").append(this.getFormName()).append("', false);\n").append("if (select.selectedIndex == -1) {\n").append("    ccSetButtonDisabled('").append(buttonName).append("', '").append(this.getFormName()).append("', true); return false;\n}\n").append("var j; var k; var text = ''; ").append("var count = 0; var s = false;\n").append("if (types[select.selectedIndex] == 'file') { \n").append("s=true;\n}\n").append("for (j = 0; j < select.options.length; j++) {\n").append("if (select.options[j].selected){ \n").append("count++;\n").append("if (types[j]=='").append(model.getType()).append("') {\n").append("if ((text == null) || (text == '')) {\n").append("text = names[j]; \n").append("} else {\n").append("text = text + ',' + names[j];\n").append("} } } } \n").append("var selText = elements['").append(textBoxName).append("'];\n").append("if (text != '') { \n selText.value=text;\n} ").append("else { \n selText.value='';\n} \n").append("if ((count > 1) || (s)) {\n").append("    ccSetButtonDisabled('").append(buttonName).append("', '").append(this.getFormName()).append("', true);\n}\n").append(" return false;");
        return jsBuffer.toString();
    }

    public void setType(String value) {
        if (value != null && !value.toLowerCase().equals("file") && !value.toLowerCase().equals("folder")) {
            CCDebug.trace1("Invalid filechooser type attribute in jsp page: " + value);
            return;
        }
        this.setValue(ATTRIB_TYPE, value);
    }

    public String getType() {
        return this.getValue(ATTRIB_TYPE) != null ? (String)this.getValue(ATTRIB_TYPE) : "file";
    }

    public void setMultipleSelect(String value) {
        if (this.isInvalidValue(value)) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_MULTIPLE_SELECT, value);
    }

    public String getMultipleSelect() {
        return this.getValue(ATTRIB_MULTIPLE_SELECT) != null ? (String)this.getValue(ATTRIB_MULTIPLE_SELECT) : "false";
    }

    protected void setAttributes() {
        CCFileChooserModelInterface model = this.fileChooser.getModel();
        if (model.getType() == null) {
            model.setType(this.getType());
        }
        if (!model.isMultipleSelectSet()) {
            boolean result = Boolean.valueOf(this.getMultipleSelect());
            model.setMultipleSelect(result);
        }
    }

    private boolean isInvalidValue(String value) {
        return value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false");
    }

    private String getLabel(View view, String name, String value) throws JspException {
        CCLabel child = new CCLabel((ContainerView)view, name + ".Label", value);
        CCLabelTag ccLabelTag = new CCLabelTag();
        ccLabelTag.setBundleID("com.sun.web.ui");
        ccLabelTag.setElementName(name);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        buffer.append(ccLabelTag.getHTMLString(this.getParent(), this.pageContext, (View)child));
        return buffer.toString();
    }
}

