/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.filechooser;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.OptionList;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.filechooser.CCPopupEventHandlerInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.html.CCTextField;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CCFileChooser
extends RequestHandlingViewBase
implements CCStateData {
    public static final String FILE_NAME_TEXT = "fileName";
    public static final String ENTER_FLAG = "enterFlag";
    public static final String LOOK_IN_TEXTFIELD = "lookIn";
    public static final String TIME_TO_SORT_HREF = "timeToSort";
    public static final String LOOK_IN_COMMAND_HREF = "lookInEntered";
    public static final String ENTER_COMMAND_HREF = "listLookInEntered";
    public static final String SELECTED_FILE_COMMAND_HREF = "selectedFileEntered";
    public static final String FILE_TYPE_FILTER = "fileType";
    public static final String SORT_MENU = "sortField";
    public static final String FILE_LIST = "files";
    public static final String MOVE_UP_BUTTON = "moveUp";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String DB_CLICK_COMMAND_HREF = "DBClicked";
    public static final String OPEN_FOLDER_BUTTON = "openFolder";
    public static final String FILECHOOSER_ALERT_MSG = "alert";
    public static final String ENTER_KEY_PRESSED = "enterPressed";
    public static final String ENTER_KEY_PRESSED_INLISTBOX = "enterList";
    public static final String WINDOWS_OS = "window";
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private static final String SHOW_IN_DIALOG = "showInDialog";
    private static final String SHOW_CONTROL_BUTTONS = "showControlBtns";
    private static final String FILE_CHOOSER_TYPE = "type";
    protected CCFileChooserModelInterface model;
    private OptionList sortMenuOptions = new OptionList(new String[]{"filechooser.sortOption1", "filechooser.sortOption4", "filechooser.sortOption2", "filechooser.sortOption5", "filechooser.sortOption3", "filechooser.sortOption6"}, new String[]{"filechooser.sortOption1", "filechooser.sortOption4", "filechooser.sortOption2", "filechooser.sortOption5", "filechooser.sortOption3", "filechooser.sortOption6"});

    public CCFileChooser(ContainerView parent, CCFileChooserModelInterface model, String name) {
        super((View)parent, name);
        CCDebug.initTrace();
        RequestContext context = this.getRequestContext();
        this.setModel(model);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(FILE_LIST, CCSelectableList.class);
        this.registerChild(LOOK_IN_TEXTFIELD, CCTextField.class);
        this.registerChild(FILE_TYPE_FILTER, CCTextField.class);
        this.registerChild(FILE_NAME_TEXT, CCTextField.class);
        this.registerChild(ENTER_FLAG, CCHiddenField.class);
        this.registerChild(SORT_MENU, CCDropDownMenu.class);
        this.registerChild(OPEN_FOLDER_BUTTON, CCButton.class);
        this.registerChild(MOVE_UP_BUTTON, CCButton.class);
        this.registerChild(CANCEL_BUTTON, CCButton.class);
        this.registerChild(LOOK_IN_COMMAND_HREF, HREF.class);
        this.registerChild(ENTER_COMMAND_HREF, HREF.class);
        this.registerChild(SELECTED_FILE_COMMAND_HREF, HREF.class);
        this.registerChild(TIME_TO_SORT_HREF, HREF.class);
        this.registerChild(DB_CLICK_COMMAND_HREF, HREF.class);
        this.registerChild(FILECHOOSER_ALERT_MSG, CCAlertInline.class);
    }

    protected View createChild(String name) {
        if (name.equals(FILE_LIST)) {
            return new CCSelectableList((ContainerView)this, name, null);
        }
        if (name.equals(LOOK_IN_COMMAND_HREF) || name.equals(ENTER_COMMAND_HREF) || name.equals(SELECTED_FILE_COMMAND_HREF) || name.equals(TIME_TO_SORT_HREF) || name.equals(DB_CLICK_COMMAND_HREF)) {
            return new HREF((ContainerView)this, name, null);
        }
        if (name.equals(FILE_NAME_TEXT)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(ENTER_FLAG)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(LOOK_IN_TEXTFIELD) || name.equals(FILE_TYPE_FILTER)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(SORT_MENU)) {
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            child.setOptions(this.sortMenuOptions);
            child.setCommandChild(TIME_TO_SORT_HREF);
            return child;
        }
        if (name.equals(OPEN_FOLDER_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, "filechooser.openFolder");
            return child;
        }
        if (name.equals(MOVE_UP_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, "filechooser.upOneLevel");
            return child;
        }
        if (name.equals(CANCEL_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, "filechooser.cancel");
            return child;
        }
        if (name.equals(FILECHOOSER_ALERT_MSG)) {
            return new CCAlertInline((ContainerView)this, name, null);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, this.model.getCurrentDirectory());
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
    }

    public void resetStateData() throws ModelControlException {
        this.setDisplayFieldValue(FILE_NAME_TEXT, null);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, null);
        this.setDisplayFieldValue(FILE_TYPE_FILTER, null);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public Map getStateData() throws ModelControlException {
        String type;
        String filter;
        String folder;
        this.restoreStateData();
        if (this.model == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] fileNames = this.model.getSelectedFiles();
        if (fileNames != null) {
            map.put(FILE_NAME_TEXT, fileNames);
        }
        if ((folder = this.model.getCurrentDirectory()) != null) {
            map.put(LOOK_IN_TEXTFIELD, folder);
        }
        if ((filter = this.model.getFilterString()) != null) {
            map.put(FILE_TYPE_FILTER, filter);
        }
        if ((type = this.model.getType()) != null) {
            map.put(FILE_CHOOSER_TYPE, type);
        }
        return map;
    }

    public void restoreStateData() throws ModelControlException {
        String folder;
        String[] fileNames;
        String filter;
        if (this.model == null) {
            return;
        }
        Map map = (Map)this.getParentViewBean().getPageSessionAttribute(this.STATE_DATA);
        if (map == null) {
            return;
        }
        String type = (String)map.get(FILE_CHOOSER_TYPE);
        if (type != null) {
            this.model.setType(type);
        }
        if (this.model.getFileFilter() == null && (filter = (String)map.get(FILE_TYPE_FILTER)) != null) {
            this.model.setFilterString(filter);
        }
        if (this.model.getSelectedFiles() == null && (fileNames = (String[])map.get(FILE_NAME_TEXT)) != null && fileNames.length != 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                this.model.addSelectedFile(fileNames[i]);
            }
        }
        if (this.model.getCurrentDirectory() == null && (folder = (String)map.get(LOOK_IN_TEXTFIELD)) != null) {
            this.model.setCurrentDirectory(folder);
        }
    }

    public void setStateData(Map map) throws ModelControlException {
        String filter;
        String folder;
        String[] fileNames;
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.resetStateData();
        String sType = (String)map.get(FILE_CHOOSER_TYPE);
        if (sType != null) {
            this.model.setType(sType);
        }
        if ((fileNames = (String[])map.get(FILE_NAME_TEXT)) != null && fileNames.length != 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                this.model.addSelectedFile(fileNames[i]);
            }
        }
        if ((folder = (String)map.get(LOOK_IN_TEXTFIELD)) != null) {
            this.model.setCurrentDirectory(folder);
        }
        if ((filter = (String)map.get(FILE_TYPE_FILTER)) != null) {
            this.model.setFilterString(filter);
        }
    }

    public void setModel(CCFileChooserModelInterface model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.model = model;
    }

    public CCFileChooserModelInterface getModel() {
        return this.model;
    }

    public void handleOpenFolderRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.setSortField();
        CCSelectableList fileList = (CCSelectableList)this.getChild(FILE_LIST);
        String selectedValue = null;
        Object[] values = fileList.getValues();
        if (values == null || values.length == 0) {
            this.displayAlert("filechooser.noFolderSelectedErrSum", "filechooser.noFolderSelectedErrDet", null, null);
        } else if (values.length > 1) {
            this.displayAlert("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
        } else {
            selectedValue = (String)values[0];
            String currentDirectory = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
            if (currentDirectory == null || currentDirectory.length() == 0) {
                currentDirectory = this.model.getCurrentDirectory();
            }
            this.loadFiles(event, currentDirectory, selectedValue);
        }
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    protected void loadFiles(RequestInvocationEvent event, String currentDirectory, String selectedValue) {
        CCFileChooserModelInterface model = this.getModel();
        File[] files = null;
        try {
            if (!model.canRead(currentDirectory)) {
                currentDirectory = model.getCurrentDirectory();
                this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
            } else {
                files = model.getFiles(currentDirectory);
                CCSelectableList fileList = (CCSelectableList)this.getChild(FILE_LIST);
                int index = new Integer(selectedValue);
                if (files == null) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotCompleteErrDet", null, null);
                    currentDirectory = model.getCurrentDirectory();
                } else if (files.length > 0) {
                    File selectedFile = files[index];
                    if (!selectedFile.isDirectory()) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotCompleteErrDet", null, null);
                    } else if (!model.canRead(currentDirectory = currentDirectory.endsWith(File.separator) ? currentDirectory + selectedFile.getName() : currentDirectory + File.separator + selectedFile.getName())) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                        currentDirectory = model.getCurrentDirectory();
                    } else {
                        this.setDisplayFieldValue(FILE_NAME_TEXT, null);
                    }
                    fileList.setValue(null);
                }
            }
        }
        catch (Exception e) {
            this.displayAlert("filechooser.cannotCompleteErrSum", e.getLocalizedMessage(), null, null);
            currentDirectory = model.getCurrentDirectory();
        }
        model.setCurrentDirectory(currentDirectory);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, currentDirectory);
    }

    public void handleMoveUpRequest(RequestInvocationEvent event) throws ServletException, IOException {
        String flag = (String)this.getDisplayFieldValue(ENTER_FLAG);
        if (flag.equals(ENTER_KEY_PRESSED)) {
            this.handleLookInEnteredRequest(event);
        } else {
            this.setSortField();
            CCFileChooserModelInterface model = this.getModel();
            String dir = (String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD);
            int firstIndex = dir.indexOf(File.separator);
            int lastIndex = dir.lastIndexOf(File.separator);
            if (firstIndex == lastIndex) {
                if (dir.length() > firstIndex + 1) {
                    dir = dir.substring(0, firstIndex + 1);
                } else {
                    this.displayAlert("filechooser.errMoveUpErrSum", "filechooser.errMoveUpErrDet", null, null);
                }
            } else {
                if (dir.endsWith(File.separator)) {
                    dir = dir.substring(0, lastIndex);
                }
                dir = (lastIndex = dir.lastIndexOf(File.separator)) == 0 ? File.separator : dir.substring(0, lastIndex);
            }
            this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, dir);
            this.setDisplayFieldValue(FILE_NAME_TEXT, null);
            model.setCurrentDirectory(dir);
            ((CCSelectableList)this.getChild(FILE_LIST)).setValue(null);
            ViewBean targetView = this.getParentViewBean();
            targetView.forwardTo(this.getRequestContext());
        }
    }

    public void handleListLookInEnteredRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.handleOpenFolderRequest(event);
    }

    public void handleSelectedFileEnteredRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.setSortField();
        CCFileChooserModelInterface model = this.getModel();
        String selectedResource = ((String)this.getDisplayFieldValue(FILE_NAME_TEXT)).trim();
        String currentDirectory = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (currentDirectory == null || currentDirectory.length() == 0) {
            currentDirectory = model.getCurrentDirectory();
        }
        if (selectedResource != null && selectedResource.length() > 0) {
            currentDirectory = this.checkSelectedResource(selectedResource, currentDirectory, model);
        }
        model.setCurrentDirectory(currentDirectory);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, currentDirectory);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        ViewBean targetView = this.getParentViewBean();
        if (model.isPopupMode()) {
            ((CCPopupEventHandlerInterface)targetView).selectFieldEnterEvent(event);
        } else {
            targetView.forwardTo(this.getRequestContext());
        }
    }

    public void handleLookInEnteredRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.setSortField();
        String currentDirectory = null;
        String lookInDir = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (lookInDir == null || lookInDir.length() == 0) {
            currentDirectory = this.model.getHomeDirectory();
        } else {
            currentDirectory = this.stripExtraSeparators(lookInDir);
            try {
                boolean flag = true;
                if (!this.model.canRead(currentDirectory)) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                    currentDirectory = this.model.getCurrentDirectory();
                } else {
                    File[] list = this.model.getFiles(currentDirectory);
                    if (list == null) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{lookInDir});
                        currentDirectory = this.model.getCurrentDirectory();
                    }
                }
            }
            catch (Exception e) {
                this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.nameNotFolderErrDet", null, new String[]{lookInDir});
                currentDirectory = this.model.getCurrentDirectory();
            }
        }
        this.model.setCurrentDirectory(currentDirectory);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, currentDirectory);
        this.setDisplayFieldValue(ENTER_FLAG, null);
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    public void handleTimeToSortRequest(RequestInvocationEvent event) throws ServletException, IOException {
        CCFileChooserModelInterface model = this.getModel();
        String currentDirectory = model.getCurrentDirectory();
        this.setSortField();
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    public void handleDBClickedRequest(RequestInvocationEvent event) throws ServletException, IOException {
        this.setSortField();
        CCFileChooserModelInterface model = this.getModel();
        CCSelectableList fileList = (CCSelectableList)this.getChild(FILE_LIST);
        String currentDirectory = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (currentDirectory == null || currentDirectory.length() == 0) {
            currentDirectory = model.getCurrentDirectory();
        }
        String selectedValue = null;
        Object[] values = fileList.getValues();
        if (values == null || values.length == 0) {
            this.displayAlert("filechooser.noFolderSelectedErrSum", "filechooser.noFolderSelectedErrDet", null, null);
        } else if (values.length > 1) {
            this.displayAlert("filechooser.tooManyFolderErrSum", "filechooser.tooManyFolderErrDet", null, null);
        } else {
            selectedValue = (String)values[0];
            try {
                model.clearFiles();
                File[] files = model.getFiles(currentDirectory);
                int index = new Integer(selectedValue);
                if (files.length > 0) {
                    File selectedFile = files[index];
                    if (selectedFile.isDirectory()) {
                        if (!model.canRead(currentDirectory = currentDirectory.endsWith(File.separator) ? currentDirectory + selectedFile.getName() : currentDirectory + File.separator + selectedFile.getName())) {
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                            currentDirectory = model.getCurrentDirectory();
                        } else {
                            this.setDisplayFieldValue(FILE_NAME_TEXT, null);
                        }
                        fileList.setValue(null);
                    } else if (model.getType().equals("file")) {
                        model.addSelectedFile(currentDirectory.concat(File.separator).concat(selectedFile.getName()));
                    }
                }
            }
            catch (Exception e) {
                this.displayAlert("filechooser.cannotCompleteErrSum", e.getLocalizedMessage(), null, null);
            }
        }
        model.setCurrentDirectory(currentDirectory);
        this.setDisplayFieldValue(LOOK_IN_TEXTFIELD, currentDirectory);
        ViewBean targetView = this.getParentViewBean();
        if (model.isPopupMode()) {
            ((CCPopupEventHandlerInterface)targetView).dblClickEvent(event);
        } else {
            targetView.forwardTo(this.getRequestContext());
        }
    }

    public String[] getSelectedResources() {
        CCFileChooserModelInterface model = this.getModel();
        String selectedResource = ((String)this.getDisplayFieldValue(FILE_NAME_TEXT)).trim();
        String currentDirectory = ((String)this.getDisplayFieldValue(LOOK_IN_TEXTFIELD)).trim();
        if (currentDirectory == null || currentDirectory.length() == 0) {
            currentDirectory = model.getCurrentDirectory();
        }
        if (selectedResource != null && selectedResource.length() > 0) {
            currentDirectory = this.checkSelectedResource(selectedResource, currentDirectory, model);
            return model.getSelectedFiles();
        }
        CCSelectableList fileList = (CCSelectableList)this.getChild(FILE_LIST);
        Object[] selectedValue = fileList.getValues();
        model.clearFiles();
        if (selectedValue == null || selectedValue.length == 0) {
            return null;
        }
        File[] files = null;
        try {
            files = model.getFiles(currentDirectory);
        }
        catch (Exception e) {
            return null;
        }
        if (model.getType().equals("file")) {
            for (int i = 0; i < selectedValue.length; ++i) {
                String strIndex = (String)selectedValue[i];
                int index = new Integer(strIndex);
                if (files[index].isDirectory()) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                    model.clearFiles();
                    break;
                }
                this.addSelectedFile(currentDirectory, model, files[index]);
            }
        } else {
            for (int i = 0; i < selectedValue.length; ++i) {
                String strIndex = (String)selectedValue[i];
                int index = new Integer(strIndex);
                if (files[index].isFile()) {
                    this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                    model.clearFiles();
                    break;
                }
                this.addSelectedFile(currentDirectory, model, files[index]);
            }
        }
        return model.getSelectedFiles();
    }

    protected void setSortField() {
        CCFileChooserModelInterface model = this.getModel();
        String sort_field = (String)this.getDisplayFieldValue(SORT_MENU);
        if (sort_field.equals("filechooser.sortOption1")) {
            model.setSortField("alpha");
        } else if (sort_field.equals("filechooser.sortOption2")) {
            model.setSortField("lma");
        } else if (sort_field.equals("filechooser.sortOption3")) {
            model.setSortField("sza");
        } else if (sort_field.equals("filechooser.sortOption4")) {
            model.setSortField("alphd");
        } else if (sort_field.equals("filechooser.sortOption5")) {
            model.setSortField("lmd");
        } else if (sort_field.equals("filechooser.sortOption6")) {
            model.setSortField("szd");
        }
    }

    protected void displayAlert(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        CCFileChooserModelInterface model = this.getModel();
        CCI18N i18n = new CCI18N((ServletRequest)RequestManager.getRequest(), (ServletResponse)RequestManager.getResponse(), "com.sun.web.ui.resources.Resources", "com.sun.web.ui", null);
        ContainerView targetView = (ContainerView)this.getParent();
        CCAlertInline alert = (CCAlertInline)targetView.getChild(model.getAlertChildView());
        alert.setValue("error");
        if (summaryArgs != null && summaryArgs.length != 0) {
            alert.setSummary(i18n.getMessage(summary), summaryArgs);
        } else {
            alert.setSummary(i18n.getMessage(summary));
        }
        if (detailArgs != null && detailArgs.length != 0) {
            alert.setDetail(i18n.getMessage(detail), detailArgs);
        } else {
            alert.setDetail(i18n.getMessage(detail));
        }
    }

    private String checkSelectedResource(String selectedResource, String currentDirectory, CCFileChooserModelInterface model) {
        block17: {
            boolean isFileType = false;
            if (model.getType().equals("file")) {
                isFileType = true;
            }
            try {
                model.clearFiles();
                String[] tokens = selectedResource.split(",");
                String absolutePath = null;
                if (tokens.length == 1) {
                    absolutePath = this.getAbsolutePath(selectedResource, currentDirectory);
                    if (!model.canRead(absolutePath)) {
                        this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannot_read", null, null);
                        currentDirectory = model.getCurrentDirectory();
                    } else {
                        File[] files = model.getFiles(absolutePath);
                        if (isFileType) {
                            if (files == null) {
                                model.addSelectedFile(absolutePath);
                            } else {
                                currentDirectory = absolutePath;
                            }
                        } else {
                            model.addSelectedFile(absolutePath);
                            currentDirectory = absolutePath;
                        }
                    }
                    break block17;
                }
                for (int i = 0; i < tokens.length; ++i) {
                    absolutePath = this.getAbsolutePath(tokens[i].trim(), currentDirectory);
                    try {
                        if (!model.canRead(absolutePath)) continue;
                        File[] files = model.getFiles(absolutePath);
                        if (isFileType) {
                            if (files == null) {
                                model.addSelectedFile(absolutePath);
                                continue;
                            }
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null);
                            model.clearFiles();
                        } else {
                            if (files != null) {
                                model.addSelectedFile(absolutePath);
                                continue;
                            }
                            this.displayAlert("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null);
                            model.clearFiles();
                        }
                        break;
                    }
                    catch (Exception e) {
                        model.clearFiles();
                        CCDebug.trace1("cannot read " + absolutePath, e);
                    }
                }
            }
            catch (Exception e) {
                String key = null;
                key = isFileType ? "filechooser.fileSelectError" : "filechooser.folderSelectError";
                model.clearFiles();
                this.displayAlert("filechooser.cannotCompleteErrSum", key, null, null);
                currentDirectory = model.getCurrentDirectory();
            }
        }
        return currentDirectory;
    }

    private String getAbsolutePath(String name, String currentDirectory) {
        boolean absolute = false;
        if (this.getOSName().startsWith(WINDOWS_OS)) {
            if (name.startsWith("\\\\") || name.indexOf(":\\") != -1) {
                absolute = true;
            }
        } else if (name.startsWith(File.separator)) {
            absolute = true;
        }
        if (absolute) {
            return name;
        }
        return currentDirectory.concat(File.separator).concat(name);
    }

    private String getOSName() {
        return System.getProperty("os.name").toUpperCase();
    }

    private void addSelectedFile(String currentDirectory, CCFileChooserModelInterface model, File file) {
        NonSyncStringBuffer fileName = new NonSyncStringBuffer();
        fileName.append(currentDirectory);
        if (!currentDirectory.endsWith(File.separator)) {
            fileName.append(File.separator);
        }
        fileName.append(file.getName());
        model.addSelectedFile(fileName.toString());
    }

    private String stripExtraSeparators(String inStr) {
        if (inStr == null) {
            return null;
        }
        NonSyncStringBuffer outStr = new NonSyncStringBuffer();
        boolean repeat = false;
        int nChars = inStr.length();
        for (int i = 0; i < nChars; ++i) {
            if (inStr.charAt(i) == File.separatorChar) {
                if (repeat) continue;
                outStr.append(inStr.charAt(i));
                repeat = true;
                continue;
            }
            repeat = false;
            outStr.append(inStr.charAt(i));
        }
        return outStr.toString();
    }
}

