/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.security.SASLInputStream;
import com.sun.jmx.remote.opt.security.SASLOutputStream;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.SASLMessage;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;

public class SASLServerHandler
implements ProfileServer {
    private SaslServer saslServer = null;
    private byte[] blob = null;
    private Map env = null;
    private MessageConnection mc = null;
    private Socket socket = null;
    private String mechanism = null;
    private String profile = null;
    private Subject subject = null;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SASLServerHandler");

    public SASLServerHandler(String string, Map map) {
        this.profile = string;
        this.env = map;
    }

    public void initialize(MessageConnection messageConnection, Subject subject) throws IOException {
        this.mc = messageConnection;
        this.subject = subject;
        if (!(messageConnection instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        this.socket = ((SocketConnectionIf)((Object)messageConnection)).getSocket();
        this.mechanism = this.profile.substring(this.profile.indexOf("SASL/") + 5);
        String string = (String)this.env.get("jmx.remote.x.sasl.server.name");
        if (string == null) {
            string = this.socket.getLocalAddress().getHostName();
        }
        CallbackHandler callbackHandler = (CallbackHandler)this.env.get("jmx.remote.sasl.callback.handler");
        this.saslServer = Sasl.createSaslServer(this.mechanism, "jmxmp", string, this.env, callbackHandler);
        if (this.saslServer == null) {
            String string2 = "Unable to create SASL server connection for authentication mechanism [" + this.mechanism + "]";
            throw new IOException(string2);
        }
    }

    public ProfileMessage produceMessage() throws IOException {
        int n = this.saslServer.isComplete() ? 2 : 1;
        SASLMessage sASLMessage = new SASLMessage(this.mechanism, n, this.blob);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> SASL server message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + sASLMessage.getProfileName());
            logger.trace("produceMessage", "Status : " + sASLMessage.getStatus());
        }
        return sASLMessage;
    }

    public void consumeMessage(ProfileMessage profileMessage) throws IOException {
        if (!(profileMessage instanceof SASLMessage)) {
            throw new IOException("Unexpected profile message type: " + profileMessage.getClass().getName());
        }
        SASLMessage sASLMessage = (SASLMessage)profileMessage;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> SASL client message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + sASLMessage.getProfileName());
            logger.trace("consumeMessage", "Status : " + sASLMessage.getStatus());
        }
        if (sASLMessage.getStatus() != 1) {
            throw new IOException("Unexpected SASL status [" + sASLMessage.getStatus() + "]");
        }
        if (this.saslServer.isComplete()) {
            throw new IOException("SASL authentication complete despite the client claim for non-completion");
        }
        this.blob = this.saslServer.evaluateResponse(sASLMessage.getBlob());
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public Subject activate() throws IOException {
        Object object;
        Object object2;
        String string = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        if (string != null && (string.equalsIgnoreCase("auth-int") || string.equalsIgnoreCase("auth-conf"))) {
            object2 = new SASLInputStream(this.saslServer, this.socket.getInputStream());
            object = new SASLOutputStream(this.saslServer, this.socket.getOutputStream());
            ((SocketConnectionIf)((Object)this.mc)).replaceStreams((InputStream)object2, (OutputStream)object);
        }
        object2 = this.saslServer.getAuthorizationID();
        object = new JMXPrincipal((String)object2);
        if (this.subject == null) {
            this.subject = new Subject();
        }
        AccessController.doPrivileged(new PrivilegedAction((Principal)object){
            private final /* synthetic */ Principal val$principal;
            {
                this.val$principal = principal;
            }

            public Object run() {
                SASLServerHandler.this.subject.getPrincipals().add(this.val$principal);
                return null;
            }
        });
        return this.subject;
    }

    public void terminate() throws IOException {
        this.saslServer.dispose();
    }

    public String getName() {
        return this.profile;
    }
}

