/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorEvent;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.DeferredLockManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.helper.TopLinkIdentityHashSet;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.AggregateObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.querykeys.DirectQueryKey;
import oracle.toplink.essentials.querykeys.QueryKey;
import oracle.toplink.essentials.sessions.DatabaseRecord;
import oracle.toplink.essentials.sessions.ObjectCopyingPolicy;
import oracle.toplink.essentials.sessions.Record;

public class ObjectBuilder
implements Cloneable,
Serializable {
    protected ClassDescriptor descriptor;
    protected Map mappingsByAttribute;
    protected Map mappingsByField = new HashMap(20);
    protected Map readOnlyMappingsByField = new HashMap(20);
    protected Vector primaryKeyMappings;
    protected Vector primaryKeyClassifications;
    protected transient Vector nonPrimaryKeyMappings;
    protected transient Expression primaryKeyExpression;
    protected Vector joinedAttributes = null;
    protected List cloningMappings;

    public ObjectBuilder(ClassDescriptor descriptor) {
        this.mappingsByAttribute = new HashMap(20);
        this.primaryKeyMappings = NonSynchronizedVector.newInstance(5);
        this.nonPrimaryKeyMappings = NonSynchronizedVector.newInstance(10);
        this.cloningMappings = new ArrayList(10);
        this.descriptor = descriptor;
    }

    public AbstractRecord createRecord() {
        return new DatabaseRecord();
    }

    public AbstractRecord createRecord(int size) {
        return new DatabaseRecord(size);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow) {
        this.addPrimaryKeyForNonDefaultTable(databaseRow, null, null);
    }

    public void addPrimaryKeyForNonDefaultTable(AbstractRecord databaseRow, Object object, AbstractSession session) {
        if (!this.getDescriptor().hasMultipleTables()) {
            return;
        }
        Enumeration tablesEnum = this.getDescriptor().getTables().elements();
        tablesEnum.nextElement();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = (DatabaseTable)tablesEnum.nextElement();
            Map keyMapping = (Map)this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(table);
            if (keyMapping == null) continue;
            Iterator primaryKeyFieldEnum = keyMapping.keySet().iterator();
            Iterator secondaryKeyFieldEnum = keyMapping.values().iterator();
            while (primaryKeyFieldEnum.hasNext()) {
                DatabaseField primaryKeyField = (DatabaseField)primaryKeyFieldEnum.next();
                DatabaseField secondaryKeyField = (DatabaseField)secondaryKeyFieldEnum.next();
                Object primaryValue = databaseRow.get(primaryKeyField);
                if (primaryValue == null && !databaseRow.containsKey(primaryKeyField)) {
                    if (object != null) {
                        DatabaseMapping mapping = this.getMappingForField(secondaryKeyField);
                        if (mapping == null) {
                            throw DescriptorException.missingMappingForField(secondaryKeyField, this.getDescriptor());
                        }
                        mapping.writeFromObjectIntoRow(object, databaseRow, session);
                    }
                    databaseRow.put(primaryKeyField, databaseRow.get(secondaryKeyField));
                    continue;
                }
                databaseRow.put(secondaryKeyField, primaryValue);
            }
        }
    }

    public void assignReturnRow(Object object, AbstractSession writeSession, AbstractRecord row) throws DatabaseException {
        writeSession.log(1, "query", "assign_return_row", row);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(writeSession);
        HashSet handledMappings = new HashSet(row.size());
        for (int index = 0; index < row.size(); ++index) {
            DatabaseField field = (DatabaseField)row.getFields().elementAt(index);
            this.assignReturnValueForField(object, query, row, field, handledMappings);
        }
    }

    public void assignReturnValueForField(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, Collection handledMappings) {
        Vector mappingVector;
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping != null) {
            this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings);
        }
        if ((mappingVector = this.getReadOnlyMappingsForField(field)) != null) {
            for (int j = 0; j < mappingVector.size(); ++j) {
                mapping = (DatabaseMapping)mappingVector.elementAt(j);
                this.assignReturnValueToMapping(object, query, row, field, mapping, handledMappings);
            }
        }
    }

    protected void assignReturnValueToMapping(Object object, ReadObjectQuery query, AbstractRecord row, DatabaseField field, DatabaseMapping mapping, Collection handledMappings) {
        if (handledMappings.contains(mapping)) {
            return;
        }
        if (mapping.isAggregateObjectMapping()) {
            Object attributeValue = ((AggregateObjectMapping)mapping).readFromReturnRowIntoObject(row, object, query, handledMappings);
        } else if (mapping.isDirectToFieldMapping()) {
            Object attributeValue = mapping.readFromRowIntoObject(row, null, object, query);
        } else {
            query.getSession().log(1, "query", "field_for_unsupported_mapping_returned", field, this.getDescriptor());
        }
    }

    public Object assignSequenceNumber(Object object, AbstractSession writeSession) throws DatabaseException {
        DatabaseField sequenceNumberField = this.getDescriptor().getSequenceNumberField();
        Object existingValue = this.getBaseValueForField(sequenceNumberField, object);
        if (existingValue != null && !writeSession.getSequencing().shouldOverrideExistingValue(object.getClass(), existingValue)) {
            return null;
        }
        Object sequenceValue = writeSession.getSequencing().getNextValue(object.getClass());
        writeSession.log(1, "sequencing", "assign_sequence", sequenceValue, object);
        if (sequenceValue == null) {
            return null;
        }
        AbstractRecord tempRow = this.createRecord(1);
        tempRow.put(sequenceNumberField, sequenceValue);
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSession(writeSession);
        DatabaseMapping mapping = this.getBaseMappingForField(sequenceNumberField);
        Object sequenceIntoObject = this.getParentObjectForField(sequenceNumberField, object);
        Object convertedSequenceValue = mapping.readFromRowIntoObject(tempRow, null, sequenceIntoObject, query);
        return convertedSequenceValue;
    }

    public void buildAttributesIntoObject(Object domainObject, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh) throws DatabaseException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector mappings = this.getDescriptor().getMappings();
        boolean readAllMappings = query.shouldReadAllMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (!readAllMappings && !query.shouldReadMapping(mapping)) continue;
            mapping.readFromRowIntoObject(databaseRow, joinManager, domainObject, query, executionSession);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(domainObject);
            event.setQuery(query);
            event.setSession(query.getSession());
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
            }
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public Object buildBackupClone(Object clone, UnitOfWorkImpl unitOfWork) {
        Object backup = this.getDescriptor().getCopyPolicy().buildClone(clone, unitOfWork);
        List mappings = this.getCloningMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).buildBackupClone(clone, backup, unitOfWork);
        }
        return backup;
    }

    public Expression buildDeleteExpression(DatabaseTable table, AbstractRecord row) {
        if (this.getDescriptor().usesOptimisticLocking() && this.getDescriptor().getTables().firstElement().equals(table)) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildDeleteExpression(table, this.primaryKeyExpression, row);
        }
        return this.buildPrimaryKeyExpression(table);
    }

    public Object buildNewInstance() {
        return this.getDescriptor().getInstantiationPolicy().buildNewInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        AbstractSession session = query.getSession();
        session.startOperationProfile("object building");
        Vector primaryKey = this.extractPrimaryKeyFromRow(databaseRow, session);
        if (primaryKey == null && !query.hasPartialAttributeExpressions() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            session.endOperationProfile("object building");
            if (query.getProperty("return null if primary key is null") != null) {
                return null;
            }
            throw QueryException.nullPrimaryKeyInBuildingObject(query, databaseRow);
        }
        ClassDescriptor concreteDescriptor = this.getDescriptor();
        if (concreteDescriptor.hasInheritance() && concreteDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
            Class classValue = concreteDescriptor.getInheritancePolicy().classFromRow(databaseRow, session);
            if ((concreteDescriptor = session.getDescriptor(classValue)) == null && query.hasPartialAttributeExpressions()) {
                concreteDescriptor = this.getDescriptor();
            }
            if (concreteDescriptor == null) {
                session.endOperationProfile("object building");
                throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
            }
        }
        Object domainObject = null;
        try {
            if (session.isUnitOfWork()) {
                domainObject = this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor);
            } else {
                domainObject = this.buildObject(query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
                if (query.shouldUseWrapperPolicy()) {
                    domainObject = concreteDescriptor.getObjectBuilder().wrapObject(domainObject, session);
                }
            }
        }
        finally {
            session.endOperationProfile("object building");
        }
        return domainObject;
    }

    protected Object buildObjectInUnitOfWork(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey, ClassDescriptor concreteDescriptor) throws DatabaseException, QueryException {
        if ((unitOfWork.getCommitManager().isActive() || unitOfWork.wasTransactionBegunPrematurely()) && !unitOfWork.isClassReadOnly(concreteDescriptor.getJavaClass())) {
            return concreteDescriptor.getObjectBuilder().buildWorkingCopyCloneFromRow(query, joinManager, databaseRow, unitOfWork, primaryKey);
        }
        return this.buildWorkingCopyCloneNormally(query, databaseRow, unitOfWork, primaryKey, concreteDescriptor, joinManager);
    }

    protected Object buildWorkingCopyCloneNormally(ObjectBuildingQuery query, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        AbstractSession session = unitOfWork.getParentIdentityMapSession(query);
        Object original = null;
        Object clone = null;
        query.setSession(session);
        original = session.isUnitOfWork() ? this.buildObjectInUnitOfWork(query, joinManager, databaseRow, (UnitOfWorkImpl)session, primaryKey, concreteDescriptor) : this.buildObject(query, databaseRow, session, primaryKey, concreteDescriptor, joinManager);
        query.setSession(unitOfWork);
        clone = unitOfWork.shouldCascadeCloneToJoinedRelationship() ? query.registerIndividualResult(original, unitOfWork, false, joinManager) : query.registerIndividualResult(original, unitOfWork, false, null);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, Vector primaryKey, ClassDescriptor concreteDescriptor, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        Object domainObject = null;
        CacheKey cacheKey = null;
        try {
            if (query.shouldMaintainCache()) {
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (concreteDescriptor.shouldAcquireCascadedLocks() || joinManager.hasJoinedAttributes())) {
                    int counter;
                    cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                    domainObject = cacheKey.getObject();
                    for (counter = 0; domainObject == null && counter < 1000 && cacheKey.getMutex().getActiveThread() != Thread.currentThread(); ++counter) {
                        cacheKey.releaseDeferredLock();
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                        }
                        cacheKey = session.getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                        domainObject = cacheKey.getObject();
                    }
                    if (counter == 1000) {
                        throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(cacheKey.getMutex().getActiveThread(), Thread.currentThread());
                    }
                } else {
                    cacheKey = session.getIdentityMapAccessorInstance().acquireLock(primaryKey, concreteDescriptor.getJavaClass(), concreteDescriptor);
                    domainObject = cacheKey.getObject();
                }
            }
            if (domainObject == null) {
                domainObject = query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject() ? ((ReadObjectQuery)query).getSelectionObject() : concreteDescriptor.getObjectBuilder().buildNewInstance();
                if (query.shouldMaintainCache()) {
                    cacheKey.setObject(domainObject);
                    this.copyQueryInfoToCacheKey(cacheKey, query, databaseRow, session, concreteDescriptor);
                    if (concreteDescriptor.hasFetchGroupManager()) {
                        concreteDescriptor.getFetchGroupManager().setObjectFetchGroup(domainObject, query.getFetchGroup());
                    }
                }
                concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
            } else {
                if (query.isReadObjectQuery() && ((ReadObjectQuery)query).shouldLoadResultIntoSelectionObject()) {
                    this.copyInto(domainObject, ((ReadObjectQuery)query).getSelectionObject());
                    domainObject = ((ReadObjectQuery)query).getSelectionObject();
                }
                boolean isInvalidated = concreteDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, query.getExecutionTime());
                if (cacheKey.getMutex().getActiveThread() == Thread.currentThread() && (query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache() || isInvalidated) && cacheKey.getLastUpdatedQueryId() != query.getQueryId() && !cacheKey.getMutex().isLockedByMergeManager()) {
                    if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject)) {
                        this.revertFetchGroupData(domainObject, concreteDescriptor, cacheKey, (ObjectLevelReadQuery)query, joinManager, databaseRow, session);
                    } else {
                        boolean refreshRequired = true;
                        if (concreteDescriptor.usesOptimisticLocking()) {
                            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
                            Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
                            if (concreteDescriptor.shouldOnlyRefreshCacheIfNewerVersion() && !(refreshRequired = policy.isNewerVersion(databaseRow, domainObject, primaryKey, session))) {
                                cacheKey.setReadTime(query.getExecutionTime());
                            }
                            if (refreshRequired) {
                                cacheKey.setWriteLockValue(cacheValue);
                            }
                        }
                        if (refreshRequired) {
                            cacheKey.setLastUpdatedQueryId(query.getQueryId());
                            concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, true);
                            cacheKey.setReadTime(query.getExecutionTime());
                        }
                    }
                } else if (concreteDescriptor.hasFetchGroupManager() && concreteDescriptor.getFetchGroupManager().isPartialObject(domainObject) && !concreteDescriptor.getFetchGroupManager().isObjectValidForFetchGroup(domainObject, query.getFetchGroup())) {
                    concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
                    concreteDescriptor.getFetchGroupManager().unionFetchGroupIntoObject(domainObject, query.getFetchGroup());
                } else if (joinManager.hasJoinedAttributeExpressions()) {
                    for (QueryKeyExpression qke : joinManager.getJoinedAttributeExpressions()) {
                        if (!qke.getBaseExpression().isExpressionBuilder()) continue;
                        DatabaseMapping dm = this.getMappingForAttributeName(qke.getName());
                        if (dm == null) {
                            throw ValidationException.missingMappingForAttribute(concreteDescriptor, qke.getName(), this.toString());
                        }
                        Object attributeValue = dm.getAttributeValueFromObject(domainObject);
                        if (attributeValue != null && dm.isForeignReferenceMapping() && ((ForeignReferenceMapping)dm).usesIndirection() && ((ForeignReferenceMapping)dm).getIndirectionPolicy().objectIsInstantiated(attributeValue)) continue;
                        dm.readFromRowIntoObject(databaseRow, joinManager, domainObject, query, query.getSession().getExecutionSession(query));
                    }
                }
            }
        }
        finally {
            if (query.shouldMaintainCache() && cacheKey != null) {
                if (cacheKey.getObject() != null) {
                    cacheKey.updateAccess();
                }
                if (DeferredLockManager.SHOULD_USE_DEFERRED_LOCKS && (concreteDescriptor.shouldAcquireCascadedLocks() || joinManager.hasJoinedAttributes())) {
                    cacheKey.releaseDeferredLock();
                } else {
                    cacheKey.release();
                }
            }
        }
        return domainObject;
    }

    private void revertFetchGroupData(Object domainObject, ClassDescriptor concreteDescriptor, CacheKey cacheKey, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, AbstractSession session) {
        concreteDescriptor.getFetchGroupManager().reset(domainObject);
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, databaseRow, query, joinManager, false);
        concreteDescriptor.getFetchGroupManager().setObjectFetchGroup(domainObject, query.getFetchGroup());
        concreteDescriptor.getFetchGroupManager().setRefreshOnFetchGroupToObject(domainObject, query.shouldRefreshIdentityMapResult() || concreteDescriptor.shouldAlwaysRefreshCache());
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            cacheKey.setWriteLockValue(policy.getValueToPutInCache(databaseRow, session));
        }
        cacheKey.setReadTime(query.getExecutionTime());
        cacheKey.setInvalidationState(0);
    }

    public Object buildObjectsInto(ReadAllQuery query, Vector databaseRows, Object domainObjects) throws DatabaseException {
        Set identitySet = null;
        Enumeration rowsEnum = databaseRows.elements();
        while (rowsEnum.hasMoreElements()) {
            AbstractRecord databaseRow = (AbstractRecord)rowsEnum.nextElement();
            if (databaseRow == null) continue;
            Object domainObject = this.buildObject(query, databaseRow, query.getJoinedAttributeManager());
            if (query.getJoinedAttributeManager().isToManyJoin()) {
                if (identitySet == null) {
                    identitySet = new TopLinkIdentityHashSet(databaseRows.size());
                }
                if (identitySet.contains(domainObject)) continue;
                identitySet.add(domainObject);
                query.getContainerPolicy().addInto(domainObject, domainObjects, query.getSession());
                continue;
            }
            query.getContainerPolicy().addInto(domainObject, domainObjects, query.getSession());
        }
        return domainObjects;
    }

    public Expression buildPrimaryKeyExpression(DatabaseTable table) throws DescriptorException {
        if (this.getDescriptor().getTables().firstElement().equals(table)) {
            return this.getPrimaryKeyExpression();
        }
        Map keyMapping = (Map)this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(table);
        if (keyMapping == null) {
            throw DescriptorException.multipleTablePrimaryKeyNotSpecified(this.getDescriptor());
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = null;
        for (DatabaseField field : keyMapping.values()) {
            expression = builder.getField(field).equal(builder.getParameter(field)).and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromKeys(Vector primaryKeyValues, AbstractSession session) {
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            Object value = primaryKeyValues.get(index);
            DatabaseField field = (DatabaseField)primaryKeyFields.get(index);
            if (value == null) continue;
            Expression subExpression = ((Expression)builder).getField(field).equal(value);
            expression = subExpression.and(expression);
        }
        return expression;
    }

    public Expression buildPrimaryKeyExpressionFromObject(Object domainObject, AbstractSession session) {
        return this.buildPrimaryKeyExpressionFromKeys(this.extractPrimaryKeyFromObject(domainObject, session), session);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session) {
        return this.buildRow(this.createRecord(), object, session);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session) {
        Vector mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForShallowInsert(Object object, AbstractSession session) {
        return this.buildRowForShallowInsert(this.createRecord(), object, session);
    }

    public AbstractRecord buildRowForShallowInsert(AbstractRecord databaseRow, Object object, AbstractSession session) {
        Vector mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRowForShallowInsert(object, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowWithChangeSet(ObjectChangeSet objectChangeSet, AbstractSession session) {
        return this.buildRowWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public AbstractRecord buildRowWithChangeSet(AbstractRecord databaseRow, ObjectChangeSet objectChangeSet, AbstractSession session) {
        Enumeration changeRecords = objectChangeSet.getChanges().elements();
        while (changeRecords.hasMoreElements()) {
            ChangeRecord changeRecord = (ChangeRecord)changeRecords.nextElement();
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForShallowInsertWithChangeSet(ObjectChangeSet objectChangeSet, AbstractSession session) {
        return this.buildRowForShallowInsertWithChangeSet(this.createRecord(), objectChangeSet, session);
    }

    public AbstractRecord buildRowForShallowInsertWithChangeSet(AbstractRecord databaseRow, ObjectChangeSet objectChangeSet, AbstractSession session) {
        for (ChangeRecord changeRecord : objectChangeSet.getChanges()) {
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForTranslation(Object object, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getPrimaryKeyMappings()) {
            if (mapping == null) continue;
            mapping.writeFromObjectIntoRow(object, databaseRow, session);
        }
        this.addPrimaryKeyForNonDefaultTable(databaseRow, object, session);
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdate(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeFromObjectIntoRowForUpdate(query, databaseRow);
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().isAggregateDescriptor() && query.getObject() != null) {
            if (query.getBackupClone() == null) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            } else if (!query.getObject().getClass().equals(query.getBackupClone().getClass())) {
                this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToRow(databaseRow);
            }
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForUpdateWithChangeSet(WriteObjectQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        for (ChangeRecord changeRecord : query.getObjectChangeSet().getChanges()) {
            DatabaseMapping mapping = changeRecord.getMapping();
            mapping.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, query.getSession());
        }
        return databaseRow;
    }

    public AbstractRecord buildRowForWhereClause(ObjectLevelModifyQuery query) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            mapping.writeFromObjectIntoRowForWhereClause(query, databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        return databaseRow;
    }

    public AbstractRecord buildRowFromPrimaryKeyValues(Vector key, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(key.size());
        int keySize = key.size();
        for (int index = 0; index < keySize; ++index) {
            DatabaseField field = (DatabaseField)this.getDescriptor().getPrimaryKeyFields().get(index);
            Object value = key.elementAt(index);
            value = session.getPlatform(this.getDescriptor().getJavaClass()).getConversionManager().convertObject(value, field.getType());
            databaseRow.put(field, value);
        }
        return databaseRow;
    }

    public AbstractRecord buildTemplateInsertRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        this.buildTemplateInsertRow(session, databaseRow);
        return databaseRow;
    }

    public void buildTemplateInsertRow(AbstractSession session, AbstractRecord databaseRow) {
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            mapping.writeInsertFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().addClassIndicatorFieldToInsertRow(databaseRow);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(databaseRow);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        if (this.getDescriptor().usesSequenceNumbers() && session.getSequencing().shouldAcquireValueAfterInsert(this.getDescriptor().getJavaClass())) {
            databaseRow.remove(this.getDescriptor().getSequenceNumberField());
        }
    }

    public AbstractRecord buildTemplateUpdateRow(AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord();
        for (DatabaseMapping mapping : this.getNonPrimaryKeyMappings()) {
            mapping.writeUpdateFieldsIntoRow(databaseRow, session);
        }
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().addLockFieldsToUpdateRow(databaseRow, session);
        }
        return databaseRow;
    }

    public Expression buildUpdateExpression(DatabaseTable table, AbstractRecord transactionRow, AbstractRecord modifyRow) {
        Expression primaryKeyExpression = this.buildPrimaryKeyExpression(table);
        if (this.getDescriptor().usesOptimisticLocking()) {
            return this.getDescriptor().getOptimisticLockingPolicy().buildUpdateExpression(table, primaryKeyExpression, transactionRow, modifyRow);
        }
        return primaryKeyExpression;
    }

    public void buildPrimaryKeyAttributesIntoObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query) throws DatabaseException, QueryException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector mappings = this.getPrimaryKeyMappings();
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            mapping.buildShallowOriginalFromRow(databaseRow, original, query, executionSession);
        }
    }

    public void buildAttributesIntoShallowObject(Object original, AbstractRecord databaseRow, ObjectBuildingQuery query) throws DatabaseException, QueryException {
        AbstractSession executionSession = query.getSession().getExecutionSession(query);
        Vector pkMappings = this.getPrimaryKeyMappings();
        int mappingsSize = pkMappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = (DatabaseMapping)pkMappings.get(i);
            if (mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, query, executionSession);
        }
        Vector mappings = this.getDescriptor().getMappings();
        mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!mapping.isDirectToFieldMapping()) continue;
            mapping.buildShallowOriginalFromRow(databaseRow, original, query, executionSession);
        }
    }

    public void buildAttributesIntoWorkingCopyClone(Object clone, ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, boolean forRefresh) throws DatabaseException, QueryException {
        UnitOfWorkImpl executionSession = unitOfWork;
        Vector mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!query.shouldReadMapping(mapping)) continue;
            mapping.buildCloneFromRow(databaseRow, joinManager, clone, query, unitOfWork, executionSession);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setQuery(query);
            event.setSession(query.getSession());
            event.setRecord(databaseRow);
            if (forRefresh) {
                event.setEventCode(9);
            } else {
                event.setEventCode(8);
            }
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object buildWorkingCopyCloneFromRow(ObjectBuildingQuery query, JoinedAttributeManager joinManager, AbstractRecord databaseRow, UnitOfWorkImpl unitOfWork, Vector primaryKey) throws DatabaseException, QueryException {
        CacheKey originalCacheKey;
        boolean isARefresh;
        Object workingClone = unitOfWork.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(primaryKey, this.getDescriptor().getJavaClass(), this.getDescriptor());
        boolean wasAClone = workingClone != null;
        boolean bl = isARefresh = query.shouldRefreshIdentityMapResult() || query.isLockQuery() && (!wasAClone || !query.isClonePessimisticLocked(workingClone, unitOfWork));
        if (wasAClone && !isARefresh) {
            return workingClone;
        }
        boolean wasAnOriginal = false;
        Object original = null;
        if (!isARefresh && !unitOfWork.shouldReadFromDB() && (originalCacheKey = unitOfWork.getParentIdentityMapSession(query).getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, this.getDescriptor().getJavaClass(), this.getDescriptor())) != null) {
            try {
                originalCacheKey.acquireReadLock();
                original = originalCacheKey.getObject();
            }
            finally {
                originalCacheKey.releaseReadLock();
            }
            wasAnOriginal = original != null;
            boolean bl2 = isARefresh = wasAnOriginal && (this.getDescriptor().shouldAlwaysRefreshCache() || this.getDescriptor().getCacheInvalidationPolicy().isInvalidated(originalCacheKey, query.getExecutionTime()));
            if (wasAnOriginal && !isARefresh) {
                return unitOfWork.cloneAndRegisterObject(original, originalCacheKey, joinManager);
            }
        }
        CacheKey unitOfWorkCacheKey = null;
        if (!wasAClone) {
            if (wasAnOriginal) {
                workingClone = this.instantiateWorkingCopyClone(original, unitOfWork);
                unitOfWork.getCloneToOriginals().put(workingClone, original);
            } else {
                workingClone = this.instantiateWorkingCopyCloneFromRow(databaseRow, query);
            }
            unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().internalPutInIdentityMap(workingClone, primaryKey, null, 0L, this.getDescriptor());
            unitOfWork.getCloneMapping().put(workingClone, workingClone);
        }
        if (unitOfWorkCacheKey == null) {
            unitOfWorkCacheKey = unitOfWork.getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, this.getDescriptor().getJavaClass(), this.getDescriptor());
        }
        if (wasAClone && unitOfWorkCacheKey.getLastUpdatedQueryId() >= query.getQueryId()) {
            return workingClone;
        }
        this.copyQueryInfoToCacheKey(unitOfWorkCacheKey, query, databaseRow, unitOfWork, this.getDescriptor());
        if (!wasAClone) {
            this.descriptor.getObjectChangePolicy().setChangeListener(workingClone, unitOfWork, this.getDescriptor());
        }
        this.descriptor.getObjectChangePolicy().dissableEventProcessing(workingClone);
        this.buildAttributesIntoWorkingCopyClone(workingClone, query, joinManager, databaseRow, unitOfWork, wasAClone);
        Object backupClone = this.getDescriptor().getObjectChangePolicy().buildBackupClone(workingClone, this, unitOfWork);
        if (wasAClone) {
            this.descriptor.getObjectChangePolicy().clearChanges(workingClone, unitOfWork, this.getDescriptor());
        }
        this.descriptor.getObjectChangePolicy().enableEventProcessing(workingClone);
        unitOfWork.getCloneMapping().put(workingClone, backupClone);
        query.recordCloneForPessimisticLocking(workingClone, unitOfWork);
        return workingClone;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ObjectBuilder)object).setMappingsByAttribute(new HashMap(this.getMappingsByAttribute()));
        ((ObjectBuilder)object).setMappingsByField(new HashMap(this.getMappingsByField()));
        ((ObjectBuilder)object).setReadOnlyMappingsByField(new HashMap(this.getReadOnlyMappingsByField()));
        ((ObjectBuilder)object).setPrimaryKeyMappings((Vector)this.getPrimaryKeyMappings().clone());
        ((ObjectBuilder)object).setNonPrimaryKeyMappings((Vector)this.getNonPrimaryKeyMappings().clone());
        return object;
    }

    public void cascadePerformRemove(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Iterator mappings = this.getDescriptor().getMappings().iterator();
        while (mappings.hasNext()) {
            ((DatabaseMapping)mappings.next()).cascadePerformRemoveIfRequired(object, uow, visitedObjects);
        }
    }

    public void cascadeRegisterNewForCreate(Object object, UnitOfWorkImpl uow, IdentityHashtable visitedObjects) {
        Iterator mappings = this.getDescriptor().getMappings().iterator();
        while (mappings.hasNext()) {
            ((DatabaseMapping)mappings.next()).cascadeRegisterNewIfRequired(object, uow, visitedObjects);
        }
    }

    public ObjectChangeSet compareForChange(Object clone, Object backUp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        return this.descriptor.getObjectChangePolicy().calculateChanges(clone, backUp, changeSet, session, this.getDescriptor(), true);
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            if (mapping.compareObjects(firstObject, secondObject, session)) continue;
            Object firstValue = mapping.getAttributeValueFromObject(firstObject);
            Object secondValue = mapping.getAttributeValueFromObject(secondObject);
            session.log(1, "query", "compare_failed", mapping, firstValue, secondValue);
            return false;
        }
        return true;
    }

    public void copyInto(Object source, Object target) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.setAttributeValueInObject(target, mapping.getAttributeValueFromObject(source));
        }
    }

    public Object copyObject(Object original, ObjectCopyingPolicy policy) {
        Object copy = policy.getCopies().get(original);
        if (copy != null) {
            return copy;
        }
        copy = this.instantiateClone(original, policy.getSession());
        policy.getCopies().put(original, copy);
        List mappings = this.getCloningMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).buildCopy(copy, original, policy);
        }
        if (policy.shouldResetPrimaryKey() && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
            boolean hasOneToOne = false;
            Enumeration keyMappingsEnum = this.getPrimaryKeyMappings().elements();
            while (keyMappingsEnum.hasMoreElements()) {
                if (!((DatabaseMapping)keyMappingsEnum.nextElement()).isOneToOneMapping()) continue;
                hasOneToOne = true;
            }
            if (!hasOneToOne) {
                keyMappingsEnum = this.getPrimaryKeyMappings().elements();
                while (keyMappingsEnum.hasMoreElements()) {
                    DatabaseMapping mapping = (DatabaseMapping)keyMappingsEnum.nextElement();
                    if (mapping.isDirectToFieldMapping()) {
                        Object nullValue = ((AbstractDirectMapping)mapping).getAttributeValue(null, policy.getSession());
                        mapping.setAttributeValueInObject(copy, nullValue);
                        continue;
                    }
                    if (!mapping.isTransformationMapping()) continue;
                    mapping.setAttributeValueInObject(copy, null);
                }
            }
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(copy);
            event.setSession(policy.getSession());
            event.setOriginalObject(original);
            event.setEventCode(10);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
        return copy;
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        boolean isNew = ((UnitOfWorkImpl)session).isObjectNew(clone);
        return this.createObjectChangeSet(clone, uowChangeSet, isNew, session);
    }

    public ObjectChangeSet createObjectChangeSet(Object clone, UnitOfWorkChangeSet uowChangeSet, boolean isNew, AbstractSession session) {
        ObjectChangeSet changes = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(clone);
        if (changes == null) {
            changes = this.getDescriptor().isAggregateDescriptor() ? new AggregateObjectChangeSet(new Vector(0), clone, uowChangeSet, isNew) : new ObjectChangeSet(this.extractPrimaryKeyFromObject(clone, session), clone, uowChangeSet, isNew);
            changes.setIsAggregate(this.getDescriptor().isAggregateDescriptor() || this.getDescriptor().isAggregateCollectionDescriptor());
            uowChangeSet.addObjectChangeSetForIdentity(changes, clone);
        }
        return changes;
    }

    public void createPrimaryKeyExpression(AbstractSession session) {
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = (DatabaseField)primaryKeyFields.get(index);
            Expression subExp1 = ((Expression)builder).getField(primaryKeyField);
            Expression subExp2 = builder.getParameter(primaryKeyField);
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
        }
        this.setPrimaryKeyExpression(expression);
    }

    public Vector extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        AbstractSession oldSession = expression.getBuilder().getSession();
        expression.getBuilder().setSession(session);
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.getDescriptor(), primaryKeyRow, translationRow);
        expression.getBuilder().setSession(oldSession);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(primaryKeyRow, session);
    }

    public Vector extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && !domainObject.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return session.getDescriptor(domainObject).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session);
        }
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        Vector<Object> primaryKeyValues = new Vector<Object>(primaryKeyFields.size());
        if (this.getDescriptor().hasSimplePrimaryKey()) {
            for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
                AbstractDirectMapping mapping = (AbstractDirectMapping)this.getPrimaryKeyMappings().get(index);
                Object keyValue = mapping.valueFromObject(domainObject, (DatabaseField)primaryKeyFields.get(index), session);
                primaryKeyValues.add(keyValue);
            }
        } else {
            int index;
            AbstractRecord databaseRow = this.createRecord(this.getPrimaryKeyMappings().size());
            for (index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
                DatabaseMapping mapping = (DatabaseMapping)this.getPrimaryKeyMappings().get(index);
                if (mapping == null) continue;
                mapping.writeFromObjectIntoRow(domainObject, databaseRow, session);
            }
            for (index = 0; index < primaryKeyFields.size(); ++index) {
                Class classification = (Class)this.getPrimaryKeyClassifications().get(index);
                Object value = databaseRow.get((DatabaseField)primaryKeyFields.get(index));
                primaryKeyValues.addElement(session.getPlatform(domainObject.getClass()).convertObject(value, classification));
            }
        }
        return primaryKeyValues;
    }

    public Vector extractPrimaryKeyFromRow(AbstractRecord databaseRow, AbstractSession session) {
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        Vector<Object> primaryKeyValues = new Vector<Object>(primaryKeyFields.size());
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField field = (DatabaseField)primaryKeyFields.get(index);
            Class classification = (Class)this.getPrimaryKeyClassifications().get(index);
            Object value = databaseRow.get(field);
            if (value == null) {
                return null;
            }
            primaryKeyValues.addElement(session.getPlatform(this.getDescriptor().getJavaClass()).convertObject(value, classification));
        }
        return primaryKeyValues;
    }

    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        AbstractSession oldSession = expression.getBuilder().getSession();
        expression.getBuilder().setSession(session);
        boolean isValid = expression.extractPrimaryKeyValues(true, this.getDescriptor(), primaryKeyRow, translationRow);
        expression.getBuilder().setSession(session);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    public AbstractRecord extractPrimaryKeyRowFromObject(Object domainObject, AbstractSession session) {
        AbstractRecord databaseRow = this.createRecord(this.getPrimaryKeyMappings().size());
        for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
            ((DatabaseMapping)this.getPrimaryKeyMappings().get(index)).writeFromObjectIntoRow(domainObject, databaseRow, session);
        }
        if (this.getDescriptor().hasSimplePrimaryKey()) {
            return databaseRow;
        }
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size());
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            Class classification = (Class)this.getPrimaryKeyClassifications().get(index);
            DatabaseField field = (DatabaseField)primaryKeyFields.get(index);
            Object value = databaseRow.get(field);
            primaryKeyRow.put(field, session.getPlatform(domainObject.getClass()).convertObject(value, classification));
        }
        return primaryKeyRow;
    }

    public Object extractValueFromObjectForField(Object domainObject, DatabaseField field, AbstractSession session) throws DescriptorException {
        ClassDescriptor descriptor = null;
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && (descriptor = session.getDescriptor(domainObject)).getJavaClass() != this.getDescriptor().getJavaClass()) {
            return descriptor.getObjectBuilder().extractValueFromObjectForField(domainObject, field, session);
        }
        DatabaseMapping mapping = this.getMappingForField(field);
        if (mapping == null) {
            throw DescriptorException.missingMappingForField(field, this.getDescriptor());
        }
        return mapping.valueFromObject(domainObject, field, session);
    }

    public DatabaseMapping getBaseMappingForField(DatabaseField databaseField) {
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            mapping = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping;
    }

    public Object getBaseValueForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return mapping.getAttributeValueFromObject(valueIntoObject);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) throws DescriptorException {
        DatabaseMapping mapping = this.getMappingForField(fieldToClassify);
        if (mapping == null) {
            return null;
        }
        return mapping.getFieldClassification(fieldToClassify);
    }

    public DatabaseField getFieldForQueryKeyName(String name) {
        QueryKey key = this.getDescriptor().getQueryKeyNamed(name);
        if (key == null) {
            DatabaseMapping mapping = this.getMappingForAttributeName(name);
            if (mapping == null) {
                return null;
            }
            if (mapping.getFields().isEmpty()) {
                return null;
            }
            return (DatabaseField)mapping.getFields().firstElement();
        }
        if (key.isDirectQueryKey()) {
            return ((DirectQueryKey)key).getField();
        }
        return null;
    }

    public List getCloningMappings() {
        return this.cloningMappings;
    }

    public Vector getJoinedAttributes() {
        return this.joinedAttributes;
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null;
    }

    public DatabaseMapping getMappingForAttributeName(String name) {
        return (DatabaseMapping)this.getMappingsByAttribute().get(name);
    }

    public DatabaseMapping getMappingForField(DatabaseField field) {
        return (DatabaseMapping)this.getMappingsByField().get(field);
    }

    public Vector getReadOnlyMappingsForField(DatabaseField field) {
        return (Vector)this.getReadOnlyMappingsByField().get(field);
    }

    protected Map getMappingsByAttribute() {
        return this.mappingsByAttribute;
    }

    public Map getMappingsByField() {
        return this.mappingsByField;
    }

    public Map getReadOnlyMappingsByField() {
        return this.readOnlyMappingsByField;
    }

    protected Vector getNonPrimaryKeyMappings() {
        return this.nonPrimaryKeyMappings;
    }

    public Object getParentObjectForField(DatabaseField databaseField, Object domainObject) {
        Object valueIntoObject = domainObject;
        DatabaseMapping mapping = this.getMappingForField(databaseField);
        while (mapping.isAggregateObjectMapping()) {
            valueIntoObject = mapping.getAttributeValueFromObject(valueIntoObject);
            mapping = ((AggregateMapping)mapping).getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        }
        return valueIntoObject;
    }

    public Vector getPrimaryKeyClassifications() {
        if (this.primaryKeyClassifications == null) {
            List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
            NonSynchronizedVector classifications = NonSynchronizedVector.newInstance(primaryKeyFields.size());
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseMapping mapping = (DatabaseMapping)this.getPrimaryKeyMappings().get(index);
                DatabaseField field = (DatabaseField)primaryKeyFields.get(index);
                if (mapping != null) {
                    ((Vector)classifications).add(Helper.getObjectClass(mapping.getFieldClassification(field)));
                } else {
                    ((Vector)classifications).add(null);
                }
                this.primaryKeyClassifications = classifications;
            }
        }
        return this.primaryKeyClassifications;
    }

    public Expression getPrimaryKeyExpression() {
        return this.primaryKeyExpression;
    }

    public Vector getPrimaryKeyMappings() {
        return this.primaryKeyMappings;
    }

    public DatabaseField getTargetFieldForQueryKeyName(String queryKeyName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(queryKeyName);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)mapping).getField();
        }
        QueryKey queryKey = this.getDescriptor().getQueryKeyNamed(queryKeyName);
        if (queryKey != null && queryKey.isDirectQueryKey()) {
            return ((DirectQueryKey)queryKey).getField();
        }
        return null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        this.getMappingsByField().clear();
        this.getReadOnlyMappingsByField().clear();
        this.getMappingsByAttribute().clear();
        this.getCloningMappings().clear();
        Enumeration mappings = this.getDescriptor().getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
            if (!mapping.isWriteOnly()) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            Enumeration fields = mapping.getFields().elements();
            while (fields.hasMoreElements()) {
                Object field = fields.nextElement();
                if (!mapping.isReadOnly()) {
                    if (this.getMappingsByField().containsKey(field)) {
                        if (mapping.isAggregateObjectMapping()) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(field.toString(), mapping));
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                Vector mappingVector = (Vector)this.getReadOnlyMappingsByField().get(field);
                if (mappingVector == null) {
                    mappingVector = NonSynchronizedVector.newInstance();
                    this.getReadOnlyMappingsByField().put(field, mappingVector);
                }
                mappingVector.add(mapping);
            }
        }
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
    }

    public void initializeJoinedAttributes() {
        NonSynchronizedVector joinedAttributes = null;
        Vector mappings = this.getDescriptor().getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!mapping.isOneToOneMapping() || !mapping.isRelationalMapping() || !((OneToOneMapping)mapping).shouldUseJoining()) continue;
            if (joinedAttributes == null) {
                joinedAttributes = NonSynchronizedVector.newInstance();
            }
            ((Vector)joinedAttributes).add(mapping.getAttributeName());
        }
        this.joinedAttributes = joinedAttributes;
    }

    protected void copyQueryInfoToCacheKey(CacheKey cacheKey, ObjectBuildingQuery query, AbstractRecord databaseRow, AbstractSession session, ClassDescriptor concreteDescriptor) {
        cacheKey.setLastUpdatedQueryId(query.getQueryId());
        if (concreteDescriptor.usesOptimisticLocking()) {
            OptimisticLockingPolicy policy = concreteDescriptor.getOptimisticLockingPolicy();
            Object cacheValue = policy.getValueToPutInCache(databaseRow, session);
            cacheKey.setWriteLockValue(cacheValue);
        }
        cacheKey.setReadTime(query.getExecutionTime());
    }

    public void initializePrimaryKey(AbstractSession session) throws DescriptorException {
        DatabaseMapping mapping;
        this.createPrimaryKeyExpression(session);
        List primaryKeyfields = this.getDescriptor().getPrimaryKeyFields();
        this.getPrimaryKeyMappings().clear();
        this.getNonPrimaryKeyMappings().clear();
        for (DatabaseField field : this.getMappingsByField().keySet()) {
            if (primaryKeyfields.contains(field)) continue;
            DatabaseMapping mapping2 = this.getMappingForField(field);
            if (this.getNonPrimaryKeyMappings().contains(mapping2)) continue;
            this.getNonPrimaryKeyMappings().addElement(mapping2);
        }
        List primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField primaryKeyField = (DatabaseField)primaryKeyFields.get(index);
            mapping = this.getMappingForField(primaryKeyField);
            if (mapping == null && !this.getDescriptor().isAggregateDescriptor() && !this.getDescriptor().isAggregateCollectionDescriptor()) {
                throw DescriptorException.noMappingForPrimaryKey(primaryKeyField, this.getDescriptor());
            }
            this.getPrimaryKeyMappings().addElement(mapping);
            if (mapping != null) {
                mapping.setIsPrimaryKeyMapping(true);
            }
            if (!this.getDescriptor().hasMultipleTables()) continue;
            for (Map keyMaping : this.getDescriptor().getAdditionalTablePrimaryKeyFields().values()) {
                DatabaseField secondaryField = (DatabaseField)keyMaping.get(primaryKeyField);
                if (secondaryField == null || mapping == null) continue;
                this.getMappingsByField().put(secondaryField, mapping);
            }
        }
        boolean hasSimplePrimaryKey = true;
        for (int index = 0; index < this.getPrimaryKeyMappings().size(); ++index) {
            mapping = (DatabaseMapping)this.getPrimaryKeyMappings().get(index);
            if (mapping != null && mapping.isDirectToFieldMapping()) continue;
            hasSimplePrimaryKey = false;
            break;
        }
        this.getDescriptor().setHasSimplePrimaryKey(hasSimplePrimaryKey);
    }

    public Object instantiateClone(Object domainObject, AbstractSession session) {
        return this.getDescriptor().getCopyPolicy().buildClone(domainObject, session);
    }

    public Object instantiateWorkingCopyClone(Object domainObject, AbstractSession session) {
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyClone(domainObject, session);
    }

    public Object instantiateWorkingCopyCloneFromRow(AbstractRecord row, ObjectBuildingQuery query) {
        if (query.isObjectLevelReadQuery()) {
            return this.getDescriptor().getCopyPolicy().buildWorkingCopyCloneFromRow((Record)row, (ObjectLevelReadQuery)query);
        }
        return this.getDescriptor().getCopyPolicy().buildWorkingCopyCloneFromRow((Record)row, query);
    }

    public boolean isPrimaryKeyMapping(DatabaseMapping mapping) {
        return this.getPrimaryKeyMappings().contains(mapping);
    }

    public void iterate(DescriptorIterator iterator) {
        Vector mappings = this.getDescriptor().getMappings();
        int mappingsSize = mappings.size();
        for (int index = 0; index < mappingsSize; ++index) {
            ((DatabaseMapping)mappings.get(index)).iterate(iterator);
        }
    }

    public void mergeChangesIntoObject(Object target, ObjectChangeSet changeSet, Object source, MergeManager mergeManager) {
        Enumeration changes = changeSet.getChanges().elements();
        while (changes.hasMoreElements()) {
            ChangeRecord record = (ChangeRecord)changes.nextElement();
            DatabaseMapping mapping = this.getMappingForAttributeName(record.getAttribute());
            mapping.mergeChangesIntoObject(target, record, source, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setChangeSet(changeSet);
            event.setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public void mergeIntoObject(Object target, boolean isUnInitialized, Object source, MergeManager mergeManager) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).mergeIntoObject(target, isUnInitialized, source, mergeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(target);
            event.setSession(mergeManager.getSession());
            event.setOriginalObject(source);
            event.setEventCode(11);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public void populateAttributesForClone(Object original, Object clone, UnitOfWorkImpl unitOfWork, JoinedAttributeManager joinedAttributeManager) {
        List mappings = this.getCloningMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).buildClone(original, clone, unitOfWork, joinedAttributeManager);
        }
        if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
            DescriptorEvent event = new DescriptorEvent(clone);
            event.setSession(unitOfWork);
            event.setOriginalObject(original);
            event.setEventCode(10);
            this.getDescriptor().getEventManager().executeEvent(event);
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.setMappingsByField(Helper.rehashMap(this.getMappingsByField()));
        this.setReadOnlyMappingsByField(Helper.rehashMap(this.getReadOnlyMappingsByField()));
        this.setPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.setNonPrimaryKeyMappings(NonSynchronizedVector.newInstance(2));
        this.initializePrimaryKey(session);
    }

    public void setDescriptor(ClassDescriptor aDescriptor) {
        this.descriptor = aDescriptor;
    }

    protected void setMappingsByAttribute(Map theAttributeMappings) {
        this.mappingsByAttribute = theAttributeMappings;
    }

    public void setMappingsByField(Map theFieldMappings) {
        this.mappingsByField = theFieldMappings;
    }

    public void setReadOnlyMappingsByField(Map theReadOnlyFieldMappings) {
        this.readOnlyMappingsByField = theReadOnlyFieldMappings;
    }

    protected void setNonPrimaryKeyMappings(Vector theNonPrimaryKeyMappings) {
        this.nonPrimaryKeyMappings = theNonPrimaryKeyMappings;
    }

    protected void setPrimaryKeyClassifications(Vector primaryKeyClassifications) {
        this.primaryKeyClassifications = primaryKeyClassifications;
    }

    public void setPrimaryKeyExpression(Expression criteria) {
        this.primaryKeyExpression = criteria;
    }

    protected void setPrimaryKeyMappings(Vector thePrimaryKeyMappings) {
        this.primaryKeyMappings = thePrimaryKeyMappings;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor().toString() + ")";
    }

    public Object unwrapObject(Object proxy, AbstractSession session) {
        ClassDescriptor descriptor;
        if (proxy == null) {
            return null;
        }
        if (this.getDescriptor().getJavaClass() == proxy.getClass() || !this.getDescriptor().hasWrapperPolicy() || !this.getDescriptor().getWrapperPolicy().isWrapped(proxy)) {
            return proxy;
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasChildren() && (descriptor = session.getDescriptor(proxy)) != this.getDescriptor()) {
            return descriptor.getObjectBuilder().unwrapObject(proxy, session);
        }
        if (this.getDescriptor().hasWrapperPolicy()) {
            return this.getDescriptor().getWrapperPolicy().unwrapObject(proxy, session);
        }
        return proxy;
    }

    public void validate(AbstractSession session) throws DescriptorException {
        if (this.getDescriptor().usesSequenceNumbers() && this.getMappingForField(this.getDescriptor().getSequenceNumberField()) == null) {
            throw DescriptorException.mappingForSequenceNumberField(this.getDescriptor());
        }
    }

    public boolean verifyDelete(Object object, AbstractSession session) {
        AbstractRecord translationRow = this.buildRowForTranslation(object, session);
        if (this.getDescriptor().getQueryManager().getReadObjectQuery() != null && this.getDescriptor().getQueryManager().getReadObjectQuery().isCallQuery()) {
            Object result = session.readObject(object);
            if (result != null) {
                return false;
            }
        } else {
            Enumeration tables = this.getDescriptor().getTables().elements();
            while (tables.hasMoreElements()) {
                DatabaseTable table = (DatabaseTable)tables.nextElement();
                SQLSelectStatement sqlStatement = new SQLSelectStatement();
                sqlStatement.addTable(table);
                if (table == this.getDescriptor().getTables().firstElement()) {
                    sqlStatement.setWhereClause((Expression)this.getPrimaryKeyExpression().clone());
                } else {
                    sqlStatement.setWhereClause(this.buildPrimaryKeyExpression(table));
                }
                DatabaseField all = new DatabaseField("*");
                all.setTable(table);
                sqlStatement.addField(all);
                sqlStatement.normalize(session, null);
                DataReadQuery dataReadQuery = new DataReadQuery();
                dataReadQuery.setSQLStatement(sqlStatement);
                dataReadQuery.setSessionName(this.getDescriptor().getSessionName());
                Vector queryResults = (Vector)session.executeQuery((DatabaseQuery)dataReadQuery, translationRow);
                if (queryResults.isEmpty()) continue;
                return false;
            }
        }
        Enumeration mappings = this.getDescriptor().getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.nextElement();
            if (mapping.verifyDelete(object, session)) continue;
            return false;
        }
        return true;
    }

    public Object wrapObject(Object implementation, AbstractSession session) {
        ClassDescriptor descriptor;
        if (implementation == null) {
            return null;
        }
        if (!this.getDescriptor().hasWrapperPolicy() || this.getDescriptor().getWrapperPolicy().isWrapped(implementation)) {
            return implementation;
        }
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasChildren() && implementation.getClass() != this.getDescriptor().getJavaClass() && (descriptor = session.getDescriptor(implementation)) != this.getDescriptor()) {
            return descriptor.getObjectBuilder().wrapObject(implementation, session);
        }
        if (this.getDescriptor().hasWrapperPolicy()) {
            return this.getDescriptor().getWrapperPolicy().wrapObject(implementation, session);
        }
        return implementation;
    }
}

