/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns;

import java.lang.reflect.AnnotatedElement;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.helper.DatabaseField;

public class MetadataColumn {
    protected String m_attributeName;
    protected DatabaseField m_databaseField;
    protected AnnotatedElement m_annotatedElement;
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 0;
    public static final String DEFAULT_NAME = "";
    public static final String DEFAULT_TABLE = "";
    public static final String DEFAULT_COLUMN_DEFINITION = "";
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_NULLABLE = true;
    public static final boolean DEFAULT_UPDATABLE = true;
    public static final boolean DEFAULT_INSERTABLE = true;

    public MetadataColumn(AttributeOverride attributeOverride, AnnotatedElement annotatedElement) {
        this(attributeOverride.column(), attributeOverride.name(), annotatedElement);
    }

    public MetadataColumn(Column column, MetadataAccessor accessor) {
        this(column, accessor.getAttributeName(), accessor.getAnnotatedElement());
    }

    public MetadataColumn(Column column, String attributeName, AnnotatedElement annotatedElement) {
        this(attributeName, annotatedElement);
        if (column != null) {
            this.m_databaseField.setUnique(column.unique());
            this.m_databaseField.setNullable(column.nullable());
            this.m_databaseField.setUpdatable(column.updatable());
            this.m_databaseField.setInsertable(column.insertable());
            this.m_databaseField.setScale(column.scale());
            this.m_databaseField.setLength(column.length());
            this.m_databaseField.setPrecision(column.precision());
            this.m_databaseField.setName(column.name());
            this.m_databaseField.setTableName(column.table());
            this.m_databaseField.setColumnDefinition(column.columnDefinition());
        }
    }

    public MetadataColumn(String attributeName, AnnotatedElement annotatedElement) {
        this.m_attributeName = attributeName;
        this.m_annotatedElement = annotatedElement;
        this.m_databaseField = new DatabaseField();
        this.m_databaseField.setUnique(false);
        this.m_databaseField.setNullable(true);
        this.m_databaseField.setUpdatable(true);
        this.m_databaseField.setInsertable(true);
        this.m_databaseField.setScale(0);
        this.m_databaseField.setLength(255);
        this.m_databaseField.setPrecision(0);
        this.m_databaseField.setName("");
        this.m_databaseField.setTableName("");
        this.m_databaseField.setColumnDefinition("");
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public DatabaseField getDatabaseField() {
        return this.m_databaseField;
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public boolean loadedFromXML() {
        return false;
    }
}

