/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public class ExpressionSQLPrinter {
    protected AbstractSession session;
    protected SQLCall call;
    protected AbstractRecord translationRow;
    protected boolean shouldPrintQualifiedNames;
    protected Writer writer;
    protected boolean requiresDistinct;
    protected boolean isFirstElementPrinted;

    public ExpressionSQLPrinter(AbstractSession session, AbstractRecord translationRow, SQLCall call, boolean printQualifiedNames) {
        this.session = session;
        this.translationRow = translationRow;
        this.call = call;
        this.shouldPrintQualifiedNames = printQualifiedNames;
        this.requiresDistinct = false;
        this.isFirstElementPrinted = false;
    }

    protected SQLCall getCall() {
        return this.call;
    }

    public DatabasePlatform getPlatform() {
        return this.session.getPlatform();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isFirstElementPrinted() {
        return this.isFirstElementPrinted;
    }

    public void printExpression(Expression expression) {
        this.translateExpression(expression);
    }

    public void printField(DatabaseField field) {
        if (field == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(field.getQualifiedName());
            } else {
                this.getWriter().write(field.getName());
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(ParameterExpression expression) {
        try {
            this.getCall().appendTranslationParameter(this.getWriter(), expression, this.getPlatform());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printParameter(DatabaseField field) {
        this.getCall().appendTranslation(this.getWriter(), field);
    }

    public void printPrimitive(Object value) {
        if (value instanceof Vector) {
            this.printValuelist((Vector)value);
            return;
        }
        this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value);
    }

    public void printString(String value) {
        try {
            this.getWriter().write(value);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void printValuelist(Vector values) {
        try {
            Enumeration valuesEnum = values.elements();
            while (valuesEnum.hasMoreElements()) {
                Object value = valuesEnum.nextElement();
                this.session.getPlatform().appendLiteralToCall(this.getCall(), this.getWriter(), value);
                if (!valuesEnum.hasMoreElements()) continue;
                this.getWriter().write(", ");
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public boolean requiresDistinct() {
        return this.requiresDistinct;
    }

    protected void setCall(SQLCall call) {
        this.call = call;
    }

    public void setIsFirstElementPrinted(boolean isFirstElementPrinted) {
        this.isFirstElementPrinted = isFirstElementPrinted;
    }

    public void setRequiresDistinct(boolean requiresDistinct) {
        this.requiresDistinct = requiresDistinct;
    }

    protected void setSession(AbstractSession theSession) {
        this.session = theSession;
    }

    protected void setShouldPrintQualifiedNames(boolean shouldPrintQualifiedNames) {
        this.shouldPrintQualifiedNames = shouldPrintQualifiedNames;
    }

    protected void setTranslationRow(AbstractRecord theRow) {
        this.translationRow = theRow;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldPrintParameterValues() {
        return this.getTranslationRow() != null;
    }

    protected boolean shouldPrintQualifiedNames() {
        return this.shouldPrintQualifiedNames;
    }

    protected void translateExpression(Expression theExpression) {
        theExpression.printSQL(this);
    }
}

