/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.appserv.management.ext.logging.Logging;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.management.ObjectName;

public class LogAnalyzerHandler {
    private static final String DEMO_INSTANCE_NAME = "@demo@";
    static Map[] map68 = null;
    static Map[] map10 = null;

    private CCActionTableModelInterface getModel(HandlerContext handlerCtx, ViewDescriptor desc) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        if (model == null) {
            throw new FrameworkException("LogAnalyzerHandler.getModel: No Model Specified.", desc, handlerCtx.getView());
        }
        return model;
    }

    private void populateTable(RequestContext ctx, CCActionTableModelInterface model, Map[] attrsMap, Date selectedTimeStamp) throws ModelControlException {
        model.beforeFirst();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ctx.getRequest().getLocale());
        for (int rowNo = 0; rowNo < attrsMap.length; ++rowNo) {
            model.appendRow();
            Map attrs = attrsMap[rowNo];
            Long ms = (Long)attrs.get("TimeStamp");
            model.setValue("timeStamp", (Object)ms);
            String formattedTime = dateFormat.format(new Date(ms));
            model.setValue("timeStampFormatted", (Object)formattedTime);
            Integer severe = (Integer)attrs.get("SevereCount");
            Object obj = severe;
            if (severe < 0) {
                obj = Util.getMessage("common.NA");
            }
            model.setValue("severeCount", obj);
            Integer warning = (Integer)attrs.get("WarningCount");
            obj = warning;
            if (warning < 0) {
                obj = Util.getMessage("common.NA");
            }
            model.setValue("warningCount", obj);
        }
    }

    private void printout(CCActionTableModelInterface model) {
        Object timeS = model.getValue("timeStamp");
        String timeSClassName = timeS.getClass().getName();
        String tformat = (String)model.getValue("timeStampFormatted");
        Integer sc = (Integer)model.getValue("severeCount");
        Integer wc = (Integer)model.getValue("warningCount");
    }

    public void loadLogAnalyzerTable(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            desc = descView.getViewDescriptor();
        }
        Map[] attrsMap = (Map[])handlerCtx.getInputValue("statisticsMap");
        if (attrsMap == null || attrsMap.length == 0) {
            return;
        }
        Date selectedTimeStamp = (Date)handlerCtx.getInputValue("selectedTimeStamp");
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx, desc);
            ((DefaultModel)model).clear();
            model.setRowSelectionType("single");
            this.populateTable(ctx, model, attrsMap, selectedTimeStamp);
        }
        catch (Exception ex) {
            throw new FrameworkException("loadAnalyzerTable: Loading error. ", (Throwable)ex, desc, view);
        }
    }

    public void getStatisticsMap(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        try {
            int count;
            ObjectName currentObjName = new ObjectName(objectName);
            String serverName = currentObjName.getKeyProperty("server");
            int n = count = DEMO_INSTANCE_NAME.equals(serverName) ? 68 : 5;
            if (count == 68) {
                if (map68 == null) {
                    map68 = this.getMap(count);
                }
                handlerCtx.setOutputValue("output", (Object)map68);
            } else if (count == 5) {
                if (map10 == null) {
                    map10 = this.getMap(count);
                }
                handlerCtx.setOutputValue("output", (Object)map10);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private Map[] getMap(int count) {
        Map[] aMap = new HashMap[count];
        Calendar rightNow = Calendar.getInstance();
        rightNow.add(10, -count);
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            rightNow.add(10, 1);
            long tt = rightNow.getTimeInMillis();
            Long tLong = new Long(tt);
            String tkey = "TimeStamp";
            String wKey = "WarningCount";
            String sKey = "SevereCount";
            HashMap<String, Number> hm = new HashMap<String, Number>();
            hm.put(tkey, tLong);
            int xx = Math.abs(random.nextInt() % 30);
            Integer xInt = new Integer(xx);
            hm.put(wKey, xInt);
            int yy = Math.abs(random.nextInt() % 30);
            Integer yInt = new Integer(yy);
            hm.put(sKey, yInt);
            aMap[i] = hm;
        }
        return aMap;
    }

    public void revertArrayMap(RequestContext ctx, HandlerContext handlerCtx) {
        Map[] inMap = (Map[])handlerCtx.getInputValue("inMap");
        HashMap[] outMap = new HashMap[]{};
        if (inMap != null && inMap.length > 0) {
            outMap = new HashMap[inMap.length];
            int i = 0;
            int oix = inMap.length - 1;
            while (i < inMap.length) {
                outMap[oix] = (HashMap)inMap[i];
                ++i;
                --oix;
            }
        }
        handlerCtx.setOutputValue("outMap", (Object)outMap);
    }

    public void convertToTimeStampArray(RequestContext ctx, HandlerContext handlerCtx) {
        Map[] attrsMap = (Map[])handlerCtx.getInputValue("inputMap");
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor desc = descView.getViewDescriptor();
        if (attrsMap == null) {
            throw new FrameworkException("LogAnalyzerHandler.convertToTimeStampArray: No attrsMap specified.", desc, handlerCtx.getView());
        }
        ArrayList<String> timeStampArray = new ArrayList<String>();
        for (int rowNo = 0; rowNo < attrsMap.length; ++rowNo) {
            Map attrs = attrsMap[rowNo];
            Long ms = (Long)attrs.get("TimeStamp");
            timeStampArray.add(ms.toString());
        }
        handlerCtx.setOutputValue("output", timeStampArray);
    }

    public void getSelectedTimeStamp(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor desc = descView.getViewDescriptor();
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        if (model == null) {
            throw new FrameworkException("LogAnalyzerHandler.getSelectedTimeStamp: No Model Specified.", desc, handlerCtx.getView());
        }
        model.setRowSelectionType("single");
        try {
            model.beforeFirst();
            Object timeStamp = null;
            Object fromKey = null;
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                int index = model.getRowIndex();
                timeStamp = model.getValue("timeStamp");
                String classname = timeStamp.getClass().getName();
            }
            if (timeStamp == null) {
                // empty if block
            }
            handlerCtx.setOutputValue("selected", timeStamp);
        }
        catch (Exception ex) {
            throw new FrameworkException("Unable to get Selected TimeStamp:", null, handlerCtx.getView());
        }
    }

    public void setupChart(RequestContext ctx, HandlerContext handlerCtx) {
        int i;
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor desc = descView.getViewDescriptor();
        Map[] data = (Map[])handlerCtx.getInputValue("statisticsMap");
        ArrayList timeStampArray = (ArrayList)handlerCtx.getInputValue("timeStampArray");
        if (data == null) {
            throw new FrameworkException("LogAnalyzerHandler.setupChart: No statisticsMap specified", desc, handlerCtx.getView());
        }
        if (timeStampArray == null) {
            throw new FrameworkException("LogAnalyzerHandler.setupChart: No timeStampArray specified", desc, handlerCtx.getView());
        }
        String selectedTime = (String)handlerCtx.getInputValue("selectedTime");
        boolean showPrevious10 = Boolean.parseBoolean((String)handlerCtx.getInputValue("showPrevious10"));
        boolean showNext10 = Boolean.parseBoolean((String)handlerCtx.getInputValue("showNext10"));
        boolean useStartEnd = Boolean.parseBoolean((String)handlerCtx.getInputValue("useStartEnd"));
        boolean showAll = Boolean.parseBoolean((String)handlerCtx.getInputValue("showAll"));
        String startT = (String)handlerCtx.getInputValue("start");
        String endT = (String)handlerCtx.getInputValue("end");
        int selected = 0;
        boolean showPartial = false;
        if (selectedTime != null || showPrevious10 || showNext10 || useStartEnd) {
            showPartial = true;
        }
        if (!showPartial || showAll) {
            handlerCtx.setOutputValue("disableNext10", (Object)new Boolean("true"));
            handlerCtx.setOutputValue("disablePrevious10", (Object)new Boolean("true"));
            handlerCtx.setOutputValue("disableShowAll", (Object)"true");
            handlerCtx.setOutputValue("output", (Object)data);
            if (timeStampArray.size() < 11) {
                handlerCtx.setOutputValue("disableZoomIn", (Object)"true");
            } else {
                handlerCtx.setOutputValue("disableZoomIn", (Object)"false");
            }
            handlerCtx.setOutputValue("startTime", (Object)((String)timeStampArray.get(0)));
            handlerCtx.setOutputValue("endTime", (Object)((String)timeStampArray.get(timeStampArray.size() - 1)));
            return;
        }
        int start = 0;
        int end = timeStampArray.size() - 1;
        if (useStartEnd && !showPrevious10 && !showNext10) {
            for (i = 0; i < timeStampArray.size(); ++i) {
                if (!((String)timeStampArray.get(i)).equals(startT)) continue;
                start = i;
                break;
            }
            for (i = 0; i < timeStampArray.size(); ++i) {
                if (!((String)timeStampArray.get(i)).equals(endT)) continue;
                end = i;
                break;
            }
        } else {
            if (showPrevious10) {
                selectedTime = (String)handlerCtx.getInputValue("start");
                if (selectedTime == null) {
                    throw new FrameworkException("LogAnalyzerHandler.setupChart: No start specified with showPrevious", desc, handlerCtx.getView());
                }
            } else if (showNext10 && (selectedTime = (String)handlerCtx.getInputValue("end")) == null) {
                throw new FrameworkException("LogAnalyzerHandler.setupChart: No end specified with showNext10", desc, handlerCtx.getView());
            }
            for (i = 0; i < timeStampArray.size(); ++i) {
                if (!((String)timeStampArray.get(i)).equals(selectedTime)) continue;
                selected = i;
                break;
            }
            if (showPrevious10) {
                if (selected - 10 <= 0) {
                    start = 0;
                    end = 9;
                } else {
                    start = selected - 10;
                    end = start + 9;
                }
            } else if (showNext10) {
                start = selected + 1;
                if (start + 9 < end) {
                    end = start + 9;
                }
            } else if (selected - 5 > 0 && selected + 4 < timeStampArray.size() - 1) {
                start = selected - 5;
                end = selected + 4;
            } else if (selected - 5 <= 0) {
                end = start + 9;
            } else {
                start = end - 9;
            }
        }
        int s = start;
        Map[] chartMap = new Map[end - start + 1];
        for (int i2 = 0; i2 < chartMap.length; ++i2) {
            chartMap[i2] = data[s++];
        }
        handlerCtx.setOutputValue("disablePrevious10", (Object)new Boolean(start != 0 ? "false" : "true"));
        handlerCtx.setOutputValue("disableNext10", (Object)new Boolean(end < timeStampArray.size() - 1 ? "false" : "true"));
        handlerCtx.setOutputValue("output", (Object)chartMap);
        handlerCtx.setOutputValue("startTime", (Object)((String)timeStampArray.get(start)));
        handlerCtx.setOutputValue("endTime", (Object)((String)timeStampArray.get(end)));
        handlerCtx.setOutputValue("useStartEnd", (Object)"true");
        handlerCtx.setOutputValue("disableZoomIn", (Object)(timeStampArray.size() < 11 ? "true" : "false"));
        if (chartMap.length < timeStampArray.size()) {
            handlerCtx.setOutputValue("disableShowAll", (Object)"false");
        } else {
            handlerCtx.setOutputValue("disableShowAll", (Object)"true");
        }
    }

    public void getFormatedTime(RequestContext ctx, HandlerContext handlerCtx) {
        String ms = (String)handlerCtx.getInputValue("ms");
        Date useThis = null;
        useThis = ms == null || "".equals(ms) ? new Date(System.currentTimeMillis()) : new Date(Long.parseLong(ms));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ctx.getRequest().getLocale());
        String currentTime = dateFormat.format(useThis);
        handlerCtx.setOutputValue("value", (Object)currentTime);
    }

    public void setupDistribution(RequestContext ctx, HandlerContext handlerCtx) {
        Integer[] counts;
        Integer value;
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor desc = descView.getViewDescriptor();
        Long selectedTime = new Long((String)handlerCtx.getInputValue("selectedTime"));
        String level = "SEVERE";
        if (selectedTime == null) {
            throw new FrameworkException("LogAnalyzerHandler.setupDistribution: No selectedTime specified", desc, handlerCtx.getView());
        }
        String serverName = (String)handlerCtx.getInputValue("instanceName");
        Map warningMap = null;
        Map severeMap = null;
        if (serverName.equals(DEMO_INSTANCE_NAME)) {
            warningMap = this.getDistributionSampleData("" + Level.WARNING);
            severeMap = this.getDistributionSampleData("" + Level.SEVERE);
        } else {
            Map amp = AMXUtil.getMonitoringRoot().getServerRootMonitorMap();
            ServerRootMonitor srm = (ServerRootMonitor)amp.get(serverName);
            Logging la = srm.getLogging();
            warningMap = la.getErrorDistribution(selectedTime.longValue(), "" + Level.WARNING);
            severeMap = la.getErrorDistribution(selectedTime.longValue(), "" + Level.SEVERE);
        }
        HashMap combinedMap = new HashMap();
        for (Object key : severeMap.keySet()) {
            value = (Integer)severeMap.get(key);
            counts = new Integer[]{value, null};
            combinedMap.put(key, counts);
        }
        for (Object key : warningMap.keySet()) {
            value = (Integer)warningMap.get(key);
            counts = (Integer[])combinedMap.get(key);
            if (counts == null) {
                Integer[] vv = new Integer[]{null, value};
                combinedMap.put(key, vv);
                continue;
            }
            counts[1] = value;
        }
        handlerCtx.setOutputValue("combinedMap", combinedMap);
    }

    private Map getDistributionSampleData(String level) {
        HashMap<String, Integer> dMap = new HashMap<String, Integer>();
        Random random = new Random();
        if (level.equals("SEVERE")) {
            dMap.put("javax.enterprise.system.container.web", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.resource.corba.S1AS-ORB.rpc.transport", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.core.transaction", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.tools.admin", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.container.ejb", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("org.apache.catalina.startup.ContextConfig", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.core", new Integer(Math.abs(random.nextInt() % 100)));
        } else {
            dMap.put("org.apache.catalina.core.StandardEngine", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.container.web", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.resource.corba.S1AS-ORB.rpc.transport", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.core.transaction", new Integer(Math.abs(random.nextInt() % 100)));
            dMap.put("javax.enterprise.system.tools.admin", new Integer(Math.abs(random.nextInt() % 100)));
        }
        return dMap;
    }

    public void loadDistributionTable(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            desc = descView.getViewDescriptor();
        }
        Map combinedMap = (Map)handlerCtx.getInputValue("combinedMap");
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx, desc);
            ((DefaultModel)model).clear();
            model.beforeFirst();
            Iterator iters = combinedMap.keySet().iterator();
            while (iters.hasNext()) {
                model.appendRow();
                Object key = iters.next();
                Integer[] value = (Integer[])combinedMap.get(key);
                model.setValue("moduleId", key);
                if (value[0] != null) {
                    model.setValue("severeCount", (Object)value[0]);
                }
                if (value[1] == null) continue;
                model.setValue("warningCount", (Object)value[1]);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("loadAnalyzerTable: Loading error. ", (Throwable)ex, desc, view);
        }
    }
}

