/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCOption;
import com.sun.web.ui.view.html.CCOptionGroup;
import com.sun.web.ui.view.html.CCOptionSeparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementRulesHandler {
    static final String PROPERTY_NOTIFICATION_TYPE = "type";

    public void loadManagementRulesTable(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String eventObjectName = (String)handlerCtx.getInputValue("eventObjectName");
        try {
            model.setRowSelectionType("multiple");
            model.beforeFirst();
            ObjectName[] rules = (ObjectName[])MBeanUtil.invoke(objectName, methodName, null, null);
            for (int i = 0; i < rules.length; ++i) {
                model.appendRow();
                String ruleName = rules[i].getKeyProperty("name");
                model.setValue("name", (Object)ruleName);
                model.setValue("ruleObjectName", (Object)rules[i]);
                String enabled = (String)MBeanUtil.getAttribute(rules[i], "enabled");
                model.setValue("status", (Object)("true".equals(enabled) ? Util.getMessage("common.Enabled") : Util.getMessage("common.Disabled")));
                String eventType = (String)MBeanUtil.getAttribute(eventObjectName + ruleName, PROPERTY_NOTIFICATION_TYPE);
                model.setValue("eventType", (Object)eventType);
            }
        }
        catch (Exception ex) {
            Util.logFINE(ex);
        }
    }

    public void managementRulesDelete(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String deleteMethod = (String)handlerCtx.getInputValue("deleteMethod");
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                boolean selected = model.isRowSelected();
                if (!selected) continue;
                String ruleObjectName = (String)model.getValue("ruleObjectName");
                ObjectName objN = new ObjectName(ruleObjectName);
                Object[] params = new String[]{objN.getKeyProperty("name")};
                String[] types = new String[]{"java.lang.String"};
                MBeanUtil.invoke(objectName, deleteMethod, params, types);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FrameworkException("Unable to  delete Management Rule:", (Throwable)ex);
        }
    }

    public void managementRulesChangeStatus(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String enabled = (String)handlerCtx.getInputValue("enabled");
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                boolean selected = model.isRowSelected();
                if (!selected) continue;
                String ruleObjectName = (String)model.getValue("ruleObjectName");
                MBeanUtil.setAttribute(ruleObjectName, new Attribute("enabled", enabled));
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FrameworkException("Unable to set enable status ", (Throwable)ex);
        }
    }

    public void populateEventTypes(RequestContext ctx, HandlerContext handlerCtx) {
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getView();
        OptionList optionList = new OptionList();
        optionList.add("", "");
        optionList.add("monitor", "monitor");
        optionList.add((Option)new CCOptionSeparator());
        optionList.add("notification", "notification");
        optionList.add((Option)new CCOptionSeparator());
        CCOptionGroup og = new CCOptionGroup(Util.getMessage("managementRules.systemEvent"), "---");
        og.add(new CCOption("lifecycle", "lifecycle"));
        og.add(new CCOption("log", "log"));
        og.add(new CCOption("timer", "timer"));
        og.add(new CCOption("trace", "trace"));
        Boolean isEE = ConfigProperties.getInstance().getTargetSupported();
        if (isEE.booleanValue()) {
            og.add(new CCOption("cluster", "cluster"));
        }
        og.add(new CCOption("  ", ""));
        optionList.add((Option)og);
        dropDownChild.setOptions(optionList);
    }

    public void populateActions(RequestContext ctx, HandlerContext handlerCtx) {
        String[] types;
        Object[] params;
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getView();
        String objectName = (String)handlerCtx.getInputValue("objectName");
        List actionBeansList = (List)MBeanUtil.invoke(objectName, "getAllActionMBeans", params = new Object[]{Boolean.FALSE}, types = new String[]{"boolean"});
        if (actionBeansList == null) {
            return;
        }
        OptionList optionList = new OptionList();
        optionList.add("         ", "");
        for (String actionBeans : actionBeansList) {
            optionList.add(actionBeans, actionBeans);
        }
        dropDownChild.setOptions(optionList);
        String initialValue = (String)handlerCtx.getInputValue("initialValue");
        if (initialValue != null && initialValue.length() != 0 && dropDownChild.getValue() == null) {
            dropDownChild.setValue((Object)initialValue);
        }
    }

    public void populateLogLevels(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "log", "level");
    }

    public void populateLogger(RequestContext ctx, HandlerContext handlerCtx) {
        Object[] eachRow;
        this.populateDropDownEventProperties(handlerCtx, "log", "loggernames");
        List eventProperties = (List)handlerCtx.getInputValue("eventProperties");
        if (eventProperties == null || eventProperties.size() < 1) {
            return;
        }
        String loggers = null;
        for (Attribute attr : eventProperties) {
            if (!"loggernames".equals(attr.getName())) continue;
            loggers = (String)attr.getValue();
            break;
        }
        if (loggers != null && (eachRow = loggers.split(",")) != null & eachRow.length > 0) {
            SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getView();
            dropDownChild.setValues(eachRow);
        }
    }

    public void populateLifeCycleNames(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "lifecycle", "name");
    }

    public void populateTraceNames(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "trace", "name");
    }

    public void getEditPage(RequestContext ctx, HandlerContext handlerCtx) {
        String ruleObjectName = (String)handlerCtx.getInputValue("ruleObjectName");
        ObjectName eventObjectName = (ObjectName)MBeanUtil.invoke(ruleObjectName, "getEvent", null, null);
        String eventType = (String)MBeanUtil.getAttribute(eventObjectName, PROPERTY_NOTIFICATION_TYPE);
        String editPage = null;
        if ("timer".equals(eventType)) {
            editPage = "managementRuleTimerEdit";
        } else if ("monitor".equals(eventType)) {
            String type = (String)MBeanUtil.invoke(eventObjectName, "getPropertyValue", new Object[]{"monitortype"}, new String[]{"java.lang.String"});
            editPage = "countermonitor".equals(type) ? "managementRuleMonitorCountEdit" : ("stringmonitor".equals(type) ? "managementRuleMonitorStringEdit" : "managementRuleMonitorGaugeEdit");
        } else if ("cluster".equals(eventType)) {
            editPage = "managementRuleClusterEdit";
        } else if (eventType.equals("log")) {
            editPage = "managementRuleLogEdit";
        } else if (eventType.equals("notification")) {
            editPage = "managementRuleNotificationEdit";
        } else if (eventType.equals("trace")) {
            editPage = "managementRuleTraceEdit";
        } else if ("lifecycle".equals(eventType)) {
            editPage = "managementRuleLifeCycleEdit";
        }
        handlerCtx.setOutputValue("editPage", (Object)editPage);
    }

    public void getNextCreationPage(RequestContext ctx, HandlerContext handlerCtx) {
        String out = "";
        String eventSelected = (String)handlerCtx.getInputValue("eventType");
        if ("timer".equals(eventSelected)) {
            out = "managementRuleTimer";
        } else if ("monitor".equals(eventSelected)) {
            out = "managementRuleMonitor";
        } else if ("cluster".equals(eventSelected)) {
            out = "managementRuleCluster";
        } else if ("log".equals(eventSelected)) {
            out = "managementRuleLog";
        } else if ("notification".equals(eventSelected)) {
            out = "managementRuleNotification";
        } else if ("trace".equals(eventSelected)) {
            out = "managementRuleTrace";
        } else if ("lifecycle".equals(eventSelected)) {
            out = "managementRuleLifeCycle";
        } else {
            throw new FrameworkException("Cannot determine the next step of New Management Rule. EventType not recognized");
        }
        handlerCtx.setOutputValue("nextPage", (Object)out);
    }

    public void createManagementRule(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        HttpSession session = RequestManager.getSession();
        String step1ModelName = (String)handlerCtx.getInputValue("step1Model");
        String step2ModelName = (String)handlerCtx.getInputValue("step2Model");
        DefaultModel step1Model = (DefaultModel)session.getValue(step1ModelName);
        DefaultModel step2Model = (DefaultModel)session.getValue(step2ModelName);
        String ruleName = (String)step1Model.getValue("Name");
        Boolean ruleEnabled = new Boolean((String)step1Model.getValue("enabled"));
        String ruleDesc = (String)step1Model.getValue("ruleDesc");
        String eventType = (String)step1Model.getValue("eventType");
        String eventLevel = (String)step1Model.getValue("eventLogLevel");
        Boolean eventRecordEvent = new Boolean((String)step1Model.getValue("recordEvent"));
        String eventDesc = (String)step2Model.getValue("eventDesc");
        String actionMbean = (String)step2Model.getValue("actions");
        if (Util.isEmpty(actionMbean)) {
            actionMbean = null;
        }
        Properties eventProps = null;
        if ("timer".equals(eventType)) {
            eventProps = this.getTimerProperties(step2Model);
        } else if ("monitor".equals(eventType)) {
            eventProps = this.getMonitorProperties(step2Model);
        } else if ("cluster".equals(eventType)) {
            eventProps = this.getClusterProperties(step2Model);
        } else if ("log".equals(eventType)) {
            eventProps = this.getLogProperties(step2Model);
        } else if ("notification".equals(eventType)) {
            eventProps = this.getNotificationProperties(step2Model);
        } else if ("trace".equals(eventType)) {
            eventProps = this.getTraceProperties(step2Model);
        } else if ("lifecycle".equals(eventType)) {
            eventProps = this.getLifeCycleProperties(step2Model);
        }
        Object[] params = new Object[]{ruleName, ruleEnabled, ruleDesc, eventType, eventLevel, eventRecordEvent, eventDesc, eventProps, actionMbean};
        String[] types = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.util.Properties", "java.lang.String"};
        MBeanUtil.invoke(objectName, "createManagementRule", params, types);
    }

    private void setProp(Properties props, String name, String value) {
        if (!Util.isEmpty(value)) {
            props.setProperty(name, value);
        }
    }

    private Properties getLogProperties(DefaultModel model) {
        Object[] loggers = model.getValues("logger");
        String allLogger = "";
        if (loggers != null) {
            int len = loggers.length;
            for (int count = 0; count < len; ++count) {
                String val = (String)loggers[count];
                if (val == null || val.toString().trim().length() == 0) continue;
                allLogger = allLogger + "," + val;
            }
        }
        String logLevel = (String)model.getValue("logLevel");
        Properties props = new Properties();
        this.setProp(props, "loggernames", allLogger);
        this.setProp(props, "level", logLevel);
        return props;
    }

    private Properties getClusterProperties(DefaultModel model) {
        String clusterEventName = (String)model.getValue("clusterEventName");
        String clusterEventServerName = (String)model.getValue("clusterEventServerName");
        Properties props = new Properties();
        this.setProp(props, "name", clusterEventName);
        this.setProp(props, "servername", clusterEventServerName);
        return props;
    }

    private Properties getNotificationProperties(DefaultModel model) {
        Properties props = new Properties();
        String selected = (String)model.getValue("sourceRB");
        if ("predefinedMBean".equals(selected)) {
            String sourceMbean = (String)model.getValue("sourceMbean");
            this.setProp(props, "sourcembean", sourceMbean);
        } else {
            String sourceObjectName = (String)model.getValue("sourceObjectName");
            this.setProp(props, "sourceobjectname", sourceObjectName);
        }
        String type = (String)model.getValue("notificationType");
        this.setProp(props, PROPERTY_NOTIFICATION_TYPE, type);
        return props;
    }

    private Properties getLifeCycleProperties(DefaultModel model) {
        String lifeCycleName = (String)model.getValue("lifeCycleName");
        Properties props = new Properties();
        this.setProp(props, "name", lifeCycleName);
        return props;
    }

    private Properties getTraceProperties(DefaultModel model) {
        Properties props = new Properties();
        this.setProp(props, "name", (String)model.getValue("traceName"));
        return props;
    }

    private Properties getTimerProperties(DefaultModel model) {
        Properties props = new Properties();
        this.setProp(props, "datestring", (String)model.getValue("dateString"));
        this.setProp(props, "pattern", (String)model.getValue("pattern"));
        this.setProp(props, "period", (String)model.getValue("period"));
        this.setProp(props, "numberofoccurrences", (String)model.getValue("occurrence"));
        this.setProp(props, "message", (String)model.getValue("message"));
        this.setProp(props, "pattern", (String)model.getValue("pattern"));
        return props;
    }

    private Properties getMonitorProperties(DefaultModel model) {
        Properties props = new Properties();
        this.setProp(props, "observedobject", (String)model.getValue("observedObject"));
        this.setProp(props, "observedattribute", (String)model.getValue("observedAttr"));
        this.setProp(props, "granularityperiod", (String)model.getValue("period"));
        String monitorType = (String)model.getValue("monitorType");
        this.setProp(props, "monitortype", monitorType);
        if ("gaugemonitor".equals(monitorType)) {
            this.setProp(props, "numbertype", (String)model.getValue("gaugeNumberType"));
            this.setProp(props, "differencemode", (String)model.getValue("gaugeDiff"));
            this.setProp(props, "highthreshold", (String)model.getValue("gaugeHighThreshold"));
            this.setProp(props, "lowthreshold", (String)model.getValue("gaugeLowThreshold"));
        } else if ("countermonitor".equals(monitorType)) {
            this.setProp(props, "numbertype", (String)model.getValue("countNumberType"));
            this.setProp(props, "differencemode", (String)model.getValue("countDiff"));
            this.setProp(props, "initthreshold", (String)model.getValue("initThreshold"));
            this.setProp(props, "offset", (String)model.getValue("offset"));
            this.setProp(props, "modulus", (String)model.getValue("modulus"));
        } else if ("stringmonitor".equals(monitorType)) {
            String compare = (String)model.getValue("compare");
            if ("notifymatch".equals(compare)) {
                this.setProp(props, "stringnotify", "notifymatch");
            } else {
                this.setProp(props, "stringnotify", "notifydiffer");
            }
            this.setProp(props, "stringtocompare", (String)model.getValue("strValue"));
        }
        return props;
    }

    public void getCommonAttributesForRules(RequestContext ctx, HandlerContext handlerCtx) {
        String actionMbeanName;
        String ruleObjectName = (String)handlerCtx.getInputValue("ruleObjectName");
        String eventObjectName = (String)handlerCtx.getInputValue("eventObjectName");
        handlerCtx.setOutputValue("ruleEnabled", (Object)((String)MBeanUtil.getAttribute(ruleObjectName, "enabled")));
        handlerCtx.setOutputValue("ruleDesc", (Object)((String)MBeanUtil.getAttribute(ruleObjectName, "description")));
        String eventType = (String)MBeanUtil.getAttribute(eventObjectName, PROPERTY_NOTIFICATION_TYPE);
        handlerCtx.setOutputValue("eventType", (Object)eventType);
        handlerCtx.setOutputValue("recordEvent", (Object)((String)MBeanUtil.getAttribute(eventObjectName, "record-event")));
        handlerCtx.setOutputValue("eventLogLevel", (Object)((String)MBeanUtil.getAttribute(eventObjectName, "level")));
        handlerCtx.setOutputValue("eventDesc", (Object)((String)MBeanUtil.getAttribute(eventObjectName, "description")));
        ObjectName actionObjectName = this.getActionObjectName(ruleObjectName);
        if (actionObjectName != null && !Util.isEmpty(actionMbeanName = (String)MBeanUtil.getAttribute(actionObjectName, "action-mbean-name"))) {
            handlerCtx.setOutputValue("action", (Object)actionMbeanName);
        }
        AttributeList attrs = (AttributeList)MBeanUtil.invoke(eventObjectName, "getProperties", null, null);
        if ("notification".equals(eventType)) {
            this.setupNotificationProperties(attrs);
        }
        handlerCtx.setOutputValue("eventProperties", (Object)attrs);
    }

    private void setupNotificationProperties(List<Attribute> attrs) {
        boolean mbean = false;
        for (Attribute attr : attrs) {
            String name = attr.getName();
            String value = (String)attr.getValue();
            if (!"sourcembean".equals(name)) continue;
            mbean = true;
            break;
        }
        if (mbean) {
            attrs.add(new Attribute("sourceRB", "predefinedMBean"));
        } else {
            attrs.add(new Attribute("sourceRB", "userdefinedObjName"));
        }
    }

    public void getEventPropertyList(RequestContext ctx, HandlerContext handlerCtx) {
        String eventObjectName = (String)handlerCtx.getInputValue("eventObjectName");
        String eventType = (String)MBeanUtil.getAttribute(eventObjectName, PROPERTY_NOTIFICATION_TYPE);
        ArrayList<String> list = new ArrayList<String>();
        if ("log".equals(eventType)) {
            list.add("level");
        } else if ("lifecycle".equals(eventType)) {
            list.add("name");
        } else if ("trace".equals(eventType)) {
            list.add("name");
        } else if ("cluster".equals(eventType)) {
            list.add("name");
            list.add("servername");
        } else if ("timer".equals(eventType)) {
            list.add("datestring");
            list.add("pattern");
            list.add("period");
            list.add("numberofoccurrences");
            list.add("message");
        } else if ("notification".equals(eventType)) {
            list.add("sourceRB");
            list.add("sourcembean");
            list.add("sourceobjectname");
            list.add(PROPERTY_NOTIFICATION_TYPE);
        } else if ("monitor".equals(eventType)) {
            list.add("observedobject");
            list.add("observedattribute");
            list.add("granularityperiod");
            String type = (String)MBeanUtil.invoke(eventObjectName, "getPropertyValue", new Object[]{"monitortype"}, new String[]{"java.lang.String"});
            if ("countermonitor".equals(type)) {
                list.add("differencemode");
                list.add("numbertype");
                list.add("initthreshold");
                list.add("offset");
                list.add("modulus");
            } else if ("stringmonitor".equals(type)) {
                list.add("stringnotify");
                list.add("stringtocompare");
            } else if ("gaugemonitor".equals(type)) {
                list.add("differencemode");
                list.add("numbertype");
                list.add("lowthreshold");
                list.add("highthreshold");
            }
        }
        handlerCtx.setOutputValue("propertyNameList", list);
    }

    public void getTranslatedMonitorType(RequestContext ctx, HandlerContext handlerCtx) {
        String eventObjectName = (String)handlerCtx.getInputValue("eventObjectName");
        String type = (String)MBeanUtil.invoke(eventObjectName, "getPropertyValue", new Object[]{"monitortype"}, new String[]{"java.lang.String"});
        handlerCtx.setOutputValue("mtype", (Object)this.translatedMonitorType(type));
    }

    private String translatedMonitorType(String type) {
        String mtype = null;
        if ("countermonitor".equals(type)) {
            mtype = Util.getMessage("managementRule.Count");
        } else if ("stringmonitor".equals(type)) {
            mtype = Util.getMessage("managementRule.String");
        } else if ("gaugemonitor".equals(type)) {
            mtype = Util.getMessage("managementRule.Gauge");
        }
        return mtype;
    }

    public void changeAction(RequestContext ctx, HandlerContext handlerCtx) {
        String ruleObjectName = (String)handlerCtx.getInputValue("ruleObjectName");
        String actionMbeanName = (String)handlerCtx.getInputValue("actionMbeanName");
        ObjectName actionObjectName = this.getActionObjectName(ruleObjectName);
        if (Util.isEmpty(actionMbeanName)) {
            if (actionObjectName != null) {
                MBeanUtil.invoke(ruleObjectName, "removeAction", null, null);
            }
            return;
        }
        if (actionObjectName != null) {
            String origActionMbeanName = (String)MBeanUtil.getAttribute(actionObjectName, "action-mbean-name");
            if (!actionMbeanName.equals(origActionMbeanName)) {
                MBeanUtil.invoke(ruleObjectName, "removeAction", null, null);
            } else {
                return;
            }
        }
        AttributeList attrs = new AttributeList();
        attrs.add(new Attribute("action-mbean-name", actionMbeanName));
        Object[] params = new Object[]{attrs};
        String[] types = new String[]{"javax.management.AttributeList"};
        MBeanUtil.invoke(ruleObjectName, "createAction", params, types);
    }

    public void setLogEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        Object[] loggers = (Object[])handlerCtx.getInputValue("logger");
        String logLevel = (String)handlerCtx.getInputValue("logLevel");
        String allLogger = null;
        if (loggers != null) {
            int len = loggers.length;
            for (int count = 0; count < len; ++count) {
                String val = (String)loggers[count];
                if (val == null || val.toString().trim().length() == 0) continue;
                allLogger = allLogger == null ? val : allLogger + "," + val;
            }
        }
        this.setPropertyWithValue(objectName, "loggernames", allLogger);
        this.setPropertyWithValue(objectName, "level", logLevel);
    }

    public void setLifeCycleEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String lifeCycleName = (String)handlerCtx.getInputValue("lifeCycleName");
        this.setPropertyWithValue(objectName, "name", lifeCycleName);
    }

    public void setTraceEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String traceName = (String)handlerCtx.getInputValue("traceName");
        this.setPropertyWithValue(objectName, "name", traceName);
    }

    public void setClusterEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String clusterEventName = (String)handlerCtx.getInputValue("clusterEventName");
        String clusterEventServerName = (String)handlerCtx.getInputValue("clusterEventServerName");
        this.setPropertyWithValue(objectName, "name", clusterEventName);
        this.setPropertyWithValue(objectName, "servername", clusterEventServerName);
    }

    public void setTimerEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        this.setPropertyWithValue(objectName, "datestring", (String)handlerCtx.getInputValue("dateString"));
        this.setPropertyWithValue(objectName, "pattern", (String)handlerCtx.getInputValue("pattern"));
        this.setPropertyWithValue(objectName, "period", (String)handlerCtx.getInputValue("period"));
        this.setPropertyWithValue(objectName, "numberofoccurrences", (String)handlerCtx.getInputValue("occurrence"));
        this.setPropertyWithValue(objectName, "message", (String)handlerCtx.getInputValue("message"));
    }

    public void setMonitorEventGaugeProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        this.setPropertyWithValue(objectName, "granularityperiod", (String)handlerCtx.getInputValue("period"));
        this.setPropertyWithValue(objectName, "numbertype", (String)handlerCtx.getInputValue("gaugeNumberType"));
        this.setPropertyWithValue(objectName, "differencemode", (String)handlerCtx.getInputValue("gaugeDiff"));
        this.setPropertyWithValue(objectName, "lowthreshold", (String)handlerCtx.getInputValue("gaugeLowThreshold"));
        this.setPropertyWithValue(objectName, "highthreshold", (String)handlerCtx.getInputValue("gaugeHighThreshold"));
    }

    public void setMonitorEventCountProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        this.setPropertyWithValue(objectName, "granularityperiod", (String)handlerCtx.getInputValue("period"));
        this.setPropertyWithValue(objectName, "numbertype", (String)handlerCtx.getInputValue("countNumberType"));
        this.setPropertyWithValue(objectName, "differencemode", (String)handlerCtx.getInputValue("countDiff"));
        this.setPropertyWithValue(objectName, "initthreshold", (String)handlerCtx.getInputValue("initThreshold"));
        this.setPropertyWithValue(objectName, "offset", (String)handlerCtx.getInputValue("offset"));
        this.setPropertyWithValue(objectName, "modulus", (String)handlerCtx.getInputValue("modulus"));
    }

    public void setMonitorEventStringProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        this.setPropertyWithValue(objectName, "granularityperiod", (String)handlerCtx.getInputValue("period"));
        this.setPropertyWithValue(objectName, "stringnotify", (String)handlerCtx.getInputValue("compare"));
        this.setPropertyWithValue(objectName, "stringtocompare", (String)handlerCtx.getInputValue("strValue"));
    }

    public void setNotificationEventProperties(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String sourceRB = (String)handlerCtx.getInputValue("sourceRB");
        if ("predefinedMBean".equals(sourceRB)) {
            this.setPropertyWithValue(objectName, "sourcembean", (String)handlerCtx.getInputValue("sourceMbean"));
        } else {
            this.setPropertyWithValue(objectName, "sourceobjectname", (String)handlerCtx.getInputValue("sourceObjectName"));
        }
        this.setPropertyWithValue(objectName, PROPERTY_NOTIFICATION_TYPE, (String)handlerCtx.getInputValue("notificationType"));
    }

    private void setPropertyWithValue(String objectName, String name, String value) {
        Object[] params = new Object[]{new Attribute(name, value)};
        String[] types = new String[]{"javax.management.Attribute"};
        String origValue = "";
        try {
            Object[] pp = new Object[]{name};
            String[] tt = new String[]{"java.lang.String"};
            origValue = (String)MBeanUtil.invoke(objectName, "getPropertyValue", pp, tt);
            if (origValue == null) {
                origValue = "";
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!(Util.isEmpty(value) && Util.isEmpty(origValue) || origValue.equals(value))) {
            MBeanUtil.invoke(objectName, "setProperty", params, types);
        }
    }

    public void populateClusterEventName(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "cluster", "name");
    }

    public void populateClusterEventServerName(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "cluster", "servername");
    }

    private ObjectName getActionObjectName(String ruleObjectName) {
        try {
            ObjectName actionObjectName = (ObjectName)MBeanUtil.invoke(ruleObjectName, "getAction", null, null);
            return actionObjectName;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void populateMonitorType(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "monitor", "monitortype");
    }

    public void populateGaugeNumberType(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "monitor", "numbertype");
    }

    public void populateNotificationSourceMbean(RequestContext ctx, HandlerContext handlerCtx) {
        this.populateDropDownEventProperties(handlerCtx, "notification", "sourcembean");
    }

    private void populateDropDownEventProperties(HandlerContext handlerCtx, String eventType, String propertyName) {
        String[] types;
        Object[] params;
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getView();
        String initialValue = (String)handlerCtx.getInputValue("initialValue");
        String rulesObjectName = (String)handlerCtx.getInputValue("rulesObjectName");
        List list = (List)MBeanUtil.invoke(rulesObjectName, "getEventPropertyValues", params = new Object[]{eventType, propertyName}, types = new String[]{"java.lang.String", "java.lang.String"});
        if (list == null) {
            return;
        }
        TreeSet tset = new TreeSet(list);
        OptionList optionList = new OptionList();
        if (propertyName.equals("loggernames") || propertyName.equals("servername")) {
            optionList.add("*", "*");
        }
        if (propertyName.equals("sourcembean") && tset.size() < 1) {
            optionList.add("  ", "");
        }
        for (String event : tset) {
            if (Util.isEmpty(event)) continue;
            if ("monitortype".equals(propertyName)) {
                optionList.add(this.translatedMonitorType(event), event);
                continue;
            }
            optionList.add(event, event);
        }
        dropDownChild.setOptions(optionList);
        if (dropDownChild.getValue() == null && !Util.isEmpty(initialValue)) {
            dropDownChild.setValue((Object)initialValue);
        }
    }
}

