/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class JarExtract {
    public static void extract(String fileName, String dir) throws IOException {
        ZipEntry e;
        if (fileName == null || dir == null) {
            throw new IOException("extract method: dir, or fileName is null");
        }
        File f = new File(fileName);
        if (!f.exists()) {
            throw new IOException(fileName + ": file not found");
        }
        FileInputStream fin = new FileInputStream(f);
        JarInputStream jin = new JarInputStream(fin);
        while ((e = jin.getNextEntry()) != null) {
            JarExtract.extract(jin, e, dir);
        }
    }

    private static void extract(JarInputStream jin, ZipEntry e, String dir) throws IOException {
        File f = new File(dir + File.separatorChar + e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (!f.exists() && !f.mkdirs() || !f.isDirectory()) {
                throw new IOException(f + ": could not create directory");
            }
        } else {
            int len;
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException(d + ": could not create directory");
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = jin.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            jin.closeEntry();
            ((OutputStream)os).close();
        }
    }
}

