/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.SecurityMapCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class CreateSecurityMapCommand
extends SecurityMapCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation failed");
        }
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        Object map = null;
        String[] principals = null;
        String[] usergroups = null;
        AttributeList list = null;
        list = (AttributeList)params[0];
        if (list != null) {
            int s = list.size();
            int i = 0;
            for (i = 0; i < s; ++i) {
                Attribute attribute = (Attribute)list.get(i);
                if (attribute.getName().equalsIgnoreCase("principal")) {
                    String principal = (String)attribute.getValue();
                    principals = this.getListOfValues(principal);
                    list.set(i, new Attribute("principal", principals));
                }
                if (!attribute.getName().equalsIgnoreCase("user_group")) continue;
                String usergroup = (String)attribute.getValue();
                usergroups = this.getListOfValues(usergroup);
                list.set(i, new Attribute("user_group", usergroups));
            }
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            ObjectName object = (ObjectName)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private String[] getListOfValues(String sOptions) {
        StringTokenizer optionTokenizer = new StringTokenizer(sOptions, ",");
        int size = optionTokenizer.countTokens();
        String[] sOptionsList = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            sOptionsList[ii] = optionTokenizer.nextToken();
        }
        return sOptionsList;
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
}

