/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import java.io.Serializable;
import java.util.ArrayList;

public class RuntimeStatusList
extends ArrayList
implements Serializable {
    public RuntimeStatusList() {
    }

    public RuntimeStatusList(int capacity) {
        super(capacity);
    }

    public RuntimeStatus getStatus(int index) throws IndexOutOfBoundsException {
        return (RuntimeStatus)super.get(index);
    }

    public boolean anyRunning() {
        return this.numRunning() > 0;
    }

    public boolean allRunning() {
        if (this.isEmpty()) {
            return false;
        }
        return this.numRunning() == this.size();
    }

    public int numRunning() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!((RuntimeStatus)this.get(i)).isRunning()) continue;
            ++count;
        }
        return count;
    }

    public int numNeedingRestart() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!((RuntimeStatus)this.get(i)).isRunning() || !((RuntimeStatus)this.get(i)).isRestartNeeded()) continue;
            ++count;
        }
        return count;
    }

    public int numStopped() {
        return this.size() - this.numRunning();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        if (this.allRunning()) {
            return Status.getStatusString(0);
        }
        if (this.anyRunning()) {
            return Status.getStatusString(6);
        }
        return Status.getStatusString(3);
    }
}

