/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.Frame;
import com.sun.enterprise.config.serverbeans.validation.FrameHolder;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Framer
extends DefaultHandler {
    private Stack frameStack = new Stack();
    protected FrameHolder frameHolder = new FrameHolder();
    public static final String CLUSTER = "cluster";
    public static final String CONFIG = "config";
    public static final String CONFIG_REF = "config-ref";
    public static final String NAME = "name";
    public static final String NAMESPACE = "";
    public static final String SERVER = "server";
    public static final String SERVER_REF = "server-ref";
    public static final String SYSTEM_PROPERTY = "system-property";
    public static final String VALUE = "value";

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isSystemPropertyElement(localName)) {
            this.handleSystemPropertyEvent(atts);
        } else if (this.isConfigEvent(localName)) {
            this.handleStartConfigEvent(atts);
        } else if (this.isServerEvent(localName)) {
            this.handleStartServerEvent(atts);
        } else if (this.isClusterEvent(localName)) {
            this.handleStartClusterEvent(atts);
        } else if (this.isServerRefEvent(localName)) {
            this.handleStartServerRefEvent(atts);
        }
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.isConfigEvent(localName) || this.isServerEvent(localName) || this.isClusterEvent(localName)) {
            this.frameStack.pop();
        }
        super.endElement(namespaceURI, localName, qName);
    }

    private boolean isClusterEvent(String n) {
        return n.equals(CLUSTER);
    }

    private boolean isConfigEvent(String n) {
        return n.equals(CONFIG);
    }

    private boolean isServerEvent(String n) {
        return n.equals(SERVER);
    }

    private boolean isServerRefEvent(String n) {
        return n.equals(SERVER_REF);
    }

    private boolean isSystemPropertyElement(String n) {
        return n.equals(SYSTEM_PROPERTY);
    }

    private void handleStartClusterEvent(Attributes atts) {
        this.frameStack.push(this.getClusterFrame(atts));
    }

    private void handleStartConfigEvent(Attributes atts) {
        this.frameStack.push(this.getConfigFrame(atts));
    }

    private void handleStartServerEvent(Attributes atts) {
        this.frameStack.push(this.getServerFrame(atts));
    }

    protected void handleStartServerRefEvent(Attributes atts) {
    }

    private void handleSystemPropertyEvent(Attributes atts) {
        this.currentFrame().put(atts.getValue(NAMESPACE, NAME), atts.getValue(NAMESPACE, VALUE));
    }

    protected Frame getClusterFrame(Attributes atts) {
        return this.frameHolder.getClusterFrame(this.getFrameName(atts));
    }

    protected Frame getConfigFrame(Attributes atts) {
        return this.frameHolder.getConfigFrame(this.getFrameName(atts));
    }

    protected Frame getServerFrame(Attributes atts) {
        return this.frameHolder.getServerFrame(this.getFrameName(atts));
    }

    private String getFrameName(Attributes atts) {
        return atts.getValue(NAMESPACE, NAME);
    }

    Framer() {
        this(new FrameHolder());
    }

    Framer(FrameHolder fh) {
        this.frameHolder = fh;
        this.frameStack.push(fh.getDomainFrame());
    }

    FrameHolder getFrameHolder() {
        return this.frameHolder;
    }

    Frame currentFrame() {
        return (Frame)this.frameStack.peek();
    }
}

