/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdminObjectResourceConfigFactory
extends ResourceFactoryImplBase {
    public AdminObjectResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi_name");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.getOldResourcesMBean().createAdminObjectResource(translatedAttrs);
    }

    public ObjectName create(String jndiName, String resType, String resAdapter, Map<String, String> reserved) {
        String[] requiredParams = new String[]{"ResType", resType, "ResAdapter", resAdapter};
        Map<String, String> params = this.initParams(jndiName, requiredParams, reserved);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        Set<ResourceRefConfig> refs = this.findAllRefConfigs("X-AdminObjectResourceConfig", name);
        if (refs.size() == 0) {
            this.getOldResourcesMBean().removeAdminObjectResourceByJndiName(name);
        } else {
            for (ResourceRefConfig ref : refs) {
                String target = ref.getContainer().getName();
                this.getOldResourcesMBean().deleteAdminObjectResource(name, target);
            }
        }
    }
}

