/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.enterprise.management.support.LBBaseMBeanRegistrationListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class LoadBalancerServerRefRegistrationListener
extends LBBaseMBeanRegistrationListener {
    public LoadBalancerServerRefRegistrationListener(MBeanServer mBeanServer) throws InstanceNotFoundException, IOException {
        super(mBeanServer);
    }

    protected void mbeanRegistered(ObjectName objectName) {
        try {
            if ("X-ServerRefConfig".equals(Util.getJ2EEType(objectName))) {
                ServerRefConfig serverRefConfig = ProxyFactory.getInstance(this.getConn()).getProxy(objectName, ServerRefConfig.class);
                String serverName = serverRefConfig.getRef();
                Container container = serverRefConfig.getContainer();
                HashMap<String, ServerConfig> serverConfigMap = new HashMap<String, ServerConfig>();
                if (container instanceof LBConfig) {
                    Map<String, StandaloneServerConfig> sserverConfigMap = this.getDomainConfig().getStandaloneServerConfigMap();
                    for (String key : sserverConfigMap.keySet()) {
                        serverConfigMap.put(key, sserverConfigMap.get(key));
                    }
                    List<LoadBalancerMonitor> loadBalancerMonitorList = this.fetchLBMonitoringRoots((LBConfig)container);
                    for (LoadBalancerMonitor lbm : loadBalancerMonitorList) {
                        LoadBalancerClusterMonitor lbcm = this.registerLoadBalancerClusterMonitor(lbm, serverName);
                        this.registerLoadBalancerServerMonitorTree(lbcm, serverConfigMap, serverName);
                    }
                } else if (container instanceof ClusterConfig) {
                    Map<String, ClusteredServerConfig> cserverConfigMap = this.getDomainConfig().getClusteredServerConfigMap();
                    for (String key : cserverConfigMap.keySet()) {
                        serverConfigMap.put(key, cserverConfigMap.get(key));
                    }
                    Collection<LBConfig> affectedLBConfigArr = this.fetchLBConfigs(((ClusterConfig)container).getName(), true);
                    for (LBConfig lbConfig : affectedLBConfigArr) {
                        List<LoadBalancerMonitor> monitoringRoots = this.fetchLBMonitoringRoots(lbConfig);
                        List<LoadBalancerClusterMonitor> clusterMonitors = this.fetchLoadBalancerClusterMonitors(monitoringRoots, ((ClusterConfig)container).getName());
                        for (LoadBalancerClusterMonitor lbcm : clusterMonitors) {
                            this.registerLoadBalancerServerMonitorTree(lbcm, serverConfigMap, serverName);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logWarning("LoadBalancerServerRefRegistrationListener mbeanRegistered failed. Exception = ", ex);
        }
    }
}

