/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.enterprise.management.support.LoaderRegHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoaderRegThread
extends Thread {
    private boolean mQuit;
    private List<ObjectName> mRegistrationQueue;
    private List<ObjectName> mUnregistrationQueue;
    private final Logger mLogger;
    private final LoaderRegHandler mRegHandler;

    public LoaderRegThread(LoaderRegHandler regHandler, Logger logger) {
        this.mRegHandler = regHandler;
        this.mLogger = logger;
        this.mQuit = false;
        this.mRegistrationQueue = Collections.synchronizedList(new ArrayList());
        this.mUnregistrationQueue = Collections.synchronizedList(new ArrayList());
    }

    private final Logger getLogger() {
        return this.mLogger;
    }

    private final void trace(Object o) {
        if (this.mLogger != null) {
            this.mLogger.finer(o.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.mQuit = true;
        LoaderRegThread loaderRegThread = this;
        synchronized (loaderRegThread) {
            this.notify();
        }
    }

    public void enqueue(boolean register, List candidates) {
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            this.enqueue(register, (ObjectName)iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(boolean register, ObjectName theObject) {
        List<ObjectName> theQueue = register ? this.mRegistrationQueue : this.mUnregistrationQueue;
        theQueue.add(theObject);
        LoaderRegThread loaderRegThread = this;
        synchronized (loaderRegThread) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectName dequeue(List<ObjectName> theQueue) {
        ObjectName theObject = null;
        List<ObjectName> list = theQueue;
        synchronized (list) {
            if (theQueue.size() != 0) {
                theObject = theQueue.remove(0);
            }
        }
        return theObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int INTERVAL = 0x40000000;
        this.mQuit = false;
        this.trace("Loader.RegThread.run(): start");
        while (!this.mQuit) {
            try {
                this.trace("Loader.RegThread.run(): waiting");
                LoaderRegThread loaderRegThread = this;
                synchronized (loaderRegThread) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.trace("Loader.RegThread.run(): interrupted from wait");
            }
            if (this.mQuit) break;
            this.processRegistrations();
            this.processUnregistrations();
        }
    }

    private void mySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitEmpty() {
        int queueSize = 0;
        while ((queueSize = this.mRegistrationQueue.size()) != 0) {
            this.mySleep(100L);
        }
        this.trace("RegThread.waitEmpty: queue is empty");
    }

    public int getRegistrationQueueSize() {
        return this.mRegistrationQueue.size();
    }

    public synchronized void processRegistration(ObjectName objectName) {
        try {
            this.mRegHandler.handleMBeanRegistered(objectName);
            this.getLogger().finer("LoaderRegThread.processRegistration: processed mbean: " + objectName);
        }
        catch (Throwable t) {
            this.getLogger().warning("LoaderRegThread.processRegistration: registration of MBean failed for: " + objectName + " = " + t.toString() + ", " + t.getMessage() + "\n" + ExceptionUtil.getStackTrace(t));
        }
    }

    public synchronized void processUnregistration(ObjectName objectName) {
        try {
            this.mRegHandler.handleMBeanUnregistered(objectName);
        }
        catch (Throwable t) {
            this.getLogger().warning("LoaderRegThread.processUnregistration: unregistration of MBean failed for: " + objectName + " = " + t.toString());
        }
    }

    private void processRegistrations() {
        ObjectName objectName = null;
        int numDone = 0;
        while ((objectName = this.dequeue(this.mRegistrationQueue)) != null) {
            this.processRegistration(objectName);
            ++numDone;
        }
        this.getLogger().fine("LoaderRegThread: processed mbeans: " + numDone);
    }

    private void processUnregistrations() {
        ObjectName objectName = null;
        while ((objectName = this.dequeue(this.mUnregistrationQueue)) != null) {
            this.processUnregistration(objectName);
        }
    }
}

