/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.NotificationListenerBase;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;

public abstract class MBeanRegistrationListener
extends NotificationListenerBase {
    private final ObjectName mRegUnregFilter;
    private final String mDefaultDomain;

    public MBeanRegistrationListener(MBeanServerConnection conn, ObjectName constrain) throws InstanceNotFoundException, IOException {
        super(conn, JMXUtil.getMBeanServerDelegateObjectName());
        this.mRegUnregFilter = constrain;
        this.mDefaultDomain = conn.getDefaultDomain();
    }

    public MBeanRegistrationListener(MBeanServerConnection conn) throws InstanceNotFoundException, IOException {
        this(conn, null);
    }

    protected abstract void mbeanRegistered(ObjectName var1);

    protected abstract void mbeanUnregistered(ObjectName var1);

    public void handleNotification(Notification notifIn, Object handback) {
        boolean matchesFilter;
        if (!(notifIn instanceof MBeanServerNotification)) {
            throw new IllegalArgumentException(notifIn.toString());
        }
        MBeanServerNotification notif = (MBeanServerNotification)notifIn;
        ObjectName objectName = notif.getMBeanName();
        String type = notif.getType();
        boolean bl = matchesFilter = this.mRegUnregFilter == null || JMXUtil.matchesPattern(this.mDefaultDomain, this.mRegUnregFilter, objectName);
        if (matchesFilter) {
            if (type.equals("JMX.mbean.registered")) {
                this.mbeanRegistered(objectName);
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.mbeanUnregistered(objectName);
            }
        }
    }
}

