/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.event.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewManager;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import java.util.Iterator;
import java.util.List;

public class ViewHandlers {
    public static final String VALUE = "value";
    public static final String VIEW = "view";
    public static final String VIEW_ID = "viewID";
    public static final String LEAF_VIEW = "leafView";

    public void getView(RequestContext reqCtx, HandlerContext handlerCtx) {
        Object viewID = handlerCtx.getInputValue(VIEW_ID);
        if (viewID == null) {
            throw new FrameworkException("The parameter map did not contain viewID!");
        }
        ViewBeanManager vm = reqCtx.getViewBeanManager();
        ViewBean view = null;
        String topName = viewID instanceof List ? ((List)viewID).get(0).toString() : viewID.toString();
        try {
            view = vm.getViewBean(topName);
        }
        catch (ClassCastException ex) {
            view = ((DescriptorViewManager)vm).getView(null, topName);
        }
        catch (ClassNotFoundException ex) {
            throw new FrameworkException(ex);
        }
        if (view == null) {
            throw new FrameworkException("Unable to obtain the view for mapping!");
        }
        if (viewID instanceof List) {
            Iterator iter = ((List)viewID).iterator();
            iter.next();
            while (iter.hasNext()) {
                if (!(view instanceof ContainerView)) {
                    throw new FrameworkException("View (" + view.getQualifiedName() + ") is not a ContainerView!", null, (View)view);
                }
                view = ((ContainerView)view).getChild("" + iter.next());
            }
        }
        handlerCtx.setOutputValue(VALUE, view);
    }

    public void getQualifiedName(RequestContext reqCtx, HandlerContext handlerCtx) {
        String leaf;
        View view = (View)handlerCtx.getOutputValue(VIEW);
        if (view == null) {
            this.getView(reqCtx, handlerCtx);
            view = (View)handlerCtx.getOutputValue(VALUE);
        }
        if ((leaf = (String)handlerCtx.getInputValue(LEAF_VIEW)) != null) {
            view = ((ContainerView)view).getChild(leaf);
        }
        handlerCtx.setOutputValue(VALUE, view.getQualifiedName());
    }
}

