/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.util;

import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManagerBase;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManager
extends StringManagerBase {
    private static Logger _logger = LogUtils.getLogger();
    private ResourceBundle _resourceBundle = null;
    private static final String RES_BUNDLE_NM = ".LocalStrings";
    private static Hashtable managers = new Hashtable();

    private StringManager(String packageName) {
        super(packageName + RES_BUNDLE_NM);
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager mgr = (StringManager)managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName);
            try {
                managers.put(packageName, mgr);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iplanet_util.error_while_caching", e);
            }
        }
        return mgr;
    }

    public static synchronized StringManager getManager(Class callerClass) {
        try {
            Package pkg = callerClass.getPackage();
            if (pkg != null) {
                String pkgName = pkg.getName();
                return StringManager.getManager(pkgName);
            }
            String pkgName = callerClass.getName();
            return StringManager.getManager(pkgName);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iplanet_util.error_in_getMgr", e);
            return StringManager.getManager("");
        }
    }
}

