/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.util;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.StringManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public class MethodExecutor
implements Serializable {
    private static Logger _logger = LogUtils.getLogger();
    private boolean debug = false;
    private static StringManager sm = StringManager.getManager(GenericJMSRA.class);

    public static void runJavaBeanMethod(String name, String value, Method method, Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == 2) {
                Object[] values = new Object[]{MethodExecutor.convertType(parameters[0], name), MethodExecutor.convertType(parameters[1], value)};
                method.invoke(obj, values);
            }
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", iae);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ie);
            String msg = sm.getString("me.illegal_args", method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ite);
            String msg = sm.getString("me.inv_denied", method.getName());
            throw new ResourceException(msg);
        }
    }

    public static void runJavaBeanMethod(String value, Method method, Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == 1) {
                Object[] values = new Object[]{MethodExecutor.convertType(parameters[0], value)};
                method.invoke(obj, values);
            }
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", iae);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ie);
            String msg = sm.getString("me.illegal_args", method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ite);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
    }

    public static void runMethod(Method method, Object obj, Vector values) throws ResourceException {
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (values.size() != parameters.length) {
                return;
            }
            Object[] actualValues = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String val = (String)values.get(i);
                actualValues[i] = val.trim().equals("NULL") ? null : MethodExecutor.convertType(parameters[i], val);
            }
            method.invoke(obj, actualValues);
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", iae);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ie);
            String msg = sm.getString("me.illegal_args", method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", ite);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
    }

    private static Object convertType(Class type, String parameter) throws ResourceException {
        try {
            String typeName = type.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return new Integer(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return new Short(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return new Byte(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return new Long(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return new Float(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return new Double(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return new Boolean(parameter);
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_nfe", parameter);
            String msg = sm.getString("me.invalid_param", parameter);
            throw new ResourceException(msg);
        }
    }
}

