/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ViewHandlerResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");
    private ByteArrayServletOutputStream basos;
    private PrintWriter pw;
    private CharArrayWriter caw;
    private int status = 200;

    public ViewHandlerResponseWrapper(HttpServletResponse wrapped) {
        super(wrapped);
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.status = sc;
    }

    public void sendError(int sc) throws IOException {
        super.sendError(sc);
        this.status = sc;
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.status = sc;
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        this.status = sc;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isBytes() {
        return null != this.basos;
    }

    public boolean isChars() {
        return null != this.caw;
    }

    public byte[] getBytes() {
        byte[] result = null;
        if (null != this.basos) {
            result = this.basos.toByteArray();
        }
        return result;
    }

    public char[] getChars() {
        char[] result = null;
        if (null != this.caw) {
            result = this.caw.toCharArray();
        }
        return result;
    }

    public String toString() {
        String result = null;
        if (null != this.caw) {
            result = this.caw.toString();
        } else if (null != this.basos) {
            result = ((Object)((Object)this.basos)).toString();
        }
        return result;
    }

    public void flushContentToWrappedResponse() throws IOException {
        ServletResponse wrapped = this.getResponse();
        if (null != this.caw) {
            this.pw.flush();
            this.caw.writeTo(wrapped.getWriter());
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.writeTo(wrapped.getWriter(), wrapped.getCharacterEncoding());
            this.basos.resetByteArray();
        }
    }

    public void flushToWriter(Writer writer, String encoding) throws IOException {
        if (null != this.caw) {
            this.pw.flush();
            this.caw.writeTo(writer);
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.writeTo(writer, encoding);
            this.basos.resetByteArray();
        }
        writer.flush();
    }

    public void clearWrappedResponse() throws IOException {
        if (null != this.caw) {
            this.caw.reset();
        } else if (null != this.basos) {
            this.basos.resetByteArray();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.pw != null) {
            throw new IllegalStateException();
        }
        if (null == this.basos) {
            this.basos = new ByteArrayServletOutputStream();
        }
        return this.basos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.basos != null) {
            throw new IllegalStateException();
        }
        if (null == this.pw) {
            this.caw = new CharArrayWriter(1024);
            this.pw = new PrintWriter(this.caw);
        }
        return this.pw;
    }

    private static class DirectByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DirectByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }

    static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private DirectByteArrayOutputStream baos = new DirectByteArrayOutputStream(1024);

        public void write(int n) {
            this.baos.write(n);
        }

        public void resetByteArray() {
            this.baos.reset();
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }

        public void writeTo(Writer writer, String encoding) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Converting buffered ServletOutputStream bytes to chars using " + encoding);
            }
            ByteBuffer bBuff = this.baos.getByteBuffer();
            CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
            try {
                CharBuffer cBuff = decoder.decode(bBuff);
                writer.write(cBuff.array());
            }
            catch (CharacterCodingException cce) {
                throw new FacesException((Throwable)cce);
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
    }
}

