/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class CommandLinkRenderer
extends LinkRenderer {
    private static final String SCRIPT_STATE = "com.sun.faces.scriptState";

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        UICommand command = (UICommand)component;
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = command.getClientId(context);
        if (!context.getExternalContext().getRequestParameterMap().containsKey(clientId)) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  ActionEvent queued " + actionEvent);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End decoding component " + component.getId());
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String formClientId;
        UICommand command;
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!(command = (UICommand)component).isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        boolean componentDisabled = false;
        if (Boolean.TRUE.equals(command.getAttributes().get("disabled"))) {
            componentDisabled = true;
        }
        if ((formClientId = this.getFormClientId(component, context)) == null && logger.isLoggable(Level.WARNING)) {
            logger.warning("component '" + component.getId() + "' must be enclosed inside a form ");
        }
        if (componentDisabled || formClientId == null) {
            this.renderAsDisabled(context, (UIComponent)command);
        } else {
            if (!CommandLinkRenderer.hasScriptBeenRendered(context)) {
                RenderKitUtils.renderFormInitScript(context.getResponseWriter(), context);
                CommandLinkRenderer.setScriptAsRendered(context);
            }
            this.renderAsActive(context, (UIComponent)command);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding children " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        for (UIComponent kid : component.getChildren()) {
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding children " + component.getId());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        UICommand command = (UICommand)component;
        if (!command.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String formClientId = this.getFormClientId(component, context);
        if (formClientId == null) {
            writer.write(MessageUtils.getExceptionMessageString("com.sun.faces.COMMAND_LINK_NO_FORM_MESSAGE", new Object[0]));
            writer.endElement("span");
            return;
        }
        boolean componentDisabled = false;
        if (Boolean.TRUE.equals(command.getAttributes().get("disabled"))) {
            componentDisabled = true;
        }
        if (componentDisabled) {
            writer.endElement("span");
            return;
        }
        writer.endElement("a");
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Object getValue(UIComponent component) {
        return ((UICommand)component).getValue();
    }

    protected String getOnClickScript(String formClientId, String commandClientId, String target, HtmlBasicRenderer.Param[] params) {
        return RenderKitUtils.getCommandLinkOnClickScript(formClientId, commandClientId, target, params);
    }

    protected void renderAsActive(FacesContext context, UIComponent command) throws IOException {
        boolean userSpecifiedOnclick;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String formClientId = this.getFormClientId(command, context);
        if (formClientId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("component " + command.getId() + " must be enclosed inside a form ");
            }
            return;
        }
        writer.startElement("a", command);
        this.writeIdAttributeIfNecessary(context, writer, command);
        writer.writeAttribute("href", (Object)"#", "href");
        RenderKitUtils.renderPassThruAttributes(context, writer, command, new String[]{"target", "onclick"});
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, command);
        String userOnclick = (String)command.getAttributes().get("onclick");
        StringBuffer sb = new StringBuffer(128);
        boolean bl = userSpecifiedOnclick = userOnclick != null && !"".equals(userOnclick);
        if (userSpecifiedOnclick) {
            sb.append("var a=function(){");
            userOnclick = userOnclick.trim();
            sb.append(userOnclick);
            if (userOnclick.charAt(userOnclick.length() - 1) != ';') {
                sb.append(';');
            }
            sb.append("};var b=function(){");
        }
        HtmlBasicRenderer.Param[] params = this.getParamList(command);
        String commandClientId = command.getClientId(context);
        String target = (String)command.getAttributes().get("target");
        target = target != null ? target.trim() : "";
        sb.append(this.getOnClickScript(formClientId, commandClientId, target, params));
        if (userSpecifiedOnclick) {
            sb.append("};return (a()==false) ? false : b();");
        }
        writer.writeAttribute("onclick", (Object)sb.toString(), "onclick");
        this.writeCommonLinkAttributes(writer, command);
        this.writeValue(command, writer);
        writer.flush();
    }

    private static boolean hasScriptBeenRendered(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(SCRIPT_STATE) != null;
    }

    private static void setScriptAsRendered(FacesContext context) {
        context.getExternalContext().getRequestMap().put(SCRIPT_STATE, Boolean.TRUE);
    }

    private String getFormClientId(UIComponent component, FacesContext context) {
        UIForm form = this.getMyForm(component);
        if (form != null) {
            return form.getClientId(context);
        }
        return null;
    }

    private UIForm getMyForm(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (null == parent && logger.isLoggable(Level.WARNING)) {
            logger.warning("component " + component.getId() + " must be enclosed inside a form ");
        }
        return (UIForm)parent;
    }
}

