/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.database.DatabaseConstants;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;

public abstract class BaseProcessor
implements DatabaseConstants {
    protected static final Logger logger = LogHelperEJBCompiler.getLogger();
    protected static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.ejb.ejbc.Bundle", BaseProcessor.class.getClassLoader());
    protected Application application;
    protected DeploymentEventInfo info;
    protected DeploymentRequest request;
    protected DeploymentStatus status;
    protected boolean deploy;
    protected boolean redeploy;
    protected String cliCreateTables;
    protected String cliDropAndCreateTables;
    protected String cliDropTables;
    protected String appRegisteredName;
    protected String appDeployedLocation;
    protected String appGeneratedLocation;
    protected String createJdbcFileName;
    protected String dropJdbcFileName;
    protected boolean debug = logger.isLoggable(500);

    public BaseProcessor(DeploymentEventInfo info, boolean deploy, boolean redeploy, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        this.initializeVariables(info, deploy, redeploy, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    private void initializeVariables(DeploymentEventInfo info, boolean deploy, boolean redeploy, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        this.info = info;
        this.application = this.info.getApplicationDescriptor();
        this.appRegisteredName = this.application.getRegistrationName();
        this.status = this.info.getDeploymentRequest().getCurrentDeploymentStatus();
        this.deploy = deploy;
        this.redeploy = redeploy;
        this.cliCreateTables = cliCreateTables;
        this.cliDropAndCreateTables = cliDropAndCreateTables;
        this.cliDropTables = cliDropTables;
    }

    protected abstract void processApplication();

    protected File getCreateDDLFile(String createJdbcFileName) {
        File createFile = null;
        try {
            createFile = new File(createJdbcFileName);
            if (!createFile.exists()) {
                this.logI18NWarnMessage("ejb.BaseProcessor.cannotcreatetables", this.appRegisteredName, createFile.getName(), null);
            }
            if (this.debug) {
                logger.fine("ejb.BaseProcessor.createfilename", createFile.getName());
            }
        }
        catch (Exception e) {
            this.logI18NWarnMessage("Exception caught in BaseProcessor.getCreateDDLFile()", this.appRegisteredName, null, e);
        }
        return createFile;
    }

    protected File getDropDDLFile(String dropJdbcFileName, boolean deploy) {
        File dropFile = null;
        try {
            File dir;
            File file = dir = deploy ? this.info.getOldStubsDir() : this.info.getStubsDir();
            if (dir == null) {
                dir = this.info.getStubsDir();
            }
            if (null != dropJdbcFileName) {
                dropFile = new File(dir, dropJdbcFileName);
            }
            if (!dropFile.exists()) {
                this.logI18NWarnMessage("ejb.BaseProcessor.cannotdroptables", this.appRegisteredName, dropFile.getName(), null);
            }
            if (this.debug) {
                logger.fine("ejb.BaseProcessor.dropfilename", dropFile.getName());
            }
        }
        catch (Exception e) {
            this.logI18NWarnMessage("Exception caught in BaseProcessor.getDropDDLFile()", this.appRegisteredName, null, e);
        }
        return dropFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDDLs(File f, Statement sql) throws IOException {
        BufferedReader reader = null;
        StringBuffer warningBuf = new StringBuffer();
        try {
            String s;
            reader = new BufferedReader(new FileReader(f));
            while ((s = reader.readLine()) != null) {
                try {
                    if (this.debug) {
                        logger.fine("ejb.BaseProcessor.executestatement", s);
                    }
                    sql.execute(s);
                }
                catch (SQLException ex) {
                    String msg = this.getI18NMessage("ejb.BaseProcessor.sqlexception", s, null, ex);
                    logger.warning(msg);
                    warningBuf.append("\n\t").append(msg);
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
            if (warningBuf.length() > 0) {
                String warning = this.getI18NMessage("ejb.BaseProcessor.tablewarning");
                this.warnUser(warning + warningBuf.toString());
            }
        }
    }

    protected void warnUser(String msg) {
        this.status.setStageStatus(1);
        this.status.setStageStatusMessage(this.status.getStageStatusMessage() + "\n" + msg);
    }

    protected void cannotConnect(String connName, Throwable ex) {
        this.logI18NWarnMessage("ejb.BaseProcessor.cannotConnect", connName, null, ex);
    }

    protected void fileIOError(String regName, Throwable ex) {
        this.logI18NWarnMessage("ejb.BaseProcessor.ioexception", regName, null, ex);
    }

    protected static void closeConn(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void logI18NInfoMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = this.getI18NMessage(errorCode, regName, fileName, ex);
        logger.info(msg);
    }

    protected void logI18NWarnMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = this.getI18NMessage(errorCode, regName, fileName, ex);
        logger.warning(msg);
        this.warnUser(msg);
    }

    protected String getI18NMessage(String errorCode) {
        return this.getI18NMessage(errorCode, null, null, null);
    }

    protected String getI18NMessage(String errorCode, String regName, String fileName, Throwable ex) {
        String msg = null;
        msg = null != ex ? I18NHelper.getMessage(messages, errorCode, regName, ex.toString()) : (null != fileName ? I18NHelper.getMessage(messages, errorCode, regName, fileName) : I18NHelper.getMessage(messages, errorCode));
        return msg;
    }

    protected void setApplicationLocation() {
        if (null != this.appDeployedLocation) {
            return;
        }
        this.appDeployedLocation = this.info.getDeploymentRequest().getDeployedDirectory().getAbsolutePath() + File.separator;
    }

    protected void setGeneratedLocation() {
        if (null != this.appGeneratedLocation) {
            return;
        }
        this.appGeneratedLocation = this.info.getStubsDir().getAbsolutePath() + File.separator;
    }
}

