/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

public class WeakHashSet
extends HashSet {
    ReferenceQueue queue = new ReferenceQueue();

    public Iterator iterator() {
        this.processQueue();
        final Iterator i = super.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return i.hasNext();
            }

            public Object next() {
                return WeakHashSet.this.getReferenceObject((WeakReference)i.next());
            }

            public void remove() {
                i.remove();
            }
        };
    }

    public boolean contains(Object o) {
        return super.contains(WeakElement.create(o));
    }

    public boolean add(Object o) {
        this.processQueue();
        return super.add(WeakElement.create(o, this.queue));
    }

    public boolean remove(Object o) {
        boolean ret = super.remove(WeakElement.create(o));
        this.processQueue();
        return ret;
    }

    private final Object getReferenceObject(WeakReference ref) {
        return ref != null ? ref.get() : null;
    }

    private final void processQueue() {
        WeakElement wv = null;
        while ((wv = (WeakElement)this.queue.poll()) != null) {
            super.remove(wv);
        }
    }

    private static class WeakElement
    extends WeakReference {
        private int hash;

        private WeakElement(Object o) {
            super(o);
            this.hash = o.hashCode();
        }

        private WeakElement(Object o, ReferenceQueue q) {
            super(o, q);
            this.hash = o.hashCode();
        }

        private static WeakElement create(Object o) {
            return o == null ? null : new WeakElement(o);
        }

        private static WeakElement create(Object o, ReferenceQueue q) {
            return o == null ? null : new WeakElement(o, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeakElement)) {
                return false;
            }
            Object t = this.get();
            Object u = ((WeakElement)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

