/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.Log;
import com.iplanet.jato.MultipartContent;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class MultipartFormServletFilter
implements Filter {
    private static final String DASH = "-";
    private static final String SEMICOLON = ";";
    private static final String TWO_DASHES = "--";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String FILENAME_ATTRIBUTE = "filename";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String BLANK = "";
    private static final String ASSIGNMENT = "=";
    private static final String CONTENT_TYPE_HEADER_PREFIX = "Content-Type:";
    private static final int CONTENT_TYPE_HEADER_PREFIX_LEN;
    private static final String MULTIPART_CONTENT_TYPE_HEADER_PREFIX = "multipart/form-data;";
    private static final int MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN;
    private static final String MULTIPART_CONTENT_TYPE_BOUNDARY_DEF = "boundary=";
    private static final int MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN;
    private static final String MULTIPART_CONTENT_DISPOSITION_PREFIX = "Content-Disposition: form-data;";
    private static final int MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN;
    public static final String TEMP_FILE_PREFIX = "jato";
    public static final String TEMP_FILE_SUFFIX;
    public static final String TEMP_FILE_DIRECTORY_INIT_PARAMETER = "tempFileDirectory";
    public static final String USE_TEMP_FILES_INIT_PARAMETER = "useTempFiles";
    public static final String AUTO_DELETE_TEMP_FILES_INIT_PARAMETER = "autoDeleteTempFiles";
    public static final String FILE_SIZE_LIMIT_INIT_PARAMETER = "fileSizeLimit";
    public static final String FILE_SIZE_HARD_LIMIT_INIT_PARAMETER = "fileSizeHardLimit";
    public static final String REQUEST_SIZE_LIMIT_INIT_PARAMETER = "requestSizeLimit";
    public static final String FAILURE_REDIRECT_URL_INIT_PARAMETER = "failureRedirectURL";
    public static final String DEFAULT_CHARACTER_ENCODING_INIT_PARAMETER = "defaultCharacterEncoding";
    public static final String USE_REQUEST_CHARACTER_ENCODING_INIT_PARAMETER = "useRequestCharacterEncoding";
    public static final String CHARACTER_ENCODING_OVERRIDE_ATTRIBUTE_NAME = "com.iplanet.jato.MultipartFormServletFilter.characterEncodingOverride";
    public static final int DEFAULT_FILE_SIZE_LIMIT = 0x100000;
    public static final int DEFAULT_FILE_SIZE_HARD_LIMIT = 0x200000;
    public static final int DEFAULT_REQUEST_SIZE_LIMIT = 0x400000;
    public static final String DEFAULT_CHARACTER_ENCODING_VALUE;
    public static final boolean DEFAULT_USE_REQUEST_CHARACTER_ENCODING_FLAG = false;
    private int fileSizeLimit = 0x100000;
    private int fileSizeHardLimit = 0x200000;
    private int requestSizeLimit = 0x400000;
    private boolean useTempFiles = true;
    private boolean autoDeleteTempFiles;
    private String tempFileDirectory;
    private String failureRedirectURL;
    private String defaultCharacterEncoding = DEFAULT_CHARACTER_ENCODING_VALUE;
    private boolean useRequestCharacterEncoding = false;
    private FilterConfig filterConfig;
    static /* synthetic */ Class class$com$iplanet$jato$Log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) {
        this.setFilterConfig(filterConfig);
        Class clazz = class$com$iplanet$jato$Log == null ? (class$com$iplanet$jato$Log = MultipartFormServletFilter.class$("com.iplanet.jato.Log")) : class$com$iplanet$jato$Log;
        synchronized (clazz) {
            if (Log.getServletContext() == null) {
                Log.setServletContext(filterConfig.getServletContext());
            }
        }
        String temp = filterConfig.getInitParameter(AUTO_DELETE_TEMP_FILES_INIT_PARAMETER);
        if (null != temp) {
            this.autoDeleteTempFiles = Boolean.valueOf(temp);
        }
        if (null != (temp = filterConfig.getInitParameter(USE_TEMP_FILES_INIT_PARAMETER))) {
            this.useTempFiles = Boolean.valueOf(temp);
        }
        if (this.useTempFiles) {
            this.tempFileDirectory = filterConfig.getInitParameter(TEMP_FILE_DIRECTORY_INIT_PARAMETER);
            if (this.tempFileDirectory != null && this.tempFileDirectory.trim().length() > 0) {
                try {
                    File test = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new File(this.tempFileDirectory));
                    this.deleteTempFile(test);
                }
                catch (IOException ioe) {
                    this.useTempFiles = false;
                    Log.log("Failure creating test file in directory \"" + (null == this.tempFileDirectory ? "DEFAULT" : this.tempFileDirectory) + "\"; disabling temp file for uploads", ioe);
                }
            }
        }
        if (null != (temp = filterConfig.getInitParameter(FILE_SIZE_LIMIT_INIT_PARAMETER))) {
            try {
                this.fileSizeLimit = Integer.parseInt(temp);
                if (this.fileSizeLimit < 0) {
                    this.fileSizeLimit = 0x100000;
                }
            }
            catch (NumberFormatException nfe) {
                Log.log("Invalid value for parameter \"fileSizeLimit\"; using default max byte size 1048576", nfe);
            }
        }
        if (null != (temp = filterConfig.getInitParameter(FILE_SIZE_HARD_LIMIT_INIT_PARAMETER))) {
            try {
                this.fileSizeHardLimit = Integer.parseInt(temp);
                if (this.fileSizeHardLimit < 0) {
                    this.fileSizeHardLimit = 0x200000;
                }
            }
            catch (NumberFormatException nfe) {
                Log.log("Invalid value for parameter \"fileSizeHardLimit\"; using default max byte size 2097152", nfe);
            }
        }
        if (null != (temp = filterConfig.getInitParameter(REQUEST_SIZE_LIMIT_INIT_PARAMETER))) {
            try {
                this.requestSizeLimit = Integer.parseInt(temp);
                if (this.requestSizeLimit < 0) {
                    this.requestSizeLimit = 0x400000;
                }
            }
            catch (NumberFormatException nfe) {
                Log.log("Invalid value for parameter \"requestSizeLimit\", using default max byte size 4194304", nfe);
            }
        }
        this.failureRedirectURL = filterConfig.getInitParameter(FAILURE_REDIRECT_URL_INIT_PARAMETER);
        if (this.failureRedirectURL != null && this.failureRedirectURL.trim().length() == 0) {
            this.failureRedirectURL = null;
        }
        if (null != (temp = filterConfig.getInitParameter(DEFAULT_CHARACTER_ENCODING_INIT_PARAMETER)) && temp.trim().length() != 0) {
            this.defaultCharacterEncoding = temp;
        }
        if (null != (temp = filterConfig.getInitParameter(USE_REQUEST_CHARACTER_ENCODING_INIT_PARAMETER)) && temp.trim().length() != 0) {
            this.useRequestCharacterEncoding = Boolean.valueOf(temp);
        }
        Log.log(8, "Filter parameter useTempFiles = " + this.useTempFiles);
        Log.log(8, "Filter parameter autoDeleteTempFiles = " + this.autoDeleteTempFiles);
        Log.log(8, "Filter parameter tempFileDirectory = " + this.tempFileDirectory);
        Log.log(8, "Filter parameter fileSizeLimit = " + this.fileSizeLimit);
        Log.log(8, "Filter parameter fileSizeHardLimit = " + this.fileSizeHardLimit);
        Log.log(8, "Filter parameter requestSizeLimit = " + this.requestSizeLimit);
        Log.log(8, "Filter parameter failureRedirectURL = " + this.failureRedirectURL);
        Log.log(8, "Filter parameter defaultCharacterEncoding = " + this.defaultCharacterEncoding);
        Log.log(8, "Filter parameter defaultCharacterEncoding = " + this.defaultCharacterEncoding);
    }

    public void destroy() {
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected void setFilterConfig(FilterConfig value) {
        this.filterConfig = value;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block15: {
            if (request.getContentType() != null && request.getContentType().startsWith(MULTIPART_CONTENT_TYPE_HEADER_PREFIX)) {
                if (request.getContentLength() >= this.requestSizeLimit) {
                    if (null != this.failureRedirectURL) {
                        try {
                            request.getInputStream().skip(1024L);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        try {
                            ((HttpServletResponse)response).sendRedirect(this.failureRedirectURL);
                            return;
                        }
                        catch (IOException ioe) {
                            Log.log("Failure attempting to redirect", ioe);
                        }
                    }
                    throw new IOException("Request cancelled because the Content-length \"" + request.getContentLength() + "\" is over the configurable limit of " + this.requestSizeLimit + " bytes; see filter init parameter " + REQUEST_SIZE_LIMIT_INIT_PARAMETER);
                }
                String temp = request.getContentType().substring(MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN).trim();
                String boundary = temp.substring(MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN);
                RequestWrapper requestWrapper = null;
                try {
                    try {
                        requestWrapper = new RequestWrapper(boundary, (HttpServletRequest)request, (HttpServletResponse)response);
                        chain.doFilter((ServletRequest)requestWrapper, response);
                    }
                    catch (CompleteRequestException cre) {
                        Object var10_10 = null;
                        if (null != requestWrapper) {
                            requestWrapper.cleanup();
                        }
                        break block15;
                    }
                    catch (Throwable th) {
                        throw new ServletException(th);
                    }
                    Object var10_9 = null;
                    if (null != requestWrapper) {
                        requestWrapper.cleanup();
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (null != requestWrapper) {
                        requestWrapper.cleanup();
                    }
                    throw throwable;
                }
            }
            chain.doFilter(request, response);
        }
    }

    private void deleteTempFile(File file) {
        if (file == null) {
            return;
        }
        try {
            if (!file.delete()) {
                Log.log("Temp file \"" + file.getPath() + "\" could not be deleted");
            }
        }
        catch (SecurityException e) {
            Log.log("Temp file \"" + file.getPath() + "\" could not be deleted; please adjust the security " + "policy for the container to grant file delete " + "privileges", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DASH = DASH;
        SEMICOLON = SEMICOLON;
        TWO_DASHES = TWO_DASHES;
        NAME_ATTRIBUTE = NAME_ATTRIBUTE;
        FILENAME_ATTRIBUTE = FILENAME_ATTRIBUTE;
        DOUBLE_QUOTE = DOUBLE_QUOTE;
        BLANK = BLANK;
        ASSIGNMENT = ASSIGNMENT;
        CONTENT_TYPE_HEADER_PREFIX = CONTENT_TYPE_HEADER_PREFIX;
        CONTENT_TYPE_HEADER_PREFIX_LEN = CONTENT_TYPE_HEADER_PREFIX.length();
        MULTIPART_CONTENT_TYPE_HEADER_PREFIX = MULTIPART_CONTENT_TYPE_HEADER_PREFIX;
        MULTIPART_CONTENT_TYPE_HEADER_PREFIX_LEN = MULTIPART_CONTENT_TYPE_HEADER_PREFIX.length();
        MULTIPART_CONTENT_TYPE_BOUNDARY_DEF = MULTIPART_CONTENT_TYPE_BOUNDARY_DEF;
        MULTIPART_CONTENT_TYPE_BOUNDARY_DEF_LEN = MULTIPART_CONTENT_TYPE_BOUNDARY_DEF.length();
        MULTIPART_CONTENT_DISPOSITION_PREFIX = MULTIPART_CONTENT_DISPOSITION_PREFIX;
        MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN = MULTIPART_CONTENT_DISPOSITION_PREFIX.length();
        TEMP_FILE_PREFIX = TEMP_FILE_PREFIX;
        TEMP_FILE_SUFFIX = null;
        TEMP_FILE_DIRECTORY_INIT_PARAMETER = TEMP_FILE_DIRECTORY_INIT_PARAMETER;
        USE_TEMP_FILES_INIT_PARAMETER = USE_TEMP_FILES_INIT_PARAMETER;
        AUTO_DELETE_TEMP_FILES_INIT_PARAMETER = AUTO_DELETE_TEMP_FILES_INIT_PARAMETER;
        FILE_SIZE_LIMIT_INIT_PARAMETER = FILE_SIZE_LIMIT_INIT_PARAMETER;
        FILE_SIZE_HARD_LIMIT_INIT_PARAMETER = FILE_SIZE_HARD_LIMIT_INIT_PARAMETER;
        REQUEST_SIZE_LIMIT_INIT_PARAMETER = REQUEST_SIZE_LIMIT_INIT_PARAMETER;
        FAILURE_REDIRECT_URL_INIT_PARAMETER = FAILURE_REDIRECT_URL_INIT_PARAMETER;
        DEFAULT_CHARACTER_ENCODING_INIT_PARAMETER = DEFAULT_CHARACTER_ENCODING_INIT_PARAMETER;
        USE_REQUEST_CHARACTER_ENCODING_INIT_PARAMETER = USE_REQUEST_CHARACTER_ENCODING_INIT_PARAMETER;
        CHARACTER_ENCODING_OVERRIDE_ATTRIBUTE_NAME = CHARACTER_ENCODING_OVERRIDE_ATTRIBUTE_NAME;
        DEFAULT_FILE_SIZE_LIMIT = 0x100000;
        DEFAULT_FILE_SIZE_HARD_LIMIT = 0x200000;
        DEFAULT_REQUEST_SIZE_LIMIT = 0x400000;
        DEFAULT_CHARACTER_ENCODING_VALUE = null;
        DEFAULT_USE_REQUEST_CHARACTER_ENCODING_FLAG = false;
    }

    public class RequestWrapper
    extends HttpServletRequestWrapper {
        private String contentDelimiter;
        private byte[] contentDelimiterBytes;
        private String currentLine;
        private String boundary;
        private Map localParameters;
        private HttpServletResponse response;
        private List deletableFiles = new ArrayList();
        private String encoding;

        public RequestWrapper(String boundary, HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.boundary = boundary;
            this.response = response;
            this.encoding = (String)request.getAttribute(MultipartFormServletFilter.CHARACTER_ENCODING_OVERRIDE_ATTRIBUTE_NAME);
            if (this.encoding == null && MultipartFormServletFilter.this.useRequestCharacterEncoding) {
                this.encoding = request.getCharacterEncoding();
            }
            if (this.encoding == null) {
                this.encoding = MultipartFormServletFilter.this.defaultCharacterEncoding;
            }
            Log.log(8, "RequestWrapper encoding = " + this.encoding);
            this.adaptParameters();
        }

        public void cleanup() {
            int i = 0;
            while (i < this.deletableFiles.size()) {
                File tempFile = (File)this.deletableFiles.get(i);
                MultipartFormServletFilter.this.deleteTempFile(tempFile);
                ++i;
            }
        }

        public String getParameter(String name) {
            Object value = this.localParameters.get(name);
            if (value instanceof String[]) {
                return ((String[])value)[0];
            }
            return (String)value;
        }

        public String[] getParameterValues(String name) {
            Object value = this.localParameters.get(name);
            if (value instanceof String[]) {
                return (String[])value;
            }
            return new String[]{(String)value};
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.localParameters.keySet());
        }

        public Map getParameterMap() {
            return this.localParameters;
        }

        protected void adaptParameters() {
            if (null == this.localParameters) {
                this.localParameters = new HashMap();
                Map wrappedParams = this.getRequest().getParameterMap();
                Set keySet = wrappedParams.keySet();
                Iterator it = keySet.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = wrappedParams.get(key);
                    if (Log.isLevelEnabled(8)) {
                        StringBuffer valueBuffer = new StringBuffer("[");
                        String[] stringArray = (String[])value;
                        if (stringArray != null) {
                            int i = 0;
                            while (i < stringArray.length) {
                                if (i > 0) {
                                    valueBuffer.append(", ");
                                }
                                valueBuffer.append(stringArray[i]);
                                ++i;
                            }
                        }
                        valueBuffer.append("]");
                        Log.log(8, "Adding servlet parameter: " + key + " = " + valueBuffer);
                    }
                    this.localParameters.put(key, value);
                }
                try {
                    this.transcribeDelimitedContent();
                }
                catch (IOException ioe) {
                    if (null != MultipartFormServletFilter.this.failureRedirectURL) {
                        try {
                            this.response.sendRedirect(MultipartFormServletFilter.this.failureRedirectURL);
                            throw new CompleteRequestException();
                        }
                        catch (IOException ioe2) {
                            Log.log("Failure attempting to redirect after IOException", ioe2);
                        }
                    }
                    throw new WrapperRuntimeException(ioe);
                }
            }
        }

        protected String readLine(DataInputStream input) throws IOException {
            byte current;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (-1 != (current = input.readByte())) {
                if (current != 13) {
                    baos.write(current);
                    continue;
                }
                byte next = input.readByte();
                if (-1 == next || next == 10) break;
                baos.write(current);
                baos.write(next);
            }
            baos.flush();
            return null == this.encoding ? baos.toString() : baos.toString(this.encoding);
        }

        protected void transcribeDelimitedContent() throws IOException {
            DataInputStream buffer = new DataInputStream(new BufferedInputStream((InputStream)this.getRequest().getInputStream()));
            this.currentLine = this.readLine(buffer);
            if (!this.currentLine.startsWith(MultipartFormServletFilter.DASH)) {
                this.warning("First line of input does not start with dash \"" + this.currentLine + MultipartFormServletFilter.DOUBLE_QUOTE);
                return;
            }
            this.contentDelimiter = this.currentLine;
            this.contentDelimiterBytes = this.contentDelimiter.getBytes();
            while (!this.currentLine.endsWith(MultipartFormServletFilter.TWO_DASHES)) {
                this.currentLine = this.readLine(buffer);
                if (!this.currentLine.startsWith(MultipartFormServletFilter.MULTIPART_CONTENT_DISPOSITION_PREFIX)) {
                    this.warning("Expected line to start with \"Content-Disposition: form-data;\"");
                    return;
                }
                String temp = this.currentLine.substring(MULTIPART_CONTENT_DISPOSITION_PREFIX_LEN).trim();
                String[] expressions = StringTokenizer2.tokenize(temp, MultipartFormServletFilter.SEMICOLON, true);
                String name = this.getContentDispositionNameAttribute(expressions);
                String filename = this.getContentDispositionFilenameAttribute(expressions);
                this.currentLine = this.readLine(buffer);
                if (this.currentLine.trim().equals(MultipartFormServletFilter.BLANK)) {
                    this.processFormField(buffer, name);
                    continue;
                }
                if (this.currentLine.startsWith(MultipartFormServletFilter.CONTENT_TYPE_HEADER_PREFIX)) {
                    this.processFile(buffer, name, filename, this.currentLine.substring(CONTENT_TYPE_HEADER_PREFIX_LEN).trim());
                    continue;
                }
                this.warning("Expected either blank line or \"Content-Type:\"");
                return;
            }
        }

        private String normalizeChar(char c) {
            if (c == '\r') {
                return "_13";
            }
            if (c == '\n') {
                return "_10";
            }
            return "  " + c;
        }

        protected void processFile(DataInputStream buffer, String fieldName, String fileName, String contentType) throws IOException {
            OutputStream output;
            this.readLine(buffer);
            File tempFile = null;
            if (MultipartFormServletFilter.this.useTempFiles) {
                tempFile = File.createTempFile(MultipartFormServletFilter.TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new File(MultipartFormServletFilter.this.tempFileDirectory));
                output = new BufferedOutputStream(new FileOutputStream(tempFile));
            } else {
                output = new ByteArrayOutputStream();
            }
            boolean inEOL = false;
            int uncommittedCount = 0;
            int byteCount = 0;
            while (true) {
                if (byteCount >= MultipartFormServletFilter.this.fileSizeHardLimit) {
                    throw new IOException("Request cancelled because file input field \"" + fieldName + "\" size is over the configurable limit " + "of " + MultipartFormServletFilter.this.fileSizeHardLimit + " bytes; see filter init parameter " + MultipartFormServletFilter.FILE_SIZE_HARD_LIMIT_INIT_PARAMETER);
                }
                byte current = buffer.readByte();
                if (inEOL) {
                    if (current == this.contentDelimiterBytes[uncommittedCount]) {
                        if (++uncommittedCount != this.contentDelimiterBytes.length) continue;
                        break;
                    }
                    if (++byteCount <= MultipartFormServletFilter.this.fileSizeLimit) {
                        output.write(13);
                    }
                    if (++byteCount <= MultipartFormServletFilter.this.fileSizeLimit) {
                        output.write(10);
                    }
                    int i = 0;
                    while (i < uncommittedCount) {
                        if (++byteCount <= MultipartFormServletFilter.this.fileSizeLimit) {
                            output.write(this.contentDelimiterBytes[i]);
                        }
                        ++i;
                    }
                    uncommittedCount = 0;
                    inEOL = false;
                }
                if (current != 13) {
                    if (++byteCount > MultipartFormServletFilter.this.fileSizeLimit) continue;
                    output.write(current);
                    continue;
                }
                byte next = buffer.readByte();
                while (next == 13) {
                    if (++byteCount <= MultipartFormServletFilter.this.fileSizeLimit) {
                        output.write(current);
                    }
                    next = buffer.readByte();
                }
                if (next != 10) {
                    if (++byteCount <= MultipartFormServletFilter.this.fileSizeLimit) {
                        output.write(current);
                    }
                    if (++byteCount > MultipartFormServletFilter.this.fileSizeLimit) continue;
                    output.write(next);
                    continue;
                }
                inEOL = true;
            }
            this.currentLine = this.contentDelimiter;
            this.currentLine = this.currentLine + buffer.readByte() + buffer.readByte();
            output.flush();
            MultipartContent info = new MultipartContent();
            info.setInputName(fieldName);
            info.setSubmittedFileName(fileName);
            info.setContentType(contentType);
            if (byteCount >= MultipartFormServletFilter.this.fileSizeLimit) {
                info.setDiscarded(true);
                if (tempFile != null) {
                    // empty if block
                }
                MultipartFormServletFilter.this.deleteTempFile(tempFile);
            } else if (MultipartFormServletFilter.this.useTempFiles) {
                info.setFile(tempFile);
                output.close();
                if (MultipartFormServletFilter.this.autoDeleteTempFiles) {
                    this.deletableFiles.add(tempFile);
                }
            } else {
                info.setBlob(((ByteArrayOutputStream)output).toByteArray());
            }
            Object existing = this.getRequest().getAttribute(fieldName);
            if (null == existing) {
                this.getRequest().setAttribute(fieldName, (Object)info);
            } else if (existing instanceof MultipartContent) {
                MultipartContent[] both = new MultipartContent[]{(MultipartContent)existing, info};
                this.getRequest().setAttribute(fieldName, (Object)both);
            } else if (existing instanceof MultipartContent[]) {
                MultipartContent[] current = (MultipartContent[])existing;
                MultipartContent[] newArray = new MultipartContent[current.length + 1];
                System.arraycopy(current, 0, newArray, 0, current.length);
                newArray[newArray.length - 1] = info;
                this.getRequest().setAttribute(fieldName, (Object)newArray);
            }
        }

        protected void processFormField(DataInputStream buffer, String fieldName) throws IOException {
            ArrayList<String> values = new ArrayList<String>();
            this.currentLine = this.readLine(buffer);
            while (!this.currentLine.startsWith(this.contentDelimiter)) {
                values.add(this.currentLine);
                this.currentLine = this.readLine(buffer);
            }
            if (Log.isLevelEnabled(8)) {
                StringBuffer valueBuffer = new StringBuffer("[");
                int i = 0;
                while (i < values.size()) {
                    if (i > 0) {
                        valueBuffer.append(", ");
                    }
                    valueBuffer.append(values.get(i));
                    ++i;
                }
                valueBuffer.append("]");
                Log.log(8, "Adding servlet parameter: " + fieldName + " = " + valueBuffer);
            }
            if (values.size() == 1) {
                this.localParameters.put(fieldName, values.get(0));
            } else {
                this.localParameters.put(fieldName, values.toArray(new String[values.size()]));
            }
        }

        protected String getContentDispositionNameAttribute(String[] expressions) {
            String[] nvp = StringTokenizer2.tokenize(expressions[0], MultipartFormServletFilter.ASSIGNMENT, true);
            return StringTokenizer2.replace(nvp[1], MultipartFormServletFilter.DOUBLE_QUOTE, MultipartFormServletFilter.BLANK);
        }

        protected String getContentDispositionFilenameAttribute(String[] expressions) {
            if (expressions.length == 1) {
                return null;
            }
            String[] nvp = StringTokenizer2.tokenize(expressions[1], MultipartFormServletFilter.ASSIGNMENT, true);
            return StringTokenizer2.replace(nvp[1], MultipartFormServletFilter.DOUBLE_QUOTE, MultipartFormServletFilter.BLANK);
        }

        private void warning(String msg) {
            Log.log(32, msg);
        }
    }
}

