/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AboutDialog;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminHandler;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ObjAdminHandler;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.SelectionEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Container;

public class AController
implements AdminEventListener {
    private ObjAdminHandler objAdminHandler;
    private BrokerAdminHandler brokerAdminHandler;
    private AboutDialog aboutDialog = null;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private AdminApp app;

    public AController(AdminApp adminApp) {
        this.app = adminApp;
        this.objAdminHandler = new ObjAdminHandler(adminApp, this);
        this.brokerAdminHandler = new BrokerAdminHandler(adminApp, this);
    }

    public void init() {
        this.app.getExplorer().setScrollToPath(false);
        this.objAdminHandler.init();
        this.brokerAdminHandler.init();
        this.app.getExplorer().expandAll();
        this.app.getExplorer().setScrollToPath(true);
    }

    public void adminEventDispatched(AdminEvent adminEvent) {
        if (adminEvent instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)adminEvent);
        } else if (adminEvent instanceof SelectionEvent) {
            this.handleSelectionEvents((SelectionEvent)adminEvent);
        } else if (adminEvent instanceof ObjAdminEvent) {
            this.handleObjAdminEvents((ObjAdminEvent)adminEvent);
        } else if (adminEvent instanceof BrokerAdminEvent) {
            this.handleBrokerAdminEvents((BrokerAdminEvent)adminEvent);
        } else if (adminEvent instanceof ConsoleActionEvent) {
            this.handleConsoleActionEvents((ConsoleActionEvent)adminEvent);
        }
    }

    private void handleDialogEvents(DialogEvent dialogEvent) {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        int n = dialogEvent.getDialogType();
        if (consoleObj instanceof ObjStoreAdminCObj) {
            this.objAdminHandler.handleDialogEvents(dialogEvent);
        } else if (consoleObj instanceof BrokerAdminCObj) {
            this.brokerAdminHandler.handleDialogEvents(dialogEvent);
        }
    }

    private void handleSelectionEvents(SelectionEvent selectionEvent) {
        ConsoleObj consoleObj = selectionEvent.getSelectedObj();
        Object object = selectionEvent.getSource();
        int n = selectionEvent.getType();
        boolean bl = true;
        if (object instanceof Container) {
            Container container = (Container)object;
            if (this.app.getInspector().isAncestorOf(container)) {
                bl = false;
            }
        }
        switch (n) {
            case 0: {
                this.app.setSelectedObj(consoleObj);
                if (bl) {
                    this.app.getInspector().clearSelection();
                    if (consoleObj.canBeInspected()) {
                        this.app.getInspector().inspect(consoleObj);
                    }
                } else {
                    this.app.getExplorer().clearSelection();
                }
                this.setActions(consoleObj);
                break;
            }
            case 2: {
                this.clearSelection();
            }
        }
    }

    private void handleObjAdminEvents(ObjAdminEvent objAdminEvent) {
        this.objAdminHandler.handleObjAdminEvents(objAdminEvent);
    }

    public void clearSelection() {
        this.app.setSelectedObj(null);
        this.app.getInspector().inspect(null);
        this.app.getActionManager().setActiveActions(0);
    }

    public void setActions(ConsoleObj consoleObj) {
        if (consoleObj == null) {
            return;
        }
        this.app.getActionManager().setActiveActions(consoleObj.getActiveActions());
        this.app.getMenubar().setConsoleObj(consoleObj);
        this.app.getToolbar().setConsoleObj(consoleObj);
    }

    private void handleBrokerAdminEvents(BrokerAdminEvent brokerAdminEvent) {
        this.brokerAdminHandler.handleBrokerAdminEvents(brokerAdminEvent);
    }

    private void handleConsoleActionEvents(ConsoleActionEvent consoleActionEvent) {
        int n = consoleActionEvent.getType();
        switch (n) {
            case 4: {
                this.doExit();
                break;
            }
            case 0: {
                this.doAbout();
                break;
            }
            case 2: {
                this.doExpandAll();
                break;
            }
            case 3: {
                this.doCollapseAll();
                break;
            }
            case 5: {
                this.doRefresh(consoleActionEvent);
            }
        }
    }

    private void doExit() {
        System.exit(0);
    }

    private void doAbout() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this.app.getFrame());
            this.aboutDialog.addAdminEventListener(this);
            this.aboutDialog.setLocationRelativeTo(this.app.getFrame());
        }
        this.aboutDialog.show();
    }

    public void doExpandAll() {
        this.app.getExplorer().expandAll();
    }

    public void doCollapseAll() {
        this.app.getExplorer().collapseAll();
    }

    public void doRefresh(ConsoleActionEvent consoleActionEvent) {
        ConsoleObj consoleObj = this.app.getSelectedObj();
        if (consoleObj instanceof ObjStoreAdminCObj) {
            this.objAdminHandler.handleConsoleActionEvents(consoleActionEvent);
        } else if (consoleObj instanceof BrokerAdminCObj) {
            this.brokerAdminHandler.handleConsoleActionEvents(consoleActionEvent);
        }
    }
}

